/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.FilterUtil;
import com.sun.tools.linker.filters.MethodDescriptor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RedundantBridgeMethodDetector
extends ClassAdapter {
    String className;
    private Set<MethodDescriptor> bridgeMethods;
    private Set<MethodDescriptor> regularMethods;
    private final String targetClassDesc;
    private final Collection<MethodDescriptor> resultContainer;
    public static final String OBJECT_TYPE_NAME = "java/lang/Object";
    public static final String OBJECT_TYPE_DESC = "Ljava/lang/Object;";

    public RedundantBridgeMethodDetector(ClassVisitor chain, String targetTaskDesc, Collection<MethodDescriptor> resultContainer) {
        super(chain);
        this.resultContainer = resultContainer;
        this.targetClassDesc = targetTaskDesc;
        this.bridgeMethods = new HashSet<MethodDescriptor>();
        this.regularMethods = new HashSet<MethodDescriptor>();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.className = name;
        super.visit(version, access, name, signature, superName, interfaces);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (FilterUtil.isBridge(access)) {
            this.bridgeMethods.add(new MethodDescriptor(this.className, name, desc, FilterUtil.isStatic(access)));
        } else {
            this.regularMethods.add(new MethodDescriptor(this.className, name, desc, FilterUtil.isStatic(access)));
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    public void visitEnd() {
        this.removeDuplicates(this.bridgeMethods, this.regularMethods, false);
        HashSet<MethodDescriptor> targetMethods = new HashSet<MethodDescriptor>();
        targetMethods.addAll(this.bridgeMethods);
        HashSet<MethodDescriptor> candidateMethods = new HashSet<MethodDescriptor>();
        for (MethodDescriptor md : targetMethods) {
            if (!Type.getReturnType((String)md.desc).equals((Object)Type.getType((String)this.targetClassDesc))) continue;
            candidateMethods.add(md);
        }
        targetMethods.removeAll(candidateMethods);
        this.removeDuplicates(targetMethods, candidateMethods, true);
        this.bridgeMethods.clear();
        this.regularMethods.clear();
        super.visitEnd();
    }

    void removeDuplicates(Set<MethodDescriptor> targetMethods, Set<MethodDescriptor> candidateMethods, boolean bridgeCompare) {
        block0: for (MethodDescriptor md : targetMethods) {
            for (MethodDescriptor candidate : candidateMethods) {
                Type retType;
                MethodDescriptor comparisonTarget;
                boolean foundTarget = false;
                if (!md.name.equals(candidate.name) || !md.owner.equals(candidate.owner)) continue;
                Type[] candidateArgTypes = Type.getArgumentTypes((String)candidate.desc);
                Type[] mdArgTypes = Type.getArgumentTypes((String)md.desc);
                if (candidateArgTypes.length == 0 && mdArgTypes.length == 0) {
                    foundTarget = true;
                } else {
                    for (int i = 0; i < candidateArgTypes.length; ++i) {
                        if (!candidateArgTypes[i].getDescriptor().equals(this.targetClassDesc)) continue;
                        foundTarget = true;
                        candidateArgTypes[i] = Type.getType((String)OBJECT_TYPE_DESC);
                    }
                }
                if (!foundTarget || !md.equals(comparisonTarget = new MethodDescriptor(candidate.owner, candidate.name, Type.getMethodDescriptor((Type)(retType = bridgeCompare ? Type.getReturnType((String)md.desc) : Type.getReturnType((String)candidate.desc)), (Type[])candidateArgTypes), candidate.isStatic))) continue;
                this.resultContainer.add(md);
                continue block0;
            }
        }
    }
}

