/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.AbstractFilter;
import com.sun.tools.linker.filters.ApplicationMapper;
import com.sun.tools.linker.filters.FilterUtil;
import com.sun.tools.linker.filters.MethodDescriptor;
import com.sun.tools.linker.model.ClassModel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.SimpleRemapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Renamer
extends AbstractFilter {
    Map<String, String> classMap = new HashMap<String, String>();
    HashMap<MethodDescriptor, MethodDescriptor> staticMap = new HashMap();
    Map<MethodDescriptor, MethodDescriptor> extensionMap = new HashMap<MethodDescriptor, MethodDescriptor>();
    private static final String KEY_PREFIX = "renamer.";
    private static final String KEY_CLASS_PREFIX = "renamer.class.";
    private static final String KEY_EXTENSION_PREFIX = "renamer.extension.";
    private static final String KEY_STATIC_PREFIX = "renamer.static.";

    @Override
    public String getName() {
        return "Renamer";
    }

    @Override
    public Collection<String> getIncompatibleUpstreamFilters() {
        return Collections.singleton("RetroLdc");
    }

    @Override
    public Collection<String> getRequiredFilters() {
        return Collections.singleton("ApplicationMapper");
    }

    @Override
    public void afterPreVisit() {
        ApplicationMapper am = (ApplicationMapper)this.getFilter("ApplicationMapper");
        for (Map.Entry entry : this.properties.entrySet()) {
            String methodName;
            String className;
            String sig;
            String classMethod;
            String classMethodSig;
            String key = (String)entry.getKey();
            if (!key.toLowerCase().startsWith(KEY_PREFIX)) continue;
            if (key.toLowerCase().startsWith(KEY_CLASS_PREFIX)) {
                String fromClassName = key.substring(KEY_CLASS_PREFIX.length()).replace('.', '/');
                String toClassName = ((String)entry.getValue()).replace('.', '/');
                this.debug(String.format("Mapping '%s' to '%s'%n", fromClassName, toClassName));
                this.classMap.put(fromClassName, toClassName);
                continue;
            }
            if (key.toLowerCase().startsWith(KEY_STATIC_PREFIX)) {
                classMethodSig = key.substring(KEY_STATIC_PREFIX.length());
                int parenIndex = classMethodSig.indexOf(40);
                if (parenIndex == -1) {
                    this.warning("Malformed static method descriptor: " + classMethodSig);
                    continue;
                }
                classMethod = classMethodSig.substring(0, parenIndex).replace('.', '/');
                sig = classMethodSig.substring(parenIndex);
                className = FilterUtil.getPathPart(classMethod, '/');
                methodName = FilterUtil.getNamePart(classMethod, '/');
                String altClass = ((String)entry.getValue()).replace('.', '/');
                this.staticMap.put(new MethodDescriptor(className, methodName, sig, true), new MethodDescriptor(altClass, methodName, sig, true));
                this.debug(String.format("Mapping '%s %s %s' to '%s'%n", className, methodName, sig, altClass));
                continue;
            }
            if (!key.toLowerCase().startsWith(KEY_EXTENSION_PREFIX)) continue;
            classMethodSig = key.substring(KEY_EXTENSION_PREFIX.length());
            int parenIndex = classMethodSig.indexOf(40);
            if (parenIndex == -1) {
                this.warning("Malformed extension method descriptor: " + classMethodSig);
                continue;
            }
            classMethod = classMethodSig.substring(0, parenIndex).replace('.', '/');
            sig = classMethodSig.substring(parenIndex);
            className = FilterUtil.getPathPart(classMethod, '/');
            methodName = FilterUtil.getNamePart(classMethod, '/');
            String altClassMethod = ((String)entry.getValue()).replace('.', '/');
            String altClassName = FilterUtil.getPathPart(altClassMethod, '/');
            String altMethodName = FilterUtil.getNamePart(altClassMethod, '/');
            String altSig = FilterUtil.pushArg(sig, className);
            this.extensionMap.put(new MethodDescriptor(className, methodName, sig, false), new MethodDescriptor(altClassName, altMethodName, altSig, true));
            this.debug(String.format("Mapping '%s %s %s' to '%s %s %s'%n", className, methodName, sig, altClassName, altMethodName, altSig));
            ClassModel cm = am.getClassModel(className);
            if (cm == null || cm.isPrivate()) continue;
            for (String s : am.enumerateSubclasses(className)) {
                this.extensionMap.put(new MethodDescriptor(s, methodName, sig, false), new MethodDescriptor(altClassName, altMethodName, altSig, true));
                this.debug(String.format("Mapping '%s %s %s' to '%s %s %s'%n", s, methodName, sig, altClassName, altMethodName, altSig));
            }
        }
    }

    @Override
    public ClassVisitor makeVisitor(ClassVisitor chain) {
        if (!this.classMap.isEmpty()) {
            chain = new RemappingClassAdapter(chain, (Remapper)new SimpleRemapper(this.classMap));
        }
        if (!this.staticMap.isEmpty() || !this.extensionMap.isEmpty()) {
            chain = new ClassAdapter((ClassVisitor)chain){

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    Object methodVisitor = super.visitMethod(access, name, desc, signature, exceptions);
                    if (methodVisitor != null) {
                        methodVisitor = new MethodAdapter((MethodVisitor)methodVisitor){

                            public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                                MethodDescriptor methodDescriptor = new MethodDescriptor(owner, name, desc, opcode == 184);
                                MethodDescriptor newMethod = Renamer.this.staticMap.get(methodDescriptor);
                                if (newMethod != null && opcode == 184) {
                                    super.visitMethodInsn(184, newMethod.owner, newMethod.name, newMethod.desc);
                                    Renamer.this.debug(String.format("Renamer: Mapping static method %s %s %s -> %s %s %s", owner, name, desc, newMethod.owner, newMethod.name, newMethod.desc));
                                    return;
                                }
                                newMethod = Renamer.this.extensionMap.get(methodDescriptor);
                                if (newMethod != null && (opcode == 182 || opcode == 185 || opcode == 183)) {
                                    super.visitMethodInsn(184, newMethod.owner, newMethod.name, newMethod.desc);
                                    Renamer.this.debug(String.format("Renamer: Mapping extension method %s %s %s -> %s %s %s", owner, name, desc, newMethod.owner, newMethod.name, newMethod.desc));
                                    return;
                                }
                                super.visitMethodInsn(opcode, owner, name, desc);
                            }
                        };
                    }
                    return methodVisitor;
                }
            };
        }
        return chain;
    }
}

