/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.AbstractFilter;
import com.sun.tools.linker.filters.FilterUtil;
import com.sun.tools.linker.filters.MethodDescriptor;
import com.sun.tools.linker.filters.RedundantBridgeMethodDetector;
import com.sun.tools.linker.filters.Renamer;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class RetroComparable
extends AbstractFilter {
    public static final String COMPARABLE_TYPE_NAME = "java/lang/Comparable";
    public static final String COMPARABLE_TYPE_DESC = "Ljava/lang/Comparable;";
    public static final String OBJECT_TYPE_NAME = "java/lang/Object";
    private static final String RETRO_COMPARABLE_CLASS = "com/sun/tools/linker/runtime/Comparable";
    private static final String RETRO_COMPARABLES_CLASS = "com/sun/tools/linker/runtime/Comparables";
    private Renamer renamer = new Renamer();
    private Set<MethodDescriptor> methodsToRemove = new HashSet<MethodDescriptor>();

    public String getName() {
        return "RetroComparable";
    }

    public ClassVisitor makePreVisitor(ClassVisitor chain) {
        return new RedundantBridgeMethodDetector(chain, COMPARABLE_TYPE_DESC, this.methodsToRemove);
    }

    public ClassVisitor makeVisitor(ClassVisitor chain) {
        return new ClassAdapter(this.renamer.makeVisitor(super.makeVisitor(chain))){
            String className;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                if (interfaces != null) {
                    for (int i = 0; i < interfaces.length; ++i) {
                        if (!interfaces[i].equals(RetroComparable.COMPARABLE_TYPE_NAME)) continue;
                        interfaces[i] = RetroComparable.RETRO_COMPARABLE_CLASS;
                    }
                }
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodDescriptor md = new MethodDescriptor(this.className, name, desc, FilterUtil.isStatic(access));
                if (RetroComparable.this.methodsToRemove.contains(md)) {
                    if (RetroComparable.this.isDebug) {
                        System.out.printf("RetroComparable: removing method " + md, new Object[0]);
                    }
                    return new EmptyVisitor();
                }
                return new MethodAdapter(super.visitMethod(access, name, desc, signature, exceptions)){

                    public void visitTypeInsn(int opcode, String type) {
                        if (opcode == 193 && type.equals(RetroComparable.COMPARABLE_TYPE_NAME)) {
                            this.visitMethodInsn(184, RetroComparable.RETRO_COMPARABLES_CLASS, "isComparable", "(Ljava/lang/Object;)Z");
                        } else if (opcode == 189 && type.equals(RetroComparable.COMPARABLE_TYPE_NAME)) {
                            this.visitTypeInsn(opcode, RetroComparable.OBJECT_TYPE_NAME);
                        } else {
                            super.visitTypeInsn(opcode, type);
                        }
                    }
                };
            }
        };
    }

    public void afterPreVisit() {
        this.renamer.classMap.put(COMPARABLE_TYPE_NAME, OBJECT_TYPE_NAME);
        this.renamer.extensionMap.put(new MethodDescriptor(COMPARABLE_TYPE_NAME, "compareTo", "(Ljava/lang/Object;)I", false), new MethodDescriptor(RETRO_COMPARABLES_CLASS, "compareTo", "(Ljava/lang/Object;Ljava/lang/Object;)I", true));
    }
}

