/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.AbstractFilter;
import java.util.Collection;
import java.util.Collections;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.commons.SimpleRemapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetroIterable
extends AbstractFilter {
    private static final String JAVA_LANG_ITERABLE = "java/lang/Iterable";
    private static final String RETRO_UTIL_CLASS = "com/sun/tools/linker/runtime/Utils";
    private static final String RETRO_ITERATABLE_CLASS = "com/sun/tools/linker/runtime/Iterable";
    private static final String RETRO_ITERATOR_METHOD_DESC = "(Ljava/lang/Object;)Ljava/util/Iterator;";
    private static final String ITERATOR_METHOD_NAME = "iterator";

    @Override
    public String getName() {
        return "RetroIterable";
    }

    @Override
    public Collection<String> getIncompatibleUpstreamFilters() {
        return Collections.singleton("RetroLdc");
    }

    @Override
    public ClassVisitor makeVisitor(ClassVisitor chain) {
        chain = new RemappingClassAdapter(chain, (Remapper)new SimpleRemapper(JAVA_LANG_ITERABLE, RETRO_ITERATABLE_CLASS));
        chain = new ClassAdapter((ClassVisitor)chain){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                return new MethodAdapter(super.visitMethod(access, name, desc, signature, exceptions)){

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        if (opcode == 185 && owner.equals(RetroIterable.JAVA_LANG_ITERABLE) && name.equals(RetroIterable.ITERATOR_METHOD_NAME)) {
                            this.visitMethodInsn(184, RetroIterable.RETRO_UTIL_CLASS, RetroIterable.ITERATOR_METHOD_NAME, RetroIterable.RETRO_ITERATOR_METHOD_DESC);
                        } else {
                            super.visitMethodInsn(opcode, owner, name, desc);
                        }
                    }
                };
            }
        };
        return chain;
    }
}

