/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.linker.filters;

import com.sun.tools.linker.filters.AbstractFilter;
import com.sun.tools.linker.filters.FilterUtil;
import com.sun.tools.linker.filters.MethodDescriptor;
import com.sun.tools.linker.filters.RedundantBridgeMethodDetector;
import com.sun.tools.linker.filters.Renamer;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodAdapter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class RetroNumber
extends AbstractFilter {
    public static final String NUMBER_TYPE_NAME = "java/lang/Number";
    public static final String NUMBER_TYPE_DESC = "Ljava/lang/Number;";
    public static final String OBJECT_TYPE_NAME = "java/lang/Object";
    public static final String OBJECT_TYPE_DESC = "Ljava/lang/Object;";
    private static final String RETRO_NUMERICS_CLASS = "com/sun/tools/linker/runtime/Numerics";
    private Renamer renamer = new Renamer();
    private Set<MethodDescriptor> methodsToRemove = new HashSet<MethodDescriptor>();

    public String getName() {
        return "RetroNumber";
    }

    public ClassVisitor makePreVisitor(ClassVisitor chain) {
        return new RedundantBridgeMethodDetector(chain, NUMBER_TYPE_DESC, this.methodsToRemove);
    }

    public ClassVisitor makeVisitor(ClassVisitor chain) {
        return new ClassAdapter(this.renamer.makeVisitor(super.makeVisitor(chain))){
            String className;

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.className = name;
                super.visit(version, access, name, signature, superName, interfaces);
            }

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodDescriptor md = new MethodDescriptor(this.className, name, desc, FilterUtil.isStatic(access));
                if (RetroNumber.this.methodsToRemove.contains(md)) {
                    if (RetroNumber.this.isDebug) {
                        System.out.printf("RetroNumber: removing method " + md, new Object[0]);
                    }
                    return new EmptyVisitor();
                }
                return new MethodAdapter(super.visitMethod(access, name, desc, signature, exceptions)){

                    public void visitTypeInsn(int opcode, String type) {
                        if (opcode == 193 && type.equals(RetroNumber.NUMBER_TYPE_NAME)) {
                            this.visitMethodInsn(184, RetroNumber.RETRO_NUMERICS_CLASS, "isNumber", "(Ljava/lang/Object;)Z");
                        } else {
                            super.visitTypeInsn(opcode, type);
                        }
                    }
                };
            }
        };
    }

    public void afterPreVisit() {
        this.renamer.classMap.put(NUMBER_TYPE_NAME, OBJECT_TYPE_NAME);
        this.renamer.extensionMap.put(new MethodDescriptor(NUMBER_TYPE_NAME, "byteValue", "()B", false), new MethodDescriptor(RETRO_NUMERICS_CLASS, "byteValue", "(Ljava/lang/Object;)B", true));
        this.renamer.extensionMap.put(new MethodDescriptor(NUMBER_TYPE_NAME, "shortValue", "()S", false), new MethodDescriptor(RETRO_NUMERICS_CLASS, "shortValue", "(Ljava/lang/Object;)S", true));
        this.renamer.extensionMap.put(new MethodDescriptor(NUMBER_TYPE_NAME, "intValue", "()I", false), new MethodDescriptor(RETRO_NUMERICS_CLASS, "intValue", "(Ljava/lang/Object;)I", true));
        this.renamer.extensionMap.put(new MethodDescriptor(NUMBER_TYPE_NAME, "longValue", "()J", false), new MethodDescriptor(RETRO_NUMERICS_CLASS, "longValue", "(Ljava/lang/Object;)J", true));
        this.renamer.extensionMap.put(new MethodDescriptor(NUMBER_TYPE_NAME, "floatValue", "()F", false), new MethodDescriptor(RETRO_NUMERICS_CLASS, "floatValue", "(Ljava/lang/Object;)F", true));
        this.renamer.extensionMap.put(new MethodDescriptor(NUMBER_TYPE_NAME, "doubleValue", "()D", false), new MethodDescriptor(RETRO_NUMERICS_CLASS, "doubleValue", "(Ljava/lang/Object;)D", true));
    }
}

