/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory;

import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.DefaultResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.formula.DefaultFormulaContext;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DesignTimeDataFactoryContext
implements DataFactoryContext {
    private Configuration configuration;
    private ResourceManager resourceManager;
    private ResourceKey contextKey;
    private ResourceBundleFactory resourceBundleFactory;
    private DataFactory contextFactory;
    private FormulaContext formulaContext;

    public DesignTimeDataFactoryContext() {
        this.configuration = ClassicEngineBoot.getInstance().getGlobalConfig();
        this.resourceManager = new ResourceManager();
        this.resourceBundleFactory = new DefaultResourceBundleFactory();
        this.formulaContext = new DefaultFormulaContext();
    }

    public DesignTimeDataFactoryContext(MasterReport report) {
        this(report.getConfiguration(), report.getResourceManager(), report.getContentBase(), MasterReport.computeAndInitResourceBundleFactory(report.getResourceBundleFactory(), report.getReportEnvironment()), report.getDataFactory());
    }

    public DesignTimeDataFactoryContext(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory) {
        this(configuration, resourceManager, contextKey, resourceBundleFactory, null);
    }

    public DesignTimeDataFactoryContext(Configuration configuration, ResourceManager resourceManager, ResourceKey contextKey, ResourceBundleFactory resourceBundleFactory, DataFactory contextFactory) {
        if (configuration == null) {
            throw new NullPointerException();
        }
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        if (resourceBundleFactory == null) {
            throw new NullPointerException();
        }
        this.contextFactory = contextFactory;
        this.configuration = configuration;
        this.resourceManager = resourceManager;
        this.contextKey = contextKey;
        this.resourceBundleFactory = resourceBundleFactory;
        this.formulaContext = new DefaultFormulaContext();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    @Override
    public ResourceKey getContextKey() {
        return this.contextKey;
    }

    @Override
    public ResourceBundleFactory getResourceBundleFactory() {
        return this.resourceBundleFactory;
    }

    @Override
    public DataFactory getContextDataFactory() {
        return this.contextFactory;
    }

    @Override
    public FormulaContext getFormulaContext() {
        return this.formulaContext;
    }
}

