/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.Func;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.Query;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogComboBoxModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModel;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModelEvent;
import org.pentaho.reporting.engine.classic.core.designtime.datafactory.editor.model.QueryDialogModelListener;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class DefaultQueryDialogModel<T>
implements QueryDialogModel<T> {
    private ArrayList<Query<T>> backend = new ArrayList();
    private ArrayList<QueryDialogModelListener> listeners = new ArrayList();
    private QueryDialogComboBoxModel<T> model = new QueryDialogComboBoxModel(this);
    private int selectedIndex = -1;
    private String globalScriptLanguage;
    private String globalScript;

    @Override
    public void addQuery(Query<T> query) {
        this.backend.add(query);
        final QueryDialogModelEvent<T> event = new QueryDialogModelEvent<T>(this, this.backend.size() - 1, query, -1, null);
        this.fireEvent(new Func<QueryDialogModelListener<T>>(){

            @Override
            public void run(QueryDialogModelListener<T> value) {
                value.queryAdded(event);
            }
        });
    }

    @Override
    public QueryDialogComboBoxModel<T> getQueries() {
        return this.model;
    }

    @Override
    public boolean isQuerySelected() {
        return this.selectedIndex != -1;
    }

    @Override
    public void setSelectedQuery(Query<T> query) {
        int newIndex;
        if (query != null) {
            newIndex = this.backend.indexOf(query);
            if (newIndex == -1) {
                throw new IllegalStateException();
            }
        } else {
            newIndex = -1;
        }
        if (newIndex == this.selectedIndex) {
            return;
        }
        Query<T> oldValue = this.getSelectedQuery();
        int oldIndex = this.selectedIndex;
        this.selectedIndex = newIndex;
        final QueryDialogModelEvent<T> event = new QueryDialogModelEvent<T>(this, this.selectedIndex, query, oldIndex, oldValue);
        this.fireEvent(new Func<QueryDialogModelListener<T>>(){

            @Override
            public void run(QueryDialogModelListener<T> value) {
                value.selectionChanged(event);
            }
        });
    }

    private void fireEvent(Func<QueryDialogModelListener<T>> delegate) {
        for (QueryDialogModelListener listener : this.listeners.toArray(new QueryDialogModelListener[this.listeners.size()])) {
            delegate.run(listener);
        }
    }

    @Override
    public Query<T> getSelectedQuery() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return this.backend.get(this.selectedIndex);
    }

    @Override
    public void removeQuery(Query<T> query) {
        QueryDialogModelEvent<T> event;
        int index = this.backend.indexOf(query);
        if (index == -1) {
            return;
        }
        Query<T> oldValue = this.backend.remove(index);
        if (index == this.selectedIndex) {
            this.selectedIndex = -1;
            event = new QueryDialogModelEvent<T>(this, this.selectedIndex, null, index, oldValue);
            this.fireEvent(new Func<QueryDialogModelListener<T>>(){

                @Override
                public void run(QueryDialogModelListener<T> value) {
                    value.selectionChanged(event);
                }
            });
        }
        event = new QueryDialogModelEvent<T>(this, -1, null, index, oldValue);
        this.fireEvent(new Func<QueryDialogModelListener<T>>(){

            @Override
            public void run(QueryDialogModelListener<T> value) {
                value.queryRemoved(event);
            }
        });
    }

    @Override
    public void updateQuery(int index, Query<T> query) {
        Query<T> oldValue = this.backend.set(index, query);
        if (ObjectUtilities.equal(oldValue, query)) {
            return;
        }
        final QueryDialogModelEvent<T> event = new QueryDialogModelEvent<T>(this, index, query, index, oldValue);
        this.fireEvent(new Func<QueryDialogModelListener<T>>(){

            @Override
            public void run(QueryDialogModelListener<T> value) {
                value.queryUpdated(event);
            }
        });
    }

    @Override
    public void clear() {
        this.setSelectedQuery(null);
        this.backend.clear();
        final QueryDialogModelEvent event = new QueryDialogModelEvent(this);
        this.fireEvent(new Func<QueryDialogModelListener<T>>(){

            @Override
            public void run(QueryDialogModelListener<T> value) {
                value.queryDataChanged(event);
            }
        });
    }

    @Override
    public void updateSelectedQuery(Query<T> newQuery) {
        this.updateQuery(this.selectedIndex, newQuery);
    }

    @Override
    public int getQueryCount() {
        return this.backend.size();
    }

    @Override
    public Query<T> getQuery(int index) {
        if (index >= this.backend.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.backend.get(index);
    }

    @Override
    public void setGlobalScripting(String lang, String script) {
        if (ObjectUtilities.equal((Object)lang, (Object)this.globalScriptLanguage) && ObjectUtilities.equal((Object)script, (Object)this.globalScript)) {
            return;
        }
        this.globalScript = script;
        this.globalScriptLanguage = lang;
        final QueryDialogModelEvent event = new QueryDialogModelEvent(this);
        this.fireEvent(new Func<QueryDialogModelListener<T>>(){

            @Override
            public void run(QueryDialogModelListener<T> value) {
                value.globalScriptChanged(event);
            }
        });
    }

    @Override
    public String getGlobalScriptLanguage() {
        return this.globalScriptLanguage;
    }

    @Override
    public String getGlobalScript() {
        return this.globalScript;
    }

    @Override
    public void addQueryDialogModelListener(QueryDialogModelListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeQueryDialogModelListener(QueryDialogModelListener<T> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Iterator<Query<T>> iterator() {
        return Collections.unmodifiableList(this.backend).iterator();
    }
}

