/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.layout.model.BlockRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.CanvasRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderLength;
import org.pentaho.reporting.engine.classic.core.layout.model.context.BoxDefinition;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnGroupNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableColumnNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRowRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableSectionRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumn;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumnGroup;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumnModel;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRowModel;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateStructuralProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.util.ProcessUtility;
import org.pentaho.reporting.engine.classic.core.util.IntList;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public class TableValidationStep
extends IterateStructuralProcessStep {
    private static final long MAX_AUTO = StrictGeomUtility.toInternalValue(8.796093022208E12);
    private TableInfoStructure currentTable;
    private TableColumnGroup currentColumnGroup;

    public void validate(LogicalPageBox box) {
        this.currentTable = null;
        this.startProcessing(box);
        if (this.currentTable != null) {
            throw new IllegalStateException();
        }
    }

    private boolean abortIfNoTable(RenderBox box) {
        if (box.getTableRefCount() == 0) {
            return false;
        }
        if (box.getTableValidationAge() == box.getChangeTracker()) {
            return false;
        }
        box.setTableValidationAge(box.getChangeTracker());
        return true;
    }

    @Override
    protected boolean startCanvasBox(CanvasRenderBox box) {
        return this.abortIfNoTable(box);
    }

    @Override
    protected boolean startBlockBox(BlockRenderBox box) {
        return this.abortIfNoTable(box);
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        return this.abortIfNoTable(box);
    }

    @Override
    protected boolean startOtherBox(RenderBox box) {
        return this.abortIfNoTable(box);
    }

    @Override
    protected boolean startRowBox(RenderBox box) {
        return this.abortIfNoTable(box);
    }

    @Override
    protected boolean startAutoBox(RenderBox box) {
        if (this.currentTable != null) {
            if (box.getParent().getLayoutNodeType() == 266242) {
                this.currentTable.setHeaderOrFooterSection(false);
            }
            return true;
        }
        return this.abortIfNoTable(box);
    }

    @Override
    protected void finishAutoBox(RenderBox box) {
        if (this.currentTable != null) {
            box.setContainsReservedContent(this.currentTable.isHeaderOrFooterSection());
        }
    }

    @Override
    protected boolean startTableBox(TableRenderBox table) {
        long age;
        long changeTracker = table.getChangeTracker();
        if (changeTracker == (age = table.getTableValidationAge())) {
            return false;
        }
        this.currentTable = new TableInfoStructure(table, this.currentTable);
        return true;
    }

    @Override
    protected void finishTableBox(TableRenderBox table) {
        long age;
        long changeTracker = table.getChangeTracker();
        if (changeTracker == (age = table.getTableValidationAge())) {
            return;
        }
        table.setTableValidationAge(age);
        table.setPredefinedColumnsValidated(true);
        this.currentTable = this.currentTable.pop();
    }

    @Override
    protected boolean startTableColumnGroupBox(TableColumnGroupNode box) {
        if (this.currentTable == null) {
            return false;
        }
        if (this.currentTable.table.isPredefinedColumnsValidated()) {
            return false;
        }
        this.currentColumnGroup = new TableColumnGroup(box.getBoxDefinition().getBorder());
        this.currentColumnGroup.setColSpan(box.getColSpan());
        return true;
    }

    @Override
    protected void processTableColumn(TableColumnNode node) {
        if (this.currentTable == null) {
            return;
        }
        if (this.currentTable.table.isPredefinedColumnsValidated()) {
            return;
        }
        Border border = node.getBoxDefinition().getBorder();
        RenderLength length = node.getBoxDefinition().getMinimumWidth();
        if (this.currentColumnGroup != null) {
            this.currentColumnGroup.addColumn(new TableColumn(border, length, false));
        } else {
            TableColumnGroup currentColumnGroup = new TableColumnGroup(BoxDefinition.EMPTY.getBorder());
            currentColumnGroup.addColumn(new TableColumn(border, length, false));
            this.currentTable.columnModel.addColumnGroup(currentColumnGroup);
        }
    }

    @Override
    protected void finishTableColumnGroupBox(TableColumnGroupNode box) {
        if (this.currentTable == null) {
            return;
        }
        if (this.currentTable.table.isPredefinedColumnsValidated()) {
            return;
        }
        while (this.currentColumnGroup.getColumnCount() < box.getColSpan()) {
            this.currentColumnGroup.addColumn(new TableColumn(this.currentColumnGroup.getBorder(), RenderLength.AUTO, false));
        }
        this.currentTable.columnModel.addColumnGroup(this.currentColumnGroup);
        this.currentColumnGroup = null;
    }

    @Override
    protected boolean startTableSectionBox(TableSectionRenderBox box) {
        if (this.currentTable == null) {
            return false;
        }
        if (this.currentTable.getSectionRenderBox() != null) {
            return true;
        }
        this.currentTable.setSectionRenderBox(box);
        box.setContainsReservedContent(box.getDisplayRole() != TableSectionRenderBox.Role.BODY);
        box.getRowModel().initialize(this.currentTable.getTable());
        return true;
    }

    @Override
    protected void finishTableSectionBox(TableSectionRenderBox box) {
        int i;
        if (this.currentTable == null) {
            return;
        }
        if (this.currentTable.getSectionRenderBox() != box) {
            return;
        }
        IntList rowSpans = this.currentTable.rowSpans;
        int missingRows = 0;
        for (i = 0; i < rowSpans.size(); ++i) {
            int value = rowSpans.get(i);
            if (missingRows >= value) continue;
            missingRows = value;
        }
        for (i = 0; i < missingRows; ++i) {
            this.currentTable.rowModel.addRow();
        }
        box.getRowModel().validatePreferredSizes();
        this.currentTable.setSectionRenderBox(null);
    }

    @Override
    protected boolean startTableRowBox(TableRowRenderBox box) {
        if (this.currentTable == null) {
            return false;
        }
        if (this.currentTable.getSectionRenderBox() == null) {
            return false;
        }
        this.currentTable.resetCellPosition();
        box.setBodySection(this.currentTable.isBodySection());
        if (this.currentTable.rowIndex == -1 && box.getRowIndex() != -1) {
            this.currentTable.rowIndex = box.getRowIndex();
            return true;
        }
        ++this.currentTable.rowIndex;
        box.setRowIndex(this.currentTable.rowIndex);
        if (this.currentTable.rowModel.getRowCount() <= this.currentTable.rowIndex) {
            this.currentTable.rowModel.addRow();
        }
        return true;
    }

    @Override
    protected void finishTableRowBox(TableRowRenderBox box) {
        int value;
        int i;
        if (this.currentTable == null) {
            return;
        }
        if (this.currentTable.getSectionRenderBox() == null) {
            return;
        }
        IntList rowSpans = this.currentTable.rowSpans;
        int maxRowSpan = 0;
        for (i = 0; i < rowSpans.size(); ++i) {
            value = rowSpans.get(i);
            maxRowSpan = Math.max(maxRowSpan, value);
        }
        for (i = 0; i < rowSpans.size(); ++i) {
            value = rowSpans.get(i);
            rowSpans.set(i, Math.max(0, value - 1));
        }
    }

    @Override
    protected boolean startTableCellBox(TableCellRenderBox box) {
        if (this.currentTable == null) {
            return false;
        }
        if (this.currentTable.getSectionRenderBox() == null) {
            return false;
        }
        int rowSpan = box.getRowSpan();
        int colSpan = box.getColSpan();
        int startPos = this.currentTable.increaseCellPosition(colSpan, rowSpan);
        while (this.currentTable.columnModel.getColumnCount() < startPos + colSpan) {
            this.currentTable.columnModel.addAutoColumn();
        }
        box.setColumnIndex(startPos);
        box.setBodySection(this.currentTable.isBodySection());
        BoxDefinition boxDefinition = box.getBoxDefinition();
        long preferredHeight = boxDefinition.getPreferredHeight().resolve(0L);
        long minHeight = boxDefinition.getMinimumHeight().resolve(0L);
        long maxHeight = boxDefinition.getMaximumHeight().resolve(0L, MAX_AUTO);
        long preferredSize = ProcessUtility.computeLength(minHeight, maxHeight, preferredHeight);
        this.currentTable.updateDefinedSize(rowSpan, preferredSize);
        return true;
    }

    private static class TableInfoStructure {
        private TableRenderBox table;
        private TableInfoStructure parent;
        private TableColumnModel columnModel;
        private TableSectionRenderBox sectionRenderBox;
        private IntList rowSpans;
        private TableRowModel rowModel;
        protected int tableCellPosition;
        protected int rowIndex;
        private boolean bodySection;
        private boolean headerOrFooterSection;

        public TableInfoStructure(TableRenderBox table, TableInfoStructure parent) {
            this.table = table;
            this.parent = parent;
            this.columnModel = table.getColumnModel();
            this.rowSpans = new IntList(10);
        }

        public void resetCellPosition() {
            this.tableCellPosition = 0;
        }

        private boolean isCellAreaClear(int pos, int colSpan) {
            int maxIdx = Math.min(pos + colSpan, this.rowSpans.size());
            for (int i = pos; i < maxIdx; ++i) {
                if (this.rowSpans.get(this.tableCellPosition) <= 0) continue;
                return false;
            }
            return true;
        }

        public int increaseCellPosition(int colSpan, int rowSpan) {
            while (this.tableCellPosition < this.rowSpans.size() && !this.isCellAreaClear(this.tableCellPosition, colSpan)) {
                ++this.tableCellPosition;
            }
            int retval = this.tableCellPosition;
            for (int i = this.tableCellPosition; i < this.tableCellPosition + colSpan; ++i) {
                if (i < this.rowSpans.size()) {
                    this.rowSpans.set(i, Math.max(rowSpan, this.rowSpans.get(i)));
                    continue;
                }
                this.rowSpans.add(rowSpan);
            }
            this.tableCellPosition += colSpan;
            return retval;
        }

        public TableInfoStructure pop() {
            return this.parent;
        }

        public TableSectionRenderBox getSectionRenderBox() {
            return this.sectionRenderBox;
        }

        public void setSectionRenderBox(TableSectionRenderBox sectionRenderBox) {
            this.rowSpans.clear();
            this.sectionRenderBox = sectionRenderBox;
            if (this.sectionRenderBox != null) {
                this.rowModel = sectionRenderBox.getRowModel();
                this.bodySection = sectionRenderBox.getDisplayRole() == TableSectionRenderBox.Role.BODY;
                this.headerOrFooterSection = !this.bodySection;
            } else {
                this.rowModel = null;
                this.bodySection = false;
            }
            this.rowIndex = -1;
        }

        public boolean isHeaderOrFooterSection() {
            return this.headerOrFooterSection;
        }

        public void setHeaderOrFooterSection(boolean headerOrFooterSection) {
            this.headerOrFooterSection = headerOrFooterSection;
        }

        public boolean isBodySection() {
            return this.bodySection;
        }

        public TableRenderBox getTable() {
            return this.table;
        }

        public TableColumnModel getColumnModel() {
            return this.columnModel;
        }

        public void updateDefinedSize(int rowSpan, long preferredSize) {
            this.rowModel.updateDefinedSize(this.rowIndex, rowSpan, preferredSize);
        }
    }
}

