/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process.text;

import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphPoolBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.layout.process.AbstractMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateSimpleStructureProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.text.LineBreakIterator;
import org.pentaho.reporting.engine.classic.core.layout.process.text.LineBreakIteratorState;
import org.pentaho.reporting.engine.classic.core.layout.process.text.ParagraphFontMetricsImpl;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextSpec;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextSpecProducer;
import org.pentaho.reporting.engine.classic.core.layout.process.text.TextMinorAxisLayoutStep;
import org.pentaho.reporting.engine.classic.core.layout.process.text.WordBreakingLineIterator;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisNodeContext;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.TextWrap;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.ArgumentNullException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class ComplexTextMinorAxisLayoutStep
extends IterateSimpleStructureProcessStep
implements TextMinorAxisLayoutStep {
    private static final Log logger = LogFactory.getLog(ComplexTextMinorAxisLayoutStep.class);
    private final boolean strictCompatibility;
    private final OutputProcessorMetaData metaData;
    private final ResourceManager resourceManager;
    private MinorAxisNodeContext nodeContext;

    public ComplexTextMinorAxisLayoutStep(OutputProcessorMetaData metaData, ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        ArgumentNullException.validate((String)"metaData", (Object)metaData);
        this.metaData = metaData;
        this.strictCompatibility = this.getMetaData().isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY);
    }

    @Override
    public void process(ParagraphRenderBox box, MinorAxisNodeContext nodeContext, PageGrid pageGrid) {
        this.nodeContext = nodeContext;
        this.processParagraphChildsComplex(box);
    }

    public MinorAxisNodeContext getNodeContext() {
        return this.nodeContext;
    }

    public OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    protected void processParagraphChildsComplex(ParagraphRenderBox box) {
        box.clearLayout();
        if (box.isComplexParagraph()) {
            RenderBox lineBoxContainer = box.getLineboxContainer();
            StyleSheet layoutContext = box.getStyleSheet();
            for (RenderNode paragraphContainer = lineBoxContainer.getFirstChild(); paragraphContainer != null; paragraphContainer = paragraphContainer.getNext()) {
                if (paragraphContainer.getNodeType() != 322) {
                    throw new IllegalStateException("Expected ParagraphPoolBox elements.");
                }
                ParagraphPoolBox paragraph = (ParagraphPoolBox)paragraphContainer;
                this.addGeneratedComplexTextLines(box, paragraph, layoutContext);
            }
        } else {
            ParagraphPoolBox lineBoxContainer = (ParagraphPoolBox)box.getEffectiveLineboxContainer();
            StyleSheet layoutContext = box.getStyleSheet();
            this.addGeneratedComplexTextLines(box, lineBoxContainer, layoutContext);
        }
    }

    private FontRenderContext createFontRenderContext(StyleSheet layoutContext) {
        boolean antiAliasing = RenderUtility.isFontSmooth(layoutContext, this.getMetaData());
        return new FontRenderContext(null, antiAliasing, true);
    }

    private void addGeneratedComplexTextLines(ParagraphRenderBox box, ParagraphPoolBox lineBoxContainer, StyleSheet layoutContext) {
        this.updateNodeContextWidth(box);
        if (TextWrap.NONE.equals(box.getStyleSheet().getStyleProperty(TextStyleKeys.TEXT_WRAP))) {
            this.addCompleteLine(box, lineBoxContainer, layoutContext);
            return;
        }
        RichTextSpec richText = RichTextSpecProducer.compute(lineBoxContainer, this.metaData, this.resourceManager);
        LineBreakIterator lineIterator = this.createLineBreakIterator(box, layoutContext, richText);
        ArrayList<RenderableComplexText> lines = new ArrayList<RenderableComplexText>();
        ParagraphFontMetricsImpl metrics = new ParagraphFontMetricsImpl();
        while (lineIterator.hasNext()) {
            LineBreakIteratorState state = lineIterator.next();
            RenderableComplexText text = richText.create(lineBoxContainer, state.getStart(), state.getEnd());
            text.setTextLayout(state.getTextLayout());
            metrics.update(state.getTextLayout());
            lines.add(text);
        }
        double height = metrics.getLineHeight();
        for (RenderableComplexText text : lines) {
            RenderBox line = this.generateLine(box, lineBoxContainer, text, height, metrics);
            box.addGeneratedChild(line);
        }
    }

    private LineBreakIterator createLineBreakIterator(ParagraphRenderBox box, StyleSheet layoutContext, RichTextSpec richText) {
        boolean breakOnWordBoundary;
        AttributedCharacterIterator ci = richText.createAttributedCharacterIterator();
        FontRenderContext fontRenderContext = this.createFontRenderContext(layoutContext);
        boolean bl = breakOnWordBoundary = this.strictCompatibility || layoutContext.getBooleanStyleProperty(TextStyleKeys.WORDBREAK);
        if (breakOnWordBoundary) {
            return new WordBreakingLineIterator(box, fontRenderContext, ci, richText.getText());
        }
        return new LineBreakIterator(box, fontRenderContext, ci);
    }

    private void addCompleteLine(ParagraphRenderBox box, ParagraphPoolBox lineBoxContainer, StyleSheet layoutContext) {
        RichTextSpec richText = RichTextSpecProducer.compute(lineBoxContainer, this.metaData, this.resourceManager);
        FontRenderContext fontRenderContext = this.createFontRenderContext(layoutContext);
        TextLayout textLayout = new TextLayout(richText.createAttributedCharacterIterator(), fontRenderContext);
        double height = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        RenderableComplexText text = richText.create(lineBoxContainer);
        text.setTextLayout(textLayout);
        ParagraphFontMetricsImpl metrics = new ParagraphFontMetricsImpl();
        metrics.update(textLayout);
        RenderBox line = this.generateLine(box, lineBoxContainer, text, height, metrics);
        this.getNodeContext().updateX2(line.getCachedX2());
        box.addGeneratedChild(line);
    }

    private RenderBox generateLine(ParagraphRenderBox paragraph, ParagraphPoolBox lineBoxContainer, RenderableComplexText text, double height, ParagraphFontMetricsImpl metrics) {
        TextLayout textLayout = text.getTextLayout();
        text.setCachedHeight(Math.max(StrictGeomUtility.toInternalValue(height), lineBoxContainer.getLineHeight()));
        text.setCachedWidth(StrictGeomUtility.toInternalValue(textLayout.getAdvance()));
        text.setParagraphFontMetrics(metrics);
        MinorAxisNodeContext nodeContext = this.getNodeContext();
        long alignmentX = RenderUtility.computeHorizontalAlignment(paragraph.getTextAlignment(), nodeContext.getContentAreaWidth(), StrictGeomUtility.toInternalValue(textLayout.getAdvance()));
        text.setCachedX(alignmentX + nodeContext.getX());
        RenderBox line = (RenderBox)paragraph.getPool().deriveFrozen(false);
        line.addGeneratedChild(text);
        line.setCachedX(alignmentX + nodeContext.getX());
        line.setCachedWidth(nodeContext.getContentAreaWidth());
        return line;
    }

    private void updateNodeContextWidth(ParagraphRenderBox paragraph) {
        MinorAxisNodeContext nodeContext = this.getNodeContext();
        boolean overflowX = paragraph.getStaticBoxLayoutProperties().isOverflowX();
        long lineEnd = overflowX ? nodeContext.getX1() + AbstractMinorAxisLayoutStep.OVERFLOW_DUMMY_WIDTH : nodeContext.getX2();
        long firstLineIndent = 0L;
        long lineStart = Math.min(lineEnd, nodeContext.getX1() + firstLineIndent);
        if (lineEnd - lineStart <= 0L) {
            long minimumChunkWidth = paragraph.getPool().getMinimumChunkWidth();
            nodeContext.updateX2(lineStart + minimumChunkWidth);
            logger.warn((Object)("Auto-Corrected zero-width first-line on paragraph - " + paragraph.getName()));
        } else if (!overflowX) {
            nodeContext.updateX2(lineEnd);
        }
    }
}

