/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementType;
import org.pentaho.reporting.engine.classic.core.metadata.ElementTypeRegistry;

public class ElementTypePropertyEditor
implements PropertyEditor {
    private ElementType value;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public void setValue(Object value) {
        ElementType oldValue = this.value;
        this.value = value instanceof ElementType ? (ElementType)value : null;
        this.propertyChangeSupport.firePropertyChange(null, oldValue, this.value);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public String getJavaInitializationString() {
        if (this.value == null) {
            return "null";
        }
        return this.value.getClass().getName() + "()";
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        return this.value.getMetaData().getName();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        try {
            this.setValue(ElementTypeRegistry.getInstance().getElementType(text).create());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("This is not a valid property-value: " + text);
        }
    }

    @Override
    public String[] getTags() {
        ElementMetaData[] datas = ElementTypeRegistry.getInstance().getAllElementTypes();
        String[] tags = new String[datas.length];
        for (int i = 0; i < datas.length; ++i) {
            ElementMetaData data = datas[i];
            tags[i] = data.getName();
        }
        return tags;
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

