/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.base.about;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.about.LibraryPanel;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.about.SystemPropertiesPanel;
import org.pentaho.reporting.libraries.base.versioning.Licenses;
import org.pentaho.reporting.libraries.base.versioning.ProjectInformation;

public class AboutDialog
extends JDialog {
    public static final Dimension PREFERRED_SIZE = new Dimension(560, 360);
    public static final Border STANDARD_BORDER = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private ResourceBundle resources;
    private String application;
    private String version;
    private String copyright;
    private String info;
    private String licence;

    public AboutDialog(String title, ProjectInformation project) {
        this.init(title, project);
    }

    public AboutDialog(Frame owner, String title, ProjectInformation project) {
        super(owner);
        this.init(title, project);
    }

    public AboutDialog(Dialog owner, String title, ProjectInformation project) {
        super(owner);
        this.init(title, project);
    }

    private void init(String title, ProjectInformation libraries) {
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.application = libraries.getName();
        this.version = libraries.getVersion();
        this.copyright = libraries.getCopyright();
        this.info = libraries.getInfo();
        this.licence = "GPL".equalsIgnoreCase(libraries.getLicenseName()) ? Licenses.getInstance().getGPL() : ("LGPL".equalsIgnoreCase(libraries.getLicenseName()) ? Licenses.getInstance().getLGPL() : libraries.getLicenseName());
        this.resources = ResourceBundle.getBundle("org.pentaho.reporting.engine.classic.core.modules.gui.base.messages.messages");
        JPanel content = new JPanel(new BorderLayout());
        content.setBorder(STANDARD_BORDER);
        JTabbedPane tabs = this.createTabs(libraries);
        content.add(tabs);
        this.setContentPane(content);
        this.pack();
    }

    @Override
    public Dimension getPreferredSize() {
        return PREFERRED_SIZE;
    }

    private JTabbedPane createTabs(ProjectInformation info) {
        JTabbedPane tabs = new JTabbedPane();
        JPanel aboutPanel = this.createAboutPanel(info);
        aboutPanel.setBorder(STANDARD_BORDER);
        String aboutTab = this.resources.getString("about-frame.tab.about");
        tabs.add(aboutTab, aboutPanel);
        SystemPropertiesPanel systemPanel = new SystemPropertiesPanel();
        systemPanel.setBorder(STANDARD_BORDER);
        String systemTab = this.resources.getString("about-frame.tab.system");
        tabs.add(systemTab, systemPanel);
        return tabs;
    }

    private JPanel createAboutPanel(ProjectInformation info) {
        JPanel about = new JPanel(new BorderLayout());
        JPanel details = this.createAboutTab();
        boolean includetabs = false;
        JTabbedPane tabs = new JTabbedPane();
        if (this.licence != null) {
            JPanel licencePanel = this.createLicencePanel();
            licencePanel.setBorder(STANDARD_BORDER);
            String licenceTab = this.resources.getString("about-frame.tab.licence");
            tabs.add(licenceTab, licencePanel);
            includetabs = true;
        }
        if (info != null) {
            LibraryPanel librariesPanel = new LibraryPanel(info);
            librariesPanel.setBorder(STANDARD_BORDER);
            String librariesTab = this.resources.getString("about-frame.tab.libraries");
            tabs.add(librariesTab, librariesPanel);
            includetabs = true;
        }
        about.add((Component)details, "North");
        if (includetabs) {
            about.add(tabs);
        }
        return about;
    }

    private JPanel createAboutTab() {
        JPanel textPanel = new JPanel(new GridLayout(4, 1, 0, 4));
        JPanel appPanel = new JPanel();
        JLabel appLabel = new JLabel(this.application);
        appLabel.setHorizontalTextPosition(0);
        appPanel.add(appLabel);
        JPanel verPanel = new JPanel();
        JLabel verLabel = new JLabel(this.version);
        verLabel.setHorizontalTextPosition(0);
        verPanel.add(verLabel);
        JPanel copyrightPanel = new JPanel();
        JLabel copyrightLabel = new JLabel(this.copyright);
        copyrightLabel.setHorizontalTextPosition(0);
        copyrightPanel.add(copyrightLabel);
        JPanel infoPanel = new JPanel();
        JLabel infoLabel = new JLabel(this.info);
        infoLabel.setHorizontalTextPosition(0);
        infoPanel.add(infoLabel);
        textPanel.add(appPanel);
        textPanel.add(verPanel);
        textPanel.add(copyrightPanel);
        textPanel.add(infoPanel);
        return textPanel;
    }

    private JPanel createLicencePanel() {
        JPanel licencePanel = new JPanel(new BorderLayout());
        JTextArea area = new JTextArea(this.licence);
        area.setLineWrap(true);
        area.setWrapStyleWord(true);
        area.setCaretPosition(0);
        area.setEditable(false);
        licencePanel.add(new JScrollPane(area));
        return licencePanel;
    }
}

