/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.csv;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportInterruptedException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.layout.output.AbstractReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.csv.CSVTableExportPlugin;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.csv.FastCsvExportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.ReportStructureValidator;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.StreamCSVOutputProcessor;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class CSVTableExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(CSVTableExportTask.class);
    private Messages messages;
    private final ReportProgressDialog progressDialog;
    private final String fileName;
    private final MasterReport report;
    private StatusListener statusListener;

    public CSVTableExportTask(MasterReport report, ReportProgressDialog dialog, SwingGuiContext swingGuiContext) throws ReportProcessingException {
        if (report == null) {
            throw new NullPointerException("CSVTableExportTask(..): Report parameter cannot be null");
        }
        String filename = report.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.csv.FileName");
        if (filename == null) {
            throw new ReportProcessingException("CSVTableExportTask(..): Configuration does not contain a valid filename");
        }
        this.progressDialog = dialog;
        this.report = report;
        this.fileName = filename;
        if (swingGuiContext != null) {
            this.statusListener = swingGuiContext.getStatusListener();
            this.messages = new Messages(swingGuiContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.csv.messages.messages", ObjectUtilities.getClassLoader(CSVTableExportPlugin.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStream out = null;
        File file = new File(this.fileName);
        try {
            AbstractReportProcessor reportProcessor;
            File directory = file.getAbsoluteFile().getParentFile();
            if (directory != null && !directory.exists() && !directory.mkdirs()) {
                logger.warn((Object)"Can't create directories. Hoping and praying now..");
            }
            out = new BufferedOutputStream(new FileOutputStream(file));
            ReportStructureValidator validator = new ReportStructureValidator();
            if (!validator.isValidForFastProcessing(this.report)) {
                StreamCSVOutputProcessor target = new StreamCSVOutputProcessor(out);
                reportProcessor = new StreamReportProcessor(this.report, target);
            } else {
                reportProcessor = new FastCsvExportProcessor(this.report, out);
            }
            if (this.progressDialog != null) {
                this.progressDialog.setModal(false);
                this.progressDialog.setVisible(true);
                reportProcessor.addReportProgressListener(this.progressDialog);
            }
            reportProcessor.processReport();
            out.close();
            out = null;
            if (this.progressDialog != null) {
                reportProcessor.removeReportProgressListener(this.progressDialog);
            }
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("CSVTableExportTask.USER_TASK_COMPLETE"), null);
            }
        }
        catch (ReportInterruptedException re) {
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("CSVTableExportTask.USER_TASK_ABORTED"), null);
            }
            try {
                out.close();
                out = null;
                if (!file.delete()) {
                    logger.warn((Object)("Unable to delete incomplete export:" + file));
                }
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception re) {
            logger.error((Object)"Exporting failed .", (Throwable)re);
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("CSVTableExportTask.USER_TASK_FAILED"), re);
            }
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                logger.error((Object)"Unable to close the output stream.", (Throwable)e);
            }
            if (this.progressDialog != null) {
                this.progressDialog.setVisible(false);
            }
        }
    }
}

