/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.rtf;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportInterruptedException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.common.StatusType;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.ReportProgressDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.commonswing.SwingGuiContext;
import org.pentaho.reporting.engine.classic.core.modules.gui.rtf.RTFExportPlugin;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.StreamRTFOutputProcessor;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class RTFExportTask
implements Runnable {
    private static final Log logger = LogFactory.getLog(RTFExportTask.class);
    private Messages messages;
    private final ReportProgressDialog progressDialog;
    private final String fileName;
    private final MasterReport report;
    private StatusListener statusListener;

    public RTFExportTask(MasterReport report, ReportProgressDialog dialog, SwingGuiContext swingGuiContext) throws ReportProcessingException {
        if (report == null) {
            throw new ReportProcessingException("RtfExportTask(..): Report-Parameter cannot be null");
        }
        if (swingGuiContext != null) {
            this.statusListener = swingGuiContext.getStatusListener();
            this.messages = new Messages(swingGuiContext.getLocale(), "org.pentaho.reporting.engine.classic.core.modules.gui.rtf.messages.messages", ObjectUtilities.getClassLoader(RTFExportPlugin.class));
        } else {
            this.messages = new Messages(Locale.getDefault(), "org.pentaho.reporting.engine.classic.core.modules.gui.rtf.messages.messages", ObjectUtilities.getClassLoader(RTFExportPlugin.class));
        }
        String filename = report.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.rtf.FileName");
        if (filename == null) {
            throw new ReportProcessingException(this.messages.getErrorString("RTFExportTask.RTFExportTask.ERROR_0001_NULL_FILENAME", new String[0]));
        }
        this.fileName = filename;
        this.progressDialog = dialog;
        this.report = report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        OutputStream out = null;
        File file = null;
        try {
            file = new File(this.fileName).getCanonicalFile();
            File directory = file.getParentFile();
            if (directory != null && !directory.exists() && !directory.mkdirs()) {
                logger.warn((Object)"Can't create directories. Hoping and praying now..");
            }
            out = new BufferedOutputStream(new FileOutputStream(file));
            StreamRTFOutputProcessor target = new StreamRTFOutputProcessor(this.report.getConfiguration(), out, this.report.getResourceManager());
            StreamReportProcessor proc = new StreamReportProcessor(this.report, target);
            if (this.progressDialog != null) {
                this.progressDialog.setModal(false);
                this.progressDialog.setVisible(true);
                proc.addReportProgressListener(this.progressDialog);
            }
            proc.processReport();
            out.close();
            if (this.progressDialog != null) {
                proc.removeReportProgressListener(this.progressDialog);
            }
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.INFORMATION, this.messages.getString("RTFExportTask.USER_TASK_FINISHED"), null);
            }
        }
        catch (ReportInterruptedException re) {
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.WARNING, this.messages.getString("RTFExportTask.USER_TASK_ABORTED"), null);
            }
            try {
                out.close();
                out = null;
                if (!file.delete()) {
                    logger.warn((Object)("Unable to delete incomplete export:" + file));
                }
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (Exception re) {
            logger.error((Object)"RTF export failed", (Throwable)re);
            if (this.statusListener != null) {
                this.statusListener.setStatus(StatusType.ERROR, this.messages.getString("RTFExportTask.USER_TASK_FAILED"), re);
            }
        }
        finally {
            block28: {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"Unable to close the output stream.", (Throwable)e);
                    if (this.statusListener == null) break block28;
                    this.statusListener.setStatus(StatusType.WARNING, this.messages.getString("RTFExportTask.USER_TASK_FAILED"), e);
                }
            }
        }
        if (this.progressDialog != null) {
            this.progressDialog.setVisible(false);
        }
    }
}

