/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.misc.bsf;

import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.pentaho.reporting.engine.classic.core.AbstractReportPreProcessor;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.states.datarow.DefaultFlowController;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class BSFReportPreProcessor
extends AbstractReportPreProcessor {
    private String preDataScript;
    private String script;
    private String language;

    public String getPreDataScript() {
        return this.preDataScript;
    }

    public void setPreDataScript(String preDataScript) {
        this.preDataScript = preDataScript;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    @Override
    public MasterReport performPreDataProcessing(MasterReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        if (this.preDataScript == null || this.language == null || StringUtils.isEmpty((String)this.preDataScript, (boolean)true)) {
            return definition;
        }
        try {
            BSFManager interpreter = new BSFManager();
            interpreter.declareBean("definition", (Object)definition, MasterReport.class);
            interpreter.declareBean("flowController", (Object)flowController, DefaultFlowController.class);
            Object o = interpreter.eval(this.getLanguage(), "expression", 1, 1, (Object)this.preDataScript);
            if (!(o instanceof MasterReport)) {
                throw new ReportDataFactoryException("Not a MasterReport");
            }
            return (MasterReport)o;
        }
        catch (BSFException e) {
            throw new ReportDataFactoryException("Failed to initialize the BSF-Framework", e);
        }
    }

    @Override
    public MasterReport performPreProcessing(MasterReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        if (this.script == null || this.language == null || StringUtils.isEmpty((String)this.script, (boolean)true)) {
            return definition;
        }
        try {
            BSFManager interpreter = new BSFManager();
            interpreter.declareBean("definition", (Object)definition, MasterReport.class);
            interpreter.declareBean("flowController", (Object)flowController, DefaultFlowController.class);
            Object o = interpreter.eval(this.getLanguage(), "expression", 1, 1, (Object)this.script);
            if (!(o instanceof MasterReport)) {
                throw new ReportDataFactoryException("Not a MasterReport");
            }
            return (MasterReport)o;
        }
        catch (BSFException e) {
            throw new ReportDataFactoryException("Failed to initialize the BSF-Framework", e);
        }
    }

    @Override
    public SubReport performPreDataProcessing(SubReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        if (this.script == null || this.language == null) {
            return definition;
        }
        try {
            BSFManager interpreter = new BSFManager();
            interpreter.declareBean("definition", (Object)definition, MasterReport.class);
            interpreter.declareBean("flowController", (Object)flowController, DefaultFlowController.class);
            Object o = interpreter.eval(this.getLanguage(), "expression", 1, 1, (Object)this.preDataScript);
            if (!(o instanceof SubReport)) {
                throw new ReportDataFactoryException("Not a SubReport");
            }
            return (SubReport)o;
        }
        catch (BSFException e) {
            throw new ReportDataFactoryException("Failed to initialize the BSF-Framework", e);
        }
    }

    @Override
    public SubReport performPreProcessing(SubReport definition, DefaultFlowController flowController) throws ReportProcessingException {
        if (this.script == null || this.language == null) {
            return definition;
        }
        try {
            BSFManager interpreter = new BSFManager();
            interpreter.declareBean("definition", (Object)definition, SubReport.class);
            interpreter.declareBean("flowController", (Object)flowController, DefaultFlowController.class);
            Object o = interpreter.eval(this.getLanguage(), "expression", 1, 1, (Object)this.script);
            if (!(o instanceof SubReport)) {
                throw new ReportDataFactoryException("Not a MasterReport");
            }
            return (SubReport)o;
        }
        catch (BSFException e) {
            throw new ReportDataFactoryException("Failed to initialize the BSF-Framework", e);
        }
    }
}

