/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.datarow;

import java.util.Iterator;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.states.datarow.LevelStorage;
import org.pentaho.reporting.libraries.base.util.EmptyIterator;

public class OutputFunctionLevelStorage
implements LevelStorage {
    private final Function outputFunction;
    private final int level;
    private final boolean pageListener;

    public OutputFunctionLevelStorage(int level, Function outputFunction, boolean pageListener) {
        if (outputFunction == null) {
            throw new NullPointerException();
        }
        this.level = level;
        this.pageListener = pageListener;
        this.outputFunction = outputFunction;
    }

    @Override
    public int getLevelNumber() {
        return this.level;
    }

    @Override
    public Iterator<Function> getFunctions() {
        return new GenericIterator<Function>(this.outputFunction);
    }

    @Override
    public Iterator<Function> getPageFunctions() {
        if (this.pageListener) {
            return new GenericIterator<Function>(this.outputFunction);
        }
        return EmptyIterator.emptyIterator();
    }

    @Override
    public Iterator<Expression> getActiveExpressions() {
        return new GenericIterator<Expression>(this.outputFunction);
    }

    private class GenericIterator<T>
    implements Iterator<T> {
        private boolean hasNextElement = true;
        private T element;

        private GenericIterator(T element) {
            this.element = element;
        }

        @Override
        public boolean hasNext() {
            return this.hasNextElement;
        }

        @Override
        public T next() {
            if (!this.hasNextElement) {
                throw new IllegalStateException();
            }
            this.hasNextElement = false;
            return this.element;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

