/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.states.process;

import org.pentaho.reporting.engine.classic.core.CrosstabGroup;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupHeader;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.states.process.AdvanceHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginCrosstabHandler;
import org.pentaho.reporting.engine.classic.core.states.process.BeginDetailsHandler;
import org.pentaho.reporting.engine.classic.core.states.process.InlineSubreportProcessor;
import org.pentaho.reporting.engine.classic.core.states.process.ProcessState;

public class BeginGroupHandler
implements AdvanceHandler {
    public static final AdvanceHandler HANDLER = new BeginGroupHandler();

    private BeginGroupHandler() {
    }

    @Override
    public int getEventCode() {
        return 8;
    }

    private boolean hasMoreGroups(ProcessState state) {
        return state.getCurrentGroupIndex() < state.getReport().getGroupCount() - 1;
    }

    @Override
    public ProcessState advance(ProcessState state) throws ReportProcessingException {
        ProcessState next = state.deriveForAdvance();
        next.enterGroup();
        next.fireReportEvent();
        next.enterPresentationGroup();
        RelationalGroup group = (RelationalGroup)next.getReport().getGroup(next.getCurrentGroupIndex());
        return InlineSubreportProcessor.processInline(next, group.getHeader());
    }

    @Override
    public ProcessState commit(ProcessState next) throws ReportProcessingException {
        if (!this.hasMoreGroups(next)) {
            next.setAdvanceHandler(BeginDetailsHandler.HANDLER);
        } else {
            Group nextGroup = next.getReport().getGroup(next.getCurrentGroupIndex() + 1);
            if (nextGroup instanceof CrosstabGroup) {
                next.setAdvanceHandler(BeginCrosstabHandler.HANDLER);
            }
        }
        RelationalGroup group = (RelationalGroup)next.getReport().getGroup(next.getCurrentGroupIndex());
        GroupHeader rootLevelBand = group.getHeader();
        return InlineSubreportProcessor.processBandedSubReports(next, rootLevelBand);
    }

    @Override
    public boolean isFinish() {
        return false;
    }

    @Override
    public boolean isRestoreHandler() {
        return false;
    }
}

