/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.gluegen.runtime.DynamicLookupHelper;
import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLDrawableFactoryImpl;
import javax.media.nativewindow.NativeWindow;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawable;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public abstract class GLDrawableImpl
implements GLDrawable {
    protected static final boolean DEBUG = Debug.debug("GLDrawable");
    protected GLDrawableFactory factory;
    protected NativeWindow component;
    protected GLCapabilities requestedCapabilities;
    protected boolean realized;

    protected GLDrawableImpl(GLDrawableFactory gLDrawableFactory, NativeWindow nativeWindow, boolean bl) {
        this.factory = gLDrawableFactory;
        this.component = nativeWindow;
        this.realized = bl;
        this.requestedCapabilities = (GLCapabilities)this.component.getGraphicsConfiguration().getNativeGraphicsConfiguration().getRequestedCapabilities();
    }

    public abstract DynamicLookupHelper getDynamicLookupHelper();

    public GLDrawableFactoryImpl getFactoryImpl() {
        return (GLDrawableFactoryImpl)this.getFactory();
    }

    public void destroy() {
        throw new GLException("Should not call this (should only be called for offscreen GLDrawables)");
    }

    public void swapBuffers() throws GLException {
        GLCapabilities gLCapabilities = (GLCapabilities)this.component.getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
        if (gLCapabilities.getDoubleBuffered()) {
            if (!this.component.surfaceSwap()) {
                this.swapBuffersImpl();
            }
        } else {
            GLContext gLContext = GLContext.getCurrent();
            if (null != gLContext && gLContext.getGLDrawable() == this) {
                gLContext.getGL().glFinish();
            }
        }
        this.component.surfaceUpdated(this, this.component, System.currentTimeMillis());
    }

    protected abstract void swapBuffersImpl();

    public static String toHexString(long l) {
        return GLContextImpl.toHexString(l);
    }

    public GLProfile getGLProfile() {
        return this.requestedCapabilities.getGLProfile();
    }

    public GLCapabilities getChosenGLCapabilities() {
        return (GLCapabilities)this.component.getGraphicsConfiguration().getNativeGraphicsConfiguration().getChosenCapabilities();
    }

    public GLCapabilities getRequestedGLCapabilities() {
        return this.requestedCapabilities;
    }

    public NativeWindow getNativeWindow() {
        return this.component;
    }

    public GLDrawableFactory getFactory() {
        return this.factory;
    }

    public void setRealized(boolean bl) {
        if (this.realized != bl) {
            if (DEBUG) {
                System.err.println("setRealized: " + this.getClass().getName() + " " + this.realized + " -> " + bl);
            }
            this.realized = bl;
            this.setRealizedImpl();
        } else if (DEBUG) {
            System.err.println("setRealized: " + this.getClass().getName() + " " + this.realized + " == " + bl);
        }
    }

    protected abstract void setRealizedImpl();

    public boolean getRealized() {
        return this.realized;
    }

    public int getWidth() {
        return this.component.getWidth();
    }

    public int getHeight() {
        return this.component.getHeight();
    }

    public int lockSurface() throws GLException {
        if (!this.realized) {
            return 1;
        }
        return this.component.lockSurface();
    }

    public void unlockSurface() {
        this.component.unlockSurface();
    }

    public boolean isSurfaceLocked() {
        return this.component.isSurfaceLocked();
    }

    public String toString() {
        return this.getClass().getName() + "[realized " + this.getRealized() + ",\n\tfactory   " + this.getFactory() + ",\n\twindow    " + this.getNativeWindow() + ",\n\trequested " + this.getRequestedGLCapabilities() + ",\n\tchosen    " + this.getChosenGLCapabilities() + "]";
    }
}

