/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl;

import com.sun.nativewindow.impl.NWReflection;
import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLWorkerThread;
import com.sun.opengl.impl.ThreadingPlugin;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.nativewindow.NativeWindowFactory;
import javax.media.opengl.GLException;

public class ThreadingImpl {
    public static final int AWT = 1;
    public static final int WORKER = 2;
    protected static final boolean DEBUG = Debug.debug("Threading");
    private static boolean singleThreaded = true;
    private static int mode;
    private static boolean hasAWT;
    private static boolean _isX11;
    private static final ThreadingPlugin threadingPlugin;

    private ThreadingImpl() {
    }

    public static boolean isX11() {
        return _isX11;
    }

    public static int getMode() {
        return mode;
    }

    public static void disableSingleThreading() {
        singleThreaded = false;
        if (Debug.verbose()) {
            System.err.println("Application forced disabling of single-threading of javax.media.opengl implementation");
        }
    }

    public static boolean isSingleThreaded() {
        return singleThreaded;
    }

    public static boolean isOpenGLThread() throws GLException {
        if (!ThreadingImpl.isSingleThreaded()) {
            throw new GLException("Should only call this in single-threaded mode");
        }
        if (null != threadingPlugin) {
            return threadingPlugin.isOpenGLThread();
        }
        switch (mode) {
            case 1: {
                return true;
            }
            case 2: {
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeOnOpenGLThread(Runnable runnable) throws GLException {
        if (!ThreadingImpl.isSingleThreaded()) {
            throw new GLException("Should only call this in single-threaded mode");
        }
        if (ThreadingImpl.isOpenGLThread()) {
            throw new GLException("Should only call this from other threads than the OpenGL thread");
        }
        if (null != threadingPlugin) {
            threadingPlugin.invokeOnOpenGLThread(runnable);
            return;
        }
        switch (mode) {
            case 1: {
                runnable.run();
                break;
            }
            case 2: {
                if (!GLWorkerThread.isStarted()) {
                    Class clazz = GLWorkerThread.class;
                    synchronized (clazz) {
                        if (!GLWorkerThread.isStarted()) {
                            GLWorkerThread.start();
                        }
                    }
                }
                try {
                    GLWorkerThread.invokeAndWait(runnable);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            default: {
                throw new InternalError("Illegal single-threading mode " + mode);
            }
        }
    }

    public static boolean isAWTMode() {
        return mode == 1;
    }

    private static void printWorkaroundNotice() {
        if (singleThreaded && Debug.verbose()) {
            System.err.println("Using " + (mode == 1 ? "AWT" : "OpenGL worker") + " thread for performing OpenGL work in javax.media.opengl implementation");
        }
    }

    static {
        Object t = AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = Debug.getProperty("jogl.1thread", true);
                boolean bl = Debug.getBooleanProperty("java.awt.headless", false);
                hasAWT = !bl && NWReflection.isClassAvailable("java.awt.Canvas") && NWReflection.isClassAvailable("javax.media.opengl.awt.GLCanvas");
                String string2 = NativeWindowFactory.getNativeWindowType(false);
                _isX11 = "X11".equals(string2);
                int n = hasAWT ? 1 : 2;
                mode = n;
                if (string != null && !(string = string.toLowerCase()).equals("true") && !string.equals("auto")) {
                    if (string.equals("worker")) {
                        singleThreaded = true;
                        mode = 2;
                    } else if (string.equals("awt")) {
                        singleThreaded = true;
                        mode = 1;
                    } else {
                        singleThreaded = false;
                    }
                }
                ThreadingImpl.printWorkaroundNotice();
                Object object = null;
                try {
                    object = NWReflection.createInstance("com.sun.opengl.impl.awt.AWTThreadingPlugin");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return object;
            }
        });
        threadingPlugin = (ThreadingPlugin)t;
        if (DEBUG) {
            System.err.println("Threading: hasAWT " + hasAWT + ", mode " + (mode == 1 ? "AWT" : "WORKER") + ", plugin " + threadingPlugin);
        }
    }
}

