/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows.wgl;

import com.sun.nativewindow.impl.NullWindow;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.windows.wgl.WGL;
import com.sun.opengl.impl.windows.wgl.WindowsWGLContext;
import com.sun.opengl.impl.windows.wgl.WindowsWGLDrawable;
import com.sun.opengl.impl.windows.wgl.WindowsWGLGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.NativeWindow;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLProfile;

public class WindowsExternalWGLContext
extends WindowsWGLContext {
    private boolean firstMakeCurrent = true;
    private boolean created = true;
    private GLContext lastContext;

    private WindowsExternalWGLContext(Drawable drawable, long l, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration) {
        super(drawable, null);
        this.hglrc = l;
        if (DEBUG) {
            System.err.println(WindowsExternalWGLContext.getThreadName() + ": !!! Created external OpenGL context " + WindowsExternalWGLContext.toHexString(l) + " for " + this);
        }
        GLContextShareSet.contextCreated(this);
        this.setGLFunctionAvailability(false);
        windowsWGLGraphicsConfiguration.updateCapabilitiesByWGL(this);
        this.getGLStateTracker().setEnabled(false);
    }

    protected static WindowsExternalWGLContext create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile) {
        long l = WGL.wglGetCurrentDC();
        if (0L == l) {
            throw new GLException("Error: attempted to make an external GLDrawable without a drawable current");
        }
        long l2 = WGL.wglGetCurrentContext();
        if (l2 == 0L) {
            throw new GLException("Error: attempted to make an external GLContext without a context current");
        }
        int n = WGL.GetPixelFormat(l);
        if (n == 0) {
            throw new GLException("Error: attempted to make an external GLContext without a valid pixelformat");
        }
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault();
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfiguration.create(l, n, gLProfile, abstractGraphicsScreen, true, true);
        NullWindow nullWindow = new NullWindow(windowsWGLGraphicsConfiguration);
        nullWindow.setSurfaceHandle(l);
        return new WindowsExternalWGLContext(new Drawable(gLDrawableFactory, nullWindow), l2, windowsWGLGraphicsConfiguration);
    }

    public int makeCurrent() throws GLException {
        GLContext gLContext = WindowsExternalWGLContext.getCurrent();
        if (gLContext != null && gLContext != this) {
            this.lastContext = gLContext;
            WindowsExternalWGLContext.setCurrent(null);
        }
        return super.makeCurrent();
    }

    public void release() throws GLException {
        super.release();
        WindowsExternalWGLContext.setCurrent(this.lastContext);
        this.lastContext = null;
    }

    protected int makeCurrentImpl() throws GLException {
        if (this.firstMakeCurrent) {
            this.firstMakeCurrent = false;
            return 2;
        }
        return 1;
    }

    protected void releaseImpl() throws GLException {
    }

    protected void destroyImpl() throws GLException {
        this.created = false;
        GLContextShareSet.contextDestroyed(this);
    }

    public boolean isCreated() {
        return this.created;
    }

    static class Drawable
    extends WindowsWGLDrawable {
        Drawable(GLDrawableFactory gLDrawableFactory, NativeWindow nativeWindow) {
            super(gLDrawableFactory, nativeWindow, true);
        }

        public GLContext createContext(GLContext gLContext) {
            throw new GLException("Should not call this");
        }

        public int getWidth() {
            throw new GLException("Should not call this");
        }

        public int getHeight() {
            throw new GLException("Should not call this");
        }

        public void setSize(int n, int n2) {
            throw new GLException("Should not call this");
        }
    }
}

