/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.windows.wgl;

import com.sun.gluegen.runtime.ProcAddressTable;
import com.sun.opengl.impl.GLContextImpl;
import com.sun.opengl.impl.GLContextShareSet;
import com.sun.opengl.impl.GLDrawableImpl;
import com.sun.opengl.impl.windows.wgl.WGL;
import com.sun.opengl.impl.windows.wgl.WGLExt;
import com.sun.opengl.impl.windows.wgl.WGLExtImpl;
import com.sun.opengl.impl.windows.wgl.WGLExtProcAddressTable;
import com.sun.opengl.impl.windows.wgl.WindowsWGLGraphicsConfiguration;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class WindowsWGLContext
extends GLContextImpl {
    protected long hglrc;
    private boolean wglGetExtensionsStringEXTInitialized;
    private boolean wglGetExtensionsStringEXTAvailable;
    private boolean wglMakeContextCurrentInitialized;
    private boolean wglMakeContextCurrentARBAvailable;
    private boolean wglMakeContextCurrentEXTAvailable;
    private static final Map functionNameMap = new HashMap();
    private static final Map extensionNameMap;
    private WGLExt wglExt;
    private WGLExtProcAddressTable wglExtProcAddressTable;

    public WindowsWGLContext(GLDrawableImpl gLDrawableImpl, GLDrawableImpl gLDrawableImpl2, GLContext gLContext) {
        super(gLDrawableImpl, gLDrawableImpl2, gLContext);
    }

    public WindowsWGLContext(GLDrawableImpl gLDrawableImpl, GLContext gLContext) {
        this(gLDrawableImpl, null, gLContext);
    }

    public Object getPlatformGLExtensions() {
        return this.getWGLExt();
    }

    public WGLExt getWGLExt() {
        if (this.wglExt == null) {
            this.wglExt = new WGLExtImpl(this);
        }
        return this.wglExt;
    }

    public boolean wglMakeContextCurrent(long l, long l2, long l3) {
        WGLExt wGLExt = this.getWGLExt();
        if (!this.wglMakeContextCurrentInitialized) {
            this.wglMakeContextCurrentARBAvailable = this.isFunctionAvailable("wglMakeContextCurrentARB");
            this.wglMakeContextCurrentEXTAvailable = this.isFunctionAvailable("wglMakeContextCurrentEXT");
            this.wglMakeContextCurrentInitialized = true;
            if (DEBUG) {
                System.err.println("WindowsWGLContext.wglMakeContextCurrent: ARB " + this.wglMakeContextCurrentARBAvailable + ", EXT " + this.wglMakeContextCurrentEXTAvailable);
            }
        }
        if (this.wglMakeContextCurrentARBAvailable) {
            return wGLExt.wglMakeContextCurrentARB(l, l2, l3);
        }
        if (this.wglMakeContextCurrentEXTAvailable) {
            return wGLExt.wglMakeContextCurrentEXT(l, l2, l3);
        }
        return WGL.wglMakeCurrent(l, l3);
    }

    public final ProcAddressTable getPlatformExtProcAddressTable() {
        return this.getWGLExtProcAddressTable();
    }

    public final WGLExtProcAddressTable getWGLExtProcAddressTable() {
        return this.wglExtProcAddressTable;
    }

    protected String mapToRealGLFunctionName(String string) {
        String string2 = (String)functionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        String string2 = (String)extensionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected void create() {
        GLCapabilities gLCapabilities = this.drawable.getChosenGLCapabilities();
        if (DEBUG) {
            System.err.println("WindowsWGLContext.create got " + gLCapabilities);
        }
        if (this.drawable.getNativeWindow().getSurfaceHandle() == 0L) {
            throw new GLException("Internal error: attempted to create OpenGL context without an associated drawable");
        }
        WindowsWGLContext windowsWGLContext = (WindowsWGLContext)GLContextShareSet.getShareContext(this);
        long l = 0L;
        if (windowsWGLContext != null && (l = windowsWGLContext.getHGLRC()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        long l2 = WGL.wglCreateContext(this.drawable.getNativeWindow().getSurfaceHandle());
        if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": !!! Created temp OpenGL context " + WindowsWGLContext.toHexString(l2) + " for " + this + ", device context " + WindowsWGLContext.toHexString(this.drawable.getNativeWindow().getSurfaceHandle()) + ", not yet sharing");
        }
        if (l2 == 0L) {
            throw new GLException("Unable to create temp OpenGL context for device context " + WindowsWGLContext.toHexString(this.drawable.getNativeWindow().getSurfaceHandle()));
        }
        if (!WGL.wglMakeCurrent(this.drawable.getNativeWindow().getSurfaceHandle(), l2)) {
            throw new GLException("Error making temp context current: 0x" + Integer.toHexString(WGL.GetLastError()));
        }
        this.setGLFunctionAvailability(true);
        if (!this.isFunctionAvailable("wglCreateContextAttribsARB") || !this.isExtensionAvailable("WGL_ARB_create_context")) {
            if (gLCapabilities.getGLProfile().isGL3()) {
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l2);
                throw new GLException("Unable to create OpenGL >= 3.1 context (no WGL_ARB_create_context)");
            }
            this.hglrc = l2;
            if (DEBUG) {
                System.err.println("WindowsWGLContext.create done (old ctx < 3.0 - no WGL_ARB_create_context) 0x" + Long.toHexString(this.hglrc));
            }
        } else {
            WGLExt wGLExt = this.getWGLExt();
            int[] nArray = new int[]{8337, 3, 8338, 0, 8340, 0, 0, 0, 0};
            if (gLCapabilities.getGLProfile().isGL3()) {
                nArray[1] = 3;
                nArray[3] = 2;
                if (gLCapabilities.getGLProfile().isGL3bc()) {
                    nArray[6] = 37158;
                    nArray[7] = 2;
                }
                this.hglrc = wGLExt.wglCreateContextAttribsARB(this.drawable.getNativeWindow().getSurfaceHandle(), l, nArray, 0);
                if (0L == this.hglrc) {
                    if (DEBUG) {
                        System.err.println("WindowsWGLContext.createContext couldn't create >= 3.2 core context - fallback");
                    }
                    nArray[1] = 3;
                    nArray[3] = 1;
                    if (!gLCapabilities.getGLProfile().isGL3bc()) {
                        nArray[5] = nArray[5] | 2;
                    }
                    nArray[6] = 0;
                    nArray[7] = 0;
                } else if (DEBUG) {
                    System.err.println("WindowsWGLContext.createContext >= 3.2 available 0x" + Long.toHexString(this.hglrc));
                }
            }
            if (0L == this.hglrc) {
                this.hglrc = wGLExt.wglCreateContextAttribsARB(this.drawable.getNativeWindow().getSurfaceHandle(), l, nArray, 0);
                if (DEBUG) {
                    if (0L == this.hglrc) {
                        System.err.println("WindowsWGLContext.createContext couldn't create >= 3.0 context - fallback");
                    } else {
                        System.err.println("WindowsWGLContext.createContext >= 3.0 available 0x" + Long.toHexString(this.hglrc));
                    }
                }
            }
            if (0L == this.hglrc) {
                if (gLCapabilities.getGLProfile().isGL3()) {
                    WGL.wglMakeCurrent(0L, 0L);
                    WGL.wglDeleteContext(l2);
                    throw new GLException("Unable to create OpenGL >= 3.1 context (have WGL_ARB_create_context)");
                }
                this.hglrc = l2;
                if (!WGL.wglMakeCurrent(this.drawable.getNativeWindow().getSurfaceHandle(), this.hglrc)) {
                    throw new GLException("Error making old context current: 0x" + Integer.toHexString(WGL.GetLastError()));
                }
                this.updateGLProcAddressTable();
                if (DEBUG) {
                    System.err.println("WindowsWGLContext.create done (old ctx < 3.0 - no 3.0) 0x" + Long.toHexString(this.hglrc));
                }
            } else {
                l = 0L;
                WGL.wglMakeCurrent(0L, 0L);
                WGL.wglDeleteContext(l2);
                if (!WGL.wglMakeCurrent(this.drawable.getNativeWindow().getSurfaceHandle(), this.hglrc)) {
                    throw new GLException("Error making new context current: 0x" + Integer.toHexString(WGL.GetLastError()));
                }
                this.updateGLProcAddressTable();
                if (DEBUG) {
                    System.err.println("WindowsWGLContext.create done (new ctx >= 3.0) 0x" + Long.toHexString(this.hglrc));
                }
            }
        }
        if (0L != l && !WGL.wglShareLists(l, this.hglrc)) {
            throw new GLException("wglShareLists(" + WindowsWGLContext.toHexString(l) + ", " + WindowsWGLContext.toHexString(this.hglrc) + ") failed: error code 0x" + Integer.toHexString(WGL.GetLastError()));
        }
        GLContextShareSet.contextCreated(this);
        WGL.wglMakeCurrent(0L, 0L);
        if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": !!! Created OpenGL context " + WindowsWGLContext.toHexString(this.hglrc) + " for " + this + ", device context " + WindowsWGLContext.toHexString(this.drawable.getNativeWindow().getSurfaceHandle()) + ", sharing with " + WindowsWGLContext.toHexString(l));
        }
    }

    protected int makeCurrentImpl() throws GLException {
        if (this.drawable.getNativeWindow().getSurfaceHandle() == 0L) {
            if (DEBUG) {
                System.err.println("drawable not properly initialized");
            }
            return 0;
        }
        boolean bl = false;
        if (this.hglrc == 0L) {
            this.create();
            if (DEBUG) {
                System.err.println(WindowsWGLContext.getThreadName() + ": !!! Created GL context for " + this.getClass().getName());
            }
            bl = true;
        }
        if (WGL.wglGetCurrentContext() != this.hglrc) {
            if (!this.wglMakeContextCurrent(this.drawable.getNativeWindow().getSurfaceHandle(), this.drawableRead.getNativeWindow().getSurfaceHandle(), this.hglrc)) {
                throw new GLException("Error making context current: 0x" + Integer.toHexString(WGL.GetLastError()));
            }
            if (DEBUG && VERBOSE) {
                System.err.println(WindowsWGLContext.getThreadName() + ": wglMakeCurrent(hdc " + WindowsWGLContext.toHexString(this.drawable.getNativeWindow().getSurfaceHandle()) + ", hglrc " + WindowsWGLContext.toHexString(this.hglrc) + ") succeeded");
            }
        }
        if (bl) {
            this.setGLFunctionAvailability(false);
            WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration = (WindowsWGLGraphicsConfiguration)this.drawable.getNativeWindow().getGraphicsConfiguration().getNativeGraphicsConfiguration();
            windowsWGLGraphicsConfiguration.updateCapabilitiesByWGL(this);
            return 2;
        }
        return 1;
    }

    protected void releaseImpl() throws GLException {
        if (!this.wglMakeContextCurrent(0L, 0L, 0L)) {
            throw new GLException("Error freeing OpenGL context: 0x" + Integer.toHexString(WGL.GetLastError()));
        }
    }

    protected void destroyImpl() throws GLException {
        if (DEBUG) {
            Exception exception = new Exception(WindowsWGLContext.getThreadName() + ": !!! Destroyed OpenGL context " + WindowsWGLContext.toHexString(this.hglrc));
            exception.printStackTrace();
        }
        if (this.hglrc != 0L) {
            if (!WGL.wglDeleteContext(this.hglrc)) {
                throw new GLException("Unable to delete OpenGL context");
            }
            this.hglrc = 0L;
            GLContextShareSet.contextDestroyed(this);
        }
    }

    public boolean isCreated() {
        return this.hglrc != 0L;
    }

    public void copy(GLContext gLContext, int n) throws GLException {
        long l = this.getHGLRC();
        long l2 = ((WindowsWGLContext)gLContext).getHGLRC();
        if (l2 == 0L) {
            throw new GLException("Source OpenGL context has not been created");
        }
        if (l == 0L) {
            throw new GLException("Destination OpenGL context has not been created");
        }
        if (!WGL.wglCopyContext(l2, l, n)) {
            throw new GLException("wglCopyContext failed");
        }
    }

    protected void updateGLProcAddressTable() {
        if (DEBUG) {
            System.err.println(WindowsWGLContext.getThreadName() + ": !!! Initializing WGL extension address table for " + this);
        }
        this.wglGetExtensionsStringEXTInitialized = false;
        this.wglGetExtensionsStringEXTAvailable = false;
        this.wglMakeContextCurrentInitialized = false;
        this.wglMakeContextCurrentARBAvailable = false;
        this.wglMakeContextCurrentEXTAvailable = false;
        if (this.wglExtProcAddressTable == null) {
            this.wglExtProcAddressTable = new WGLExtProcAddressTable();
        }
        this.resetProcAddressTable(this.getWGLExtProcAddressTable());
        super.updateGLProcAddressTable();
    }

    public String getPlatformExtensionsString() {
        if (!this.wglGetExtensionsStringEXTInitialized) {
            this.wglGetExtensionsStringEXTAvailable = WGL.wglGetProcAddress("wglGetExtensionsStringEXT") != 0L;
            this.wglGetExtensionsStringEXTInitialized = true;
        }
        if (this.wglGetExtensionsStringEXTAvailable) {
            return this.getWGLExt().wglGetExtensionsStringEXT();
        }
        return "";
    }

    protected void setSwapIntervalImpl(int n) {
        WGLExt wGLExt = this.getWGLExt();
        if (wGLExt.isExtensionAvailable("WGL_EXT_swap_control") && wGLExt.wglSwapIntervalEXT(n)) {
            this.currentSwapInterval = n;
        }
    }

    public ByteBuffer glAllocateMemoryNV(int n, float f, float f2, float f3) {
        return this.getWGLExt().wglAllocateMemoryNV(n, f, f2, f3);
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    public long getHGLRC() {
        return this.hglrc;
    }

    static {
        functionNameMap.put("glAllocateMemoryNV", "wglAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "wglFreeMemoryNV");
        extensionNameMap = new HashMap();
        extensionNameMap.put("GL_ARB_pbuffer", "WGL_ARB_pbuffer");
        extensionNameMap.put("GL_ARB_pixel_format", "WGL_ARB_pixel_format");
    }
}

