/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.serializer.methods;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.pentaho.reporting.libraries.serializer.SerializeMethod;

public class GradientPaintSerializer
implements SerializeMethod {
    @Override
    public void writeObject(Object o, ObjectOutputStream stream) throws IOException {
        GradientPaint gp = (GradientPaint)o;
        Point2D point2D1 = gp.getPoint1();
        stream.writeFloat((float)point2D1.getX());
        stream.writeFloat((float)point2D1.getY());
        stream.writeObject(gp.getColor1());
        Point2D point2D = gp.getPoint2();
        stream.writeFloat((float)point2D.getX());
        stream.writeFloat((float)point2D.getY());
        stream.writeObject(gp.getColor2());
        stream.writeBoolean(gp.isCyclic());
    }

    @Override
    public Object readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        float x1 = stream.readFloat();
        float y1 = stream.readFloat();
        Color c1 = (Color)stream.readObject();
        float x2 = stream.readFloat();
        float y2 = stream.readFloat();
        Color c2 = (Color)stream.readObject();
        boolean isCyclic = stream.readBoolean();
        return new GradientPaint(x1, y1, c1, x2, y2, c2, isCyclic);
    }

    @Override
    public Class getObjectClass() {
        return GradientPaint.class;
    }
}

