/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.billing.application;

import java.io.File;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Cursor;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.stage.FileChooser;
import javafx.util.Callback;
import org.sportdata.set.aw.n;
import org.sportdata.set.billing.application.Alert;
import org.sportdata.set.billing.beans.BillingBean;
import org.sportdata.set.billing.beans.ProductBean;
import org.sportdata.set.billing.utils.InvoiceGenerator;
import org.sportdata.set.billing.utils.ValidationFields;

public class BillController
implements Initializable {
    private static DecimalFormat df = new DecimalFormat(".##");
    @FXML
    private TextField invoice;
    @FXML
    private TextField cName;
    @FXML
    private TextField cContact;
    @FXML
    private TextArea cAddress;
    @FXML
    private TextField pName;
    @FXML
    private TextField pPrice;
    @FXML
    private TextField pQty;
    @FXML
    private TextField ptotalPrice;
    @FXML
    private ComboBox<String> pType;
    @FXML
    private Button add_product;
    @FXML
    private Button clear_product;
    @FXML
    private Button new_bill;
    @FXML
    private Button save_bill;
    @FXML
    private TableView<ProductBean> addTable;
    @FXML
    private TableColumn<ProductBean, String> typeCol;
    @FXML
    private TableColumn<ProductBean, String> pDescriptionCol;
    @FXML
    private TableColumn<ProductBean, Double> unitPriceCol;
    @FXML
    private TableColumn<ProductBean, Integer> noOfUnitsCol;
    @FXML
    private TableColumn<ProductBean, Double> totalPriceCol;
    @FXML
    private TableColumn<ProductBean, String> eventCol;
    @FXML
    private TextField subTotal;
    @FXML
    private TextField discount;
    @FXML
    private TextField discountTotal;
    @FXML
    private TextField tax;
    @FXML
    private TextField taxTotal;
    @FXML
    private TextField total;
    ObservableList<String> pTypeList = FXCollections.observableArrayList((Object[])new String[]{"Entries", "License", "Penalty", "Other"});

    public void initialize(URL location, ResourceBundle resources) {
        this.invoice.setText("");
        this.pType.setItems(this.pTypeList);
        this.add_product.setCursor(Cursor.HAND);
        this.clear_product.setCursor(Cursor.HAND);
        this.tableColumns();
        this.onlyNumericTextField();
        this.productTotalChange();
        this.percentChange();
        this.setTotalPrice();
    }

    public void onlyNumericTextField() {
        this.pPrice.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("[0-9.]*")) {
                this.pPrice.setText(oldValue);
            }
        });
        this.pQty.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("[0-9]*")) {
                this.pQty.setText(oldValue);
            }
        });
        this.discount.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("[0-9.]*")) {
                this.discount.setText(oldValue);
            }
        });
        this.tax.textProperty().addListener((observable, oldValue, newValue) -> {
            if (!newValue.matches("[0-9.]*")) {
                this.tax.setText(oldValue);
            }
        });
    }

    public void onChangepType(ActionEvent event) {
        try {
            this.pName.setText(((String)this.pType.getSelectionModel().getSelectedItem()).toString());
        }
        catch (Exception e2) {
            this.pName.setText("");
        }
    }

    public void productTotalChange() {
        this.pPrice.textProperty().addListener((observable, oldValue, newValue) -> this.setProductTotalPrice());
        this.pQty.textProperty().addListener((observable, oldValue, newValue) -> this.setProductTotalPrice());
    }

    public void addProduct(ActionEvent event) {
        String valid = ValidationFields.validateProduct(this.pType, this.pName, this.pPrice, this.pQty);
        if (valid.equals("OK")) {
            ProductBean bean = ValidationFields.getProductData(this.pType, this.pName, this.pPrice, this.pQty, this.ptotalPrice);
            this.addTable.getItems().add((Object)bean);
            this.clearProduct(event);
        } else {
            Alert.makeAlert("Error!", valid);
        }
        this.setPrice();
    }

    public void tableColumns() {
        this.typeCol.setCellValueFactory((Callback)new PropertyValueFactory("type"));
        this.pDescriptionCol.setCellValueFactory((Callback)new PropertyValueFactory("productDescription"));
        this.unitPriceCol.setCellValueFactory((Callback)new PropertyValueFactory("unitPrice"));
        this.noOfUnitsCol.setCellValueFactory((Callback)new PropertyValueFactory("noOfUnits"));
        this.totalPriceCol.setCellValueFactory((Callback)new PropertyValueFactory("totalCost"));
    }

    public void eventProductDelete(ActionEvent event) {
        ObservableList allProduct = this.addTable.getItems();
        ObservableList selectedProduct = this.addTable.getSelectionModel().getSelectedItems();
        selectedProduct.forEach(arg_0 -> allProduct.remove(arg_0));
        this.setPrice();
    }

    public void clearProduct(ActionEvent event) {
        this.pName.clear();
        this.pPrice.clear();
        this.pQty.setText("1");
        this.ptotalPrice.clear();
        this.pType.getSelectionModel().clearSelection();
    }

    public void setPrice() {
        double totalPrice = 0.0;
        for (ProductBean item : this.addTable.getItems()) {
            totalPrice += item.getTotalCost();
        }
        this.subTotal.setText("" + totalPrice);
        this.total.setText("" + totalPrice);
    }

    public void percentChange() {
        this.discount.textProperty().addListener((observable, oldValue, newValue) -> {
            this.discountTotal.setText(this.percentageTotal((String)newValue));
            this.setTotalPrice();
        });
        this.tax.textProperty().addListener((observable, oldValue, newValue) -> {
            this.taxTotal.setText(this.percentageTotal((String)newValue));
            this.setTotalPrice();
        });
    }

    public void setProductTotalPrice() {
        try {
            double unitPriceValue = Double.parseDouble(this.pPrice.getText());
            double noUnitsValue = Double.parseDouble(this.pQty.getText());
            this.ptotalPrice.setText(df.format(unitPriceValue * noUnitsValue));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String percentageTotal(String value) {
        try {
            double subTotalValue = Double.parseDouble(this.subTotal.getText());
            double result = value.isEmpty() || value == null ? 0.0 : Double.parseDouble(value);
            return df.format((result /= 100.0) * subTotalValue);
        }
        catch (Exception exception) {
            return df.format("0.00");
        }
    }

    public void setTotalPrice() {
        double subTotalValue = Double.parseDouble(this.subTotal.getText());
        double discountTotalValue = Double.parseDouble(this.discountTotal.getText());
        double taxTotalValue = Double.parseDouble(this.taxTotal.getText());
        this.total.setText(df.format(subTotalValue - discountTotalValue + taxTotalValue));
    }

    public void newBill(ActionEvent event) {
        this.invoice.setText("");
        this.cName.clear();
        this.cContact.clear();
        this.cAddress.clear();
        this.clearProduct(event);
        int i2 = 0;
        while (i2 < this.addTable.getItems().size()) {
            this.addTable.getItems().clear();
            ++i2;
        }
        this.subTotal.setText("0.0");
        this.discount.setText("0");
        this.discountTotal.setText("0.0");
        this.tax.setText("0");
        this.taxTotal.setText("0.0");
        this.total.setText("0.0");
    }

    public void saveBill(ActionEvent event) {
        File file = new File("billing/INVOICE.pdf");
        boolean isGenrated = false;
        BillingBean bean = this.checkBilling(event);
        if (bean != null) {
            isGenrated = InvoiceGenerator.makePDF(file, bean);
        }
        if (isGenrated) {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setInitialFileName("Invoice_No_" + n.f(this.invoice.getText()) + ".pdf");
            FileChooser.ExtensionFilter extFilter = new FileChooser.ExtensionFilter("PDF files (*.pdf)", new String[]{"*.pdf"});
            fileChooser.getExtensionFilters().add((Object)extFilter);
            fileChooser.setTitle("Save Invoice");
            File dest = fileChooser.showSaveDialog(null);
            if (dest != null) {
                try {
                    Files.copy(file.toPath(), dest.toPath(), new CopyOption[0]);
                }
                catch (Exception ex) {
                    Alert.makeAlert("File Not Found", "Falied Saving File");
                }
            }
        } else {
            Alert.makeAlert("File Not Found", "Falied Saving File");
        }
    }

    public BillingBean checkBilling(ActionEvent event) {
        String valid = ValidationFields.validateBilling(this.addTable, this.invoice, this.cName, this.cContact, this.cAddress);
        BillingBean bean = null;
        if (valid.equals("OK")) {
            bean = ValidationFields.getBillingData(this.addTable, this.invoice, this.cName, this.cContact, this.cAddress, this.subTotal, this.discount, this.discountTotal, this.tax, this.taxTotal, this.total);
            return bean;
        }
        Alert.makeAlert("Empty", valid);
        return bean;
    }
}

