/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.billing.utils;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import org.sportdata.set.billing.beans.BillingBean;
import org.sportdata.set.billing.beans.ProductBean;

public class ValidationFields {
    public static String validateProduct(ComboBox<String> pType, TextField pName, TextField pPrice, TextField pQty) {
        if (pType.getSelectionModel().isEmpty()) {
            return "Product Type is Not Selected.";
        }
        if (pName.getText().isEmpty()) {
            return "Product Name is Not Entered.";
        }
        if (pPrice.getText().isEmpty()) {
            return "Unit Price is Not Entered.";
        }
        if (pQty.getText().isEmpty()) {
            return "Number of Units is Not Entered.";
        }
        return "OK";
    }

    public static ProductBean getProductData(ComboBox<String> pType, TextField pName, TextField pPrice, TextField pQty, TextField ptotalPrice) {
        ProductBean bean = new ProductBean();
        bean.setType((String)pType.getSelectionModel().getSelectedItem());
        bean.setProductDescription(pName.getText());
        bean.setUnitPrice(Double.parseDouble(pPrice.getText().replace(',', '.')));
        bean.setNoOfUnits(Integer.parseInt(pQty.getText()));
        bean.setTotalCost(Double.parseDouble(ptotalPrice.getText().replace(',', '.')));
        return bean;
    }

    public static String validateBilling(TableView<ProductBean> table, TextField invoice, TextField cName, TextField cContact, TextArea cAddress) {
        ObservableList items = table.getItems();
        if (items.isEmpty()) {
            return "No Products Found!";
        }
        if (invoice.getText().isEmpty()) {
            return "Invoice number is Not Entered.";
        }
        if (cName.getText().isEmpty()) {
            return "Customer Name is Not Entered.";
        }
        return "OK";
    }

    public static BillingBean getBillingData(TableView<ProductBean> table, TextField invoice, TextField cName, TextField cContact, TextArea cAddress, TextField subTotal, TextField discount, TextField discountTotal, TextField tax, TextField taxTotal, TextField total) {
        BillingBean bean = new BillingBean();
        bean.setInvoiceNumber(invoice.getText());
        bean.setCustomerName(cName.getText());
        bean.setCustomerContact(cContact.getText());
        bean.setCustomerAddress(cAddress.getText());
        bean.setSubTotalPrice(subTotal.getText());
        bean.setDiscount(discount.getText());
        bean.setDiscountPrice(discountTotal.getText());
        bean.setTax(tax.getText());
        bean.setTaxPrice(taxTotal.getText());
        bean.setTotalPrice(total.getText());
        bean.setProducts((List<ProductBean>)table.getItems());
        return bean;
    }
}

