/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.beans;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.logging.Logger;
import org.sportdata.set.extension.dtm.beans.CategoryTreeBean;
import org.sportdata.set.extension.dtm.beans.DynamicCategoryBean;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.internal.beans.DTMMaster;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;

public class DTMUtill {
    public static Logger log = DTMMaster.getInstance().getLogger();
    public static SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
    public static Connection conn = null;

    public static String formatInput(int i2) {
        String input = String.valueOf(i2);
        if (input.length() == 2) {
            return input;
        }
        if (input.length() == 1) {
            return "0" + input;
        }
        return "";
    }

    public static Timestamp addMinutes(Timestamp ts, int milliseconds) {
        return new Timestamp(ts.getTime() + (long)milliseconds);
    }

    public static Timestamp substractMinutes(Timestamp ts, int milliseconds) {
        return new Timestamp(ts.getTime() - (long)milliseconds);
    }

    public static long timestampDiff(Timestamp ts1, Timestamp ts2) {
        return ts1.getTime() - ts2.getTime();
    }

    public static int getMinutesFromTimestamp(Timestamp timestamp) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(timestamp.getTime()));
        return cal.get(12);
    }

    public static int getDaysFromTimestamp(Timestamp t2) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(t2.getTime()));
        return cal.get(5);
    }

    public static int getHoursFromTimestamp(Timestamp timestamp) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date(timestamp.getTime()));
        return cal.get(11);
    }

    public static Timestamp nullTimestampFromDate(Date date) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat timestampFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        if (date != null) {
            String dateString = dateFormatter.format(date);
            try {
                return new Timestamp(timestampFormatter.parse(dateString + " 00:00:00.0").getTime());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public static Date changeDate(Date aDate, int days) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(aDate);
        cal.add(5, days);
        return new Date(cal.getTime().getTime());
    }

    public static Timestamp roundTimestampToMinutes(Timestamp ts) {
        return new Timestamp(DTMUtill.msToMin(ts.getTime(), false) * 60L * 1000L);
    }

    public static long msToMin(long ms, Boolean round) {
        if (ms == 0L) {
            return 0L;
        }
        long absValue = Math.abs(ms);
        if (!round.booleanValue()) {
            return (long)Math.ceil((double)((long)((double)absValue / 1000.0)) / 60.0);
        }
        boolean negative = ms < 0L;
        if (absValue % 300000L >= 150000L) {
            if (!negative) {
                return DTMUtill.roundUpTime(300000, absValue) / 60000L;
            }
            return -(DTMUtill.roundUpTime(300000, absValue) / 60000L);
        }
        if (!negative) {
            return DTMUtill.roundDownTime(300000, absValue) / 60000L;
        }
        return -(DTMUtill.roundDownTime(300000, absValue) / 60000L);
    }

    public static long roundUpTime(int step, long time) {
        long msecondsToRoundUp = 0L;
        long rest = time % (long)step;
        if (rest != 0L) {
            msecondsToRoundUp = (long)step - rest;
        }
        return time + msecondsToRoundUp;
    }

    public static long roundDownTime(int step, long time) {
        long rest = time % (long)step;
        return time - rest;
    }

    public static int calcRepechageEntries(int categoryEntries, int pools) {
        if (categoryEntries <= 4 || pools <= 0) {
            return 0;
        }
        if (categoryEntries == 5 && pools == 1) {
            return 2;
        }
        int repEntries = pools == 1 ? (Math.log(categoryEntries - 1) / Math.log(2.0) == Math.ceil(Math.log(categoryEntries) / Math.log(2.0)) - 1.0 ? (int)((Math.ceil(Math.log(categoryEntries) / Math.log(2.0)) - 1.0) * 2.0 - 1.0) : (int)((Math.ceil(Math.log(categoryEntries) / Math.log(2.0)) - 1.0) * 2.0)) : (int)(Math.ceil(Math.log(categoryEntries) / Math.log(2.0)) - 1.0);
        return repEntries;
    }

    public static int calcPoolwinnerRounds(int pools) {
        if (pools < 4) {
            return 0;
        }
        return pools - 2;
    }

    public static int calcNrOfFights(int entries, int itemType) {
        if (entries <= 1) {
            return 0;
        }
        return entries - 1;
    }

    public static int calcTotalNrOfFights(int entries, int itemType) {
        int nrOfFights = DTMUtill.calcNrOfFights(entries, itemType);
        int nrOfRepechageFights = itemType != 0 ? 0 : DTMUtill.calculateRepechageFights(entries);
        return nrOfFights + nrOfRepechageFights;
    }

    public static int calculateRepechageFights(int entries) {
        if (entries <= 4) {
            return 0;
        }
        return (int)(2.0 * Math.ceil(Math.log(entries) / Math.log(2.0)) - 4.0);
    }

    public static String getFormattedTimeHHMM(int seconds) {
        int hours = seconds / 3600;
        int remainder = seconds % 3600;
        int minutes = remainder / 60;
        int secs = remainder % 60;
        return (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes;
    }

    public static String fullString(TimetableBean bean) {
        if (bean == null) {
            return "";
        }
        Object edited = "";
        if (bean.isEdited()) {
            edited = " (" + DTMResource.getResourceString("general.edited") + ")";
        }
        if (bean.getType() == 5) {
            return bean.toString() + "\n\n" + DTMResource.getResourceString("general.starttime") + "  " + bean.getStarttime().toString().substring(11, 16) + "\n" + DTMResource.getResourceString("general.endtime") + "  " + bean.getEndtime().toString().substring(11, 16) + "\n" + DTMResource.getResourceString("general.duration") + "  " + bean.getFormattedCatDuration();
        }
        return bean.toString() + "\n" + DTMResource.getResourceString("general.entries") + "  " + bean.getEntries() + "\n\n" + DTMResource.getResourceString("general.starttime") + "  " + bean.getStarttime().toString().substring(11, 16) + "\n" + DTMResource.getResourceString("general.endtime") + "  " + bean.getEndtime().toString().substring(11, 16) + "\n" + DTMResource.getResourceString("general.duration") + "  " + bean.getFormattedCatDuration() + (String)edited + "\n" + DTMResource.getResourceString("general.matchtime") + "  " + DTMUtill.getFormattedTimeHHMMSS(bean.getFighttime());
    }

    public static String getFormattedTimeHHMMSS(int seconds) {
        if (seconds == -1) {
            return "-1";
        }
        int hours = seconds / 3600;
        int remainder = seconds % 3600;
        int minutes = remainder / 60;
        int secs = remainder % 60;
        return (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + ":" + (secs < 10 ? "0" : "") + secs;
    }

    public static String getFormattedTimeHHMMFromTimestamp(Timestamp t2) {
        return t2.toString().substring(11, 16);
    }

    public static boolean matchesTimetableBean(DynamicCategoryBean dynBean, TimetableBean ttBean) {
        boolean ret = false;
        int dynBeanType = dynBean.getType();
        if (dynBean.getKnr() != ttBean.getKnr()) {
            ret = false;
        } else if (ttBean.getType() == 0) {
            ret = true;
        } else {
            switch (dynBeanType) {
                case 1: {
                    if (ttBean.getType() != 1) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == dynBean.getPool()) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 2: {
                    if (ttBean.getType() != 2) {
                        ret = false;
                        break;
                    }
                    ret = true;
                    break;
                }
                case 3: {
                    if (ttBean.getType() != 3) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == dynBean.getPool()) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 4: {
                    if (ttBean.getType() != 4) {
                        ret = false;
                        break;
                    }
                    ret = true;
                    break;
                }
                case 6: {
                    if (ttBean.getType() != 6) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == dynBean.getPool()) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 7: {
                    ret = ttBean.getType() != 7 ? false : ttBean.getPool() == dynBean.getPool();
                }
            }
        }
        return ret;
    }

    public static Boolean isChildOf(CategoryTreeBean childBean, CategoryTreeBean parentBean) {
        Boolean ret = false;
        if (parentBean.getType() == 0 && childBean.getType() != 0) {
            ret = parentBean.getKnr() == childBean.getKnr() ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return ret;
    }

    public static Boolean categoryTreeBeanMatchesTimetableBean(CategoryTreeBean catBean, TimetableBean ttBean) {
        Boolean ret = false;
        int catBeanType = catBean.getType();
        if (ttBean.getKnr() != catBean.getKnr()) {
            ret = false;
        } else {
            switch (catBeanType) {
                case 0: {
                    if (ttBean.getType() != 0) {
                        ret = false;
                        break;
                    }
                    ret = true;
                    break;
                }
                case 1: {
                    if (ttBean.getType() != 1) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == catBean.getPool()) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 2: {
                    if (ttBean.getType() != 2) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == catBean.getPool()) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 3: {
                    if (ttBean.getType() != 3) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == catBean.getPool()) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 4: {
                    if (ttBean.getType() != 4) {
                        ret = false;
                        break;
                    }
                    ret = true;
                    break;
                }
                case 6: {
                    if (ttBean.getType() != 6) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == catBean.getPool()) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 7: {
                    ret = ttBean.getType() != 7 ? Boolean.valueOf(false) : (ttBean.getPool() == catBean.getPool() ? Boolean.valueOf(true) : Boolean.valueOf(false));
                }
            }
        }
        return ret;
    }

    public static int getTatamiNumber(Connection conn, int vernr, int knr, int type, int pool) {
        String statement = "select tatami from timetable where vernr=" + vernr + " and knr=" + knr + " and type=" + type + " and pool=" + pool + ";";
        int tatami = 0;
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(statement);
            rs.beforeFirst();
            if (rs.next()) {
                tatami = rs.getInt("tatami");
            } else {
                log.info("No entry found in Timetable db for: vernr=" + vernr + " and knr=" + knr + " and type=" + type + " and pool=" + pool);
            }
            if (rs.next()) {
                log.severe("getTatamiNumber returned more than one record. Meaning that a Timetable entry is not unique.");
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tatami;
    }

    public static int getTatamiNumberDay(Connection conn, int vernr, Date date) {
        String statement = "select MAX(tatamis) from timetable where vernr=" + vernr + " and date='" + String.valueOf(date) + "' ";
        int tatamis = 0;
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(statement);
            rs.first();
            tatamis = rs.getInt(1);
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return tatamis;
    }

    public static boolean validateInputString(String input) {
        String lowInput = input.toLowerCase();
        return !lowInput.contains(";") && !lowInput.contains(",") && !lowInput.contains("(") && !lowInput.contains(")") && !lowInput.contains("delete ") && !lowInput.contains("drop ") && !lowInput.contains("update ") && !lowInput.contains("insert ") && !lowInput.contains("select ") && !lowInput.contains("grant ") && !lowInput.contains("create ") && !lowInput.contains("revoke ") && !lowInput.contains("use ") && !lowInput.contains("connect ") && !lowInput.contains("alter ");
    }
}

