/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.beans;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.sportdata.set.extension.dtm.beans.DTMBean;
import org.sportdata.set.extension.dtm.controller.DefaultsController;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.DTMLocalTimeTextField;
import org.sportdata.set.extension.dtm.util.DTMUtil;
import org.sportdata.set.extension.dtm.view.DTMDialog;

public class DefaultBean
extends DTMBean {
    private int id;
    private int vernr;
    private String type;
    private String sex;
    private String catname;
    private int fighttime;
    private String color;
    public SimpleObjectProperty<LocalTime> value = new SimpleObjectProperty();
    private SimpleObjectProperty<ColorPicker> colorPicker;
    private SimpleObjectProperty<DTMLocalTimeTextField> localTimeTextField;
    private SimpleObjectProperty<Button> deleteImageViewButton;
    private SimpleObjectProperty<CheckBox> cbLoad = null;

    public DefaultBean() {
        this.colorPicker = new SimpleObjectProperty((Object)new ColorPicker(null));
        this.localTimeTextField = new SimpleObjectProperty((Object)new DTMLocalTimeTextField());
        ((DTMLocalTimeTextField)((Object)this.localTimeTextField.get())).setDateTimeFormatter(DateTimeFormatter.ofPattern("HH:mm:ss"));
        Image imageDelete = new Image(this.getClass().getResourceAsStream("/org/sportdata/set/extension/dtm/view/images/mop0b.gif"));
        ImageView imgViewDelete = new ImageView(imageDelete);
        imgViewDelete.setFitHeight(16.0);
        imgViewDelete.setFitWidth(16.0);
        this.deleteImageViewButton = new SimpleObjectProperty((Object)new Button("", (Node)imgViewDelete));
    }

    public DefaultBean(int id, int vernr, String type, String sex, String catname, int fighttime, String color, DefaultsController controller, boolean withCheckbox) {
        this(id, vernr, type, sex, catname, fighttime, color, controller);
        if (withCheckbox) {
            this.cbLoad = new SimpleObjectProperty((Object)new CheckBox());
            ((Button)this.deleteImageViewButton.getValue()).visibleProperty().set(false);
            ((ColorPicker)this.colorPicker.getValue()).visibleProperty().set(false);
            ((DTMLocalTimeTextField)((Object)this.localTimeTextField.getValue())).visibleProperty().set(false);
            ((CheckBox)this.cbLoad.getValue()).visibleProperty().set(false);
        }
    }

    public DefaultBean(int id, int vernr, String type, String sex, String catname, int fighttime, String color, final DefaultsController controller) {
        this.setController(controller);
        this.id = id;
        this.vernr = vernr;
        this.type = type;
        this.sex = sex;
        this.catname = catname;
        this.fighttime = fighttime;
        this.color = color;
        this.colorPicker = new SimpleObjectProperty((Object)new ColorPicker(null));
        this.localTimeTextField = new SimpleObjectProperty((Object)new DTMLocalTimeTextField());
        ((DTMLocalTimeTextField)((Object)this.localTimeTextField.get())).setDateTimeFormatter(DateTimeFormatter.ofPattern("HH:mm:ss"));
        Image imageDelete = new Image(this.getClass().getResourceAsStream("/org/sportdata/set/extension/dtm/view/images/mop0b.gif"));
        ImageView imgViewDelete = new ImageView(imageDelete);
        imgViewDelete.setFitHeight(16.0);
        imgViewDelete.setFitWidth(16.0);
        this.deleteImageViewButton = new SimpleObjectProperty((Object)new Button("", (Node)imgViewDelete));
        if (this.color != null && !this.color.equals("")) {
            ((ColorPicker)this.colorPicker.get()).setValue((Object)Color.web((String)this.color));
        }
        ((ColorPicker)this.colorPicker.get()).setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                DefaultBean.this.handleColorChange();
            }
        });
        if (this.fighttime != 0) {
            int hours = fighttime / 3600;
            int minutes = (fighttime - hours * 3600) / 60;
            int seconds = fighttime % 60;
            this.value.set((Object)LocalTime.of(hours, minutes, seconds));
        }
        ((DTMLocalTimeTextField)((Object)this.localTimeTextField.get())).localTimeProperty().bindBidirectional(this.value);
        this.value.addListener((ChangeListener)new ChangeListener<LocalTime>(){

            public void changed(ObservableValue<? extends LocalTime> observable, LocalTime oldValue, LocalTime newValue) {
                int seconds = 0;
                if (newValue != null) {
                    seconds = newValue.getHour() * 3600 + newValue.getMinute() * 60 + newValue.getSecond();
                }
                DefaultBean.this.setFighttime(seconds);
                if (DefaultBean.this.getId() != 0) {
                    if (seconds != 0 || !DefaultBean.this.getColor().equals("")) {
                        DefaultBean.this.update();
                    } else {
                        DefaultBean.this.delete();
                        DefaultBean.this.setId(0);
                    }
                } else {
                    DefaultBean.this.insert();
                    DefaultBean.this.setId(controller.getLastId());
                }
                DefaultBean.this.checkDeleteButtonVisibility();
            }
        });
        ((DTMLocalTimeTextField)((Object)this.localTimeTextField.get())).parseErrorCallbackProperty().set((Object)new Callback<Throwable, Void>(){

            public Void call(Throwable param) {
                DTMDialog.inform(null, DTMResource.getResourceString(DTMResource.getResourceString("settings.matchtime.format")));
                return null;
            }
        });
        ((Button)this.deleteImageViewButton.get()).setOnMouseClicked(mouseEvent -> this.handleDeleteButtonClick());
        this.checkDeleteButtonVisibility();
    }

    public int priority() {
        if (this.catname != null && !this.catname.equals("")) {
            return 1;
        }
        if (this.sex != null && !this.sex.equals("")) {
            return 3;
        }
        if (this.type != null && !this.type.equals("")) {
            return 4;
        }
        return 5;
    }

    public boolean matches(DefaultBean comp) {
        if (this.compareTo(comp) != 0) {
            return false;
        }
        switch (this.priority()) {
            case 1: {
                return this.catname.equals(comp.catname);
            }
            case 3: {
                return this.sex.equals(comp.sex);
            }
            case 4: {
                return this.type.equals(comp.type);
            }
            case 5: {
                return true;
            }
        }
        System.out.println("ERROR: invalid DefaultBean priority!");
        return false;
    }

    public void manualColorUpdate(Color color) {
        if (color == null) {
            this.setColor("");
        } else {
            this.setColor(DTMUtil.toRGBCode(color));
        }
        if (this.getId() != 0) {
            if (this.getColor().equals("") && ((DTMLocalTimeTextField)((Object)this.localTimeTextField.get())).getLocalTime() == null) {
                this.delete();
                this.setId(0);
            } else {
                this.update();
            }
        } else {
            this.insert();
            this.setId(((DefaultsController)this.getController()).getLastId());
        }
        this.checkDeleteButtonVisibility();
    }

    public void checkDeleteButtonVisibility() {
        if (this.getId() == 0) {
            ((Button)this.deleteImageViewButton.get()).setVisible(false);
        } else {
            ((Button)this.deleteImageViewButton.get()).setVisible(true);
        }
    }

    public void handleColorChange() {
        if (((ColorPicker)this.colorPicker.get()).getValue() == null) {
            this.setColor("");
        } else {
            this.setColor(DTMUtil.toRGBCode((Color)((ColorPicker)this.colorPicker.get()).getValue()));
        }
        if (this.getId() != 0) {
            if (this.getColor().equals("") && ((DTMLocalTimeTextField)((Object)this.localTimeTextField.get())).getLocalTime() == null) {
                this.delete();
                this.setId(0);
            } else {
                this.update();
            }
        } else {
            this.insert();
            this.setId(((DefaultsController)this.getController()).getLastId());
        }
        this.checkDeleteButtonVisibility();
    }

    public void handleDeleteButtonClick() {
        ((DTMLocalTimeTextField)((Object)this.localTimeTextField.get())).setLocalTime(null);
        if (this.value.getValue() != null) {
            this.value.set(null);
        }
        ((ColorPicker)this.colorPicker.get()).setValue(null);
        if (!this.getColor().equals("")) {
            this.setColor("");
        }
        if (this.getId() != 0) {
            this.delete();
        }
        this.setId(0);
        this.checkDeleteButtonVisibility();
    }

    public int compareTo(Object bean) {
        if (((DefaultBean)bean).priority() > this.priority()) {
            return 1;
        }
        if (((DefaultBean)bean).priority() == this.priority()) {
            return 0;
        }
        return -1;
    }

    @Override
    public PreparedStatement deleteStmt(Connection conn) {
        this.pstmt = null;
        String pstmtString = "DELETE FROM dtmdefaults WHERE id = ?;";
        try {
            this.pstmt = conn.prepareStatement(pstmtString);
            this.pstmt.setInt(1, this.getId());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.pstmt;
    }

    @Override
    public PreparedStatement insertStmt(Connection conn) {
        String pstmtString = "INSERT INTO dtmdefaults (vernr,type,sex,catname,fighttime,color) VALUES (?,?,?,?,?,?);";
        try {
            this.pstmt = conn.prepareStatement(pstmtString);
            this.pstmt.setInt(1, this.getVernr());
            this.pstmt.setString(2, this.getType());
            this.pstmt.setString(3, this.getSex());
            this.pstmt.setString(4, this.getCatname());
            this.pstmt.setInt(5, this.getFighttime());
            this.pstmt.setString(6, this.getColor());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.pstmt;
    }

    @Override
    public PreparedStatement updateStmt(Connection conn) {
        String pstmtString = "UPDATE dtmdefaults SET vernr = ?,type = ?,sex = ?,catname = ?,fighttime = ?,color = ? WHERE id = ?;";
        try {
            this.pstmt = conn.prepareStatement(pstmtString);
            this.pstmt.setInt(1, this.getVernr());
            this.pstmt.setString(2, this.getType());
            this.pstmt.setString(3, this.getSex());
            this.pstmt.setString(4, this.getCatname());
            this.pstmt.setInt(5, this.getFighttime());
            this.pstmt.setString(6, this.getColor());
            this.pstmt.setInt(7, this.getId());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.pstmt;
    }

    @Override
    public String getDeleteString() {
        return "DELETE FROM dtmdefaults WHERE id = " + this.getId() + ";";
    }

    @Override
    public String getInsertString() {
        return "INSERT INTO dtmdefaults (vernr,type,sex,catname,fighttime,color) VALUES (" + this.getVernr() + ",'" + this.getType() + "','" + this.getSex() + "','" + this.getCatname() + "'," + this.getFighttime() + ",'" + this.getColor() + "');";
    }

    @Override
    public String getUpdateString() {
        return "UPDATE dtmdefaults SET vernr = " + this.getVernr() + ",type = '" + this.getType() + "',sex = '" + this.getSex() + "',catname = '" + this.getCatname() + "',fighttime = " + this.getFighttime() + ",color = '" + this.getColor() + "' WHERE id = " + this.getId() + ";";
    }

    public SimpleObjectProperty<LocalTime> getValue() {
        return this.value;
    }

    public void setValue(SimpleObjectProperty<LocalTime> value) {
        this.value = value;
    }

    public SimpleObjectProperty<ColorPicker> getColorPicker() {
        return this.colorPicker;
    }

    public void setColorPicker(SimpleObjectProperty<ColorPicker> colorPicker) {
        this.colorPicker = colorPicker;
    }

    public SimpleObjectProperty<DTMLocalTimeTextField> getLocalTimeTextField() {
        return this.localTimeTextField;
    }

    public void setLocalTimeTextField(SimpleObjectProperty<DTMLocalTimeTextField> localTimeTextField) {
        this.localTimeTextField = localTimeTextField;
    }

    public SimpleObjectProperty<Button> getDeleteImageViewButton() {
        return this.deleteImageViewButton;
    }

    public void setDeleteImageViewButton(SimpleObjectProperty<Button> deleteImageViewButton) {
        this.deleteImageViewButton = deleteImageViewButton;
    }

    public SimpleObjectProperty<CheckBox> getCbLoad() {
        return this.cbLoad;
    }

    public void setCbLoad(SimpleObjectProperty<CheckBox> cbLoad) {
        this.cbLoad = cbLoad;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getVernr() {
        return this.vernr;
    }

    public void setVernr(int vernr) {
        this.vernr = vernr;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public String getCatname() {
        return this.catname;
    }

    public void setCatname(String catname) {
        this.catname = catname;
    }

    public int getFighttime() {
        return this.fighttime;
    }

    public void setFighttime(int fighttime) {
        this.fighttime = fighttime;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }
}

