/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.converter.EnumConverter;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Slider;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import jfxtras.css.CssMetaDataForSkinProperty;
import jfxtras.css.converters.SimpleDateFormatConverter;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.DTMCalendarTimePicker;

public class DTMCalendarTimePickerSkin
extends SkinBase<DTMCalendarTimePicker> {
    private final ObjectProperty<ShowTickLabels> showTickLabels = new SimpleStyleableObjectProperty<ShowTickLabels>(StyleableProperties.SHOW_TICKLABELS, (Object)this, "showTickLabels", (ShowTickLabels)((Object)StyleableProperties.SHOW_TICKLABELS.getInitialValue(null))){
        {
            this.addListener(invalidationEvent -> DTMCalendarTimePickerSkin.this.refreshLayout());
        }
    };
    private final ObjectProperty<DateFormat> labelDateFormat = new SimpleStyleableObjectProperty<DateFormat>(StyleableProperties.LABEL_DATEFORMAT, (Object)this, "labelDateFormat", (DateFormat)StyleableProperties.LABEL_DATEFORMAT.getInitialValue(null)){
        {
            this.addListener(invalidationEvent -> {
                DTMCalendarTimePickerSkin.this.refreshLayout();
                DTMCalendarTimePickerSkin.this.refresh();
            });
        }
    };
    private final Slider hourScrollSlider = new Slider();
    private final Slider minuteScrollSlider = new Slider();
    private final Slider secondScrollSlider = new Slider();
    private final Text timeText = new Text("XX:XX:XX");
    final Pane hourLabelsPane = new Pane(){
        {
            this.prefWidthProperty().bind((ObservableValue)DTMCalendarTimePickerSkin.this.hourScrollSlider.prefWidthProperty());
            this.layoutChildren();
        }

        protected void layoutChildren() {
            double lX;
            Text lText;
            this.getChildren().clear();
            double lLabelWidth = new Text("88").prefWidth(0.0);
            double lWhitespace = lLabelWidth / 2.0;
            double lLabelWidthPlusWhitespace = lLabelWidth + lWhitespace;
            double lScrollSliderOuterPadding = 5.0;
            Text lText2 = new Text("0");
            Rectangle lRectangle = new Rectangle(0.0, 0.0, DTMCalendarTimePickerSkin.this.minuteScrollSlider.getWidth(), lText2.prefHeight(0.0));
            lRectangle.setFill((Paint)Color.TRANSPARENT);
            this.getChildren().add((Object)lRectangle);
            int lNumberOfLabels = (int)(this.getWidth() / lLabelWidthPlusWhitespace) + 2;
            int lStep = 24;
            if (lNumberOfLabels >= 24) {
                lStep = 1;
            } else if (lNumberOfLabels >= 12) {
                lStep = 2;
            } else if (lNumberOfLabels >= 8) {
                lStep = 3;
            } else if (lNumberOfLabels >= 6) {
                lStep = 4;
            } else if (lNumberOfLabels > 4) {
                lStep = 6;
            } else if (lNumberOfLabels > 2) {
                lStep = 12;
            }
            int i2 = 0;
            while (i2 < 24) {
                lText = new Text("" + i2);
                lText.setY(lText.prefHeight(0.0));
                lX = lScrollSliderOuterPadding + (DTMCalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 23.0 * (double)i2 - lText.prefWidth(0.0) / (double)(i2 == 23 ? 1 : 2) * (double)(i2 != 0 ? 1 : 0);
                lText.setX(lX);
                this.getChildren().add((Object)lText);
                i2 += lStep;
            }
            i2 = 0;
            while (i2 < 24) {
                lText = new Text("0");
                lX = lScrollSliderOuterPadding + (DTMCalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 23.0 * (double)i2;
                this.getChildren().add((Object)new Line(lX, lText.prefHeight(0.0) + 3.0, lX, lText.prefHeight(0.0) + 3.0 + 3.0));
                ++i2;
            }
        }
    };
    final Pane minuteLabelsPane = new Pane(){
        {
            this.layoutChildren();
        }

        protected void layoutChildren() {
            this.getChildren().clear();
            double lLabelWidth = new Text("88").prefWidth(0.0);
            double lWhitespace = lLabelWidth / 2.0;
            double lLabelWidthPlusWhitespace = lLabelWidth + lWhitespace;
            double lScrollSliderOuterPadding = 5.0;
            if (DTMCalendarTimePickerSkin.this.getShowTickLabels() == ShowTickLabels.YES) {
                Text lText = new Text("0");
                Rectangle lRectangle = new Rectangle(0.0, 0.0, DTMCalendarTimePickerSkin.this.minuteScrollSlider.getWidth(), lText.prefHeight(0.0));
                lRectangle.setFill((Paint)Color.TRANSPARENT);
                this.getChildren().add((Object)lRectangle);
            }
            int lNumberOfLabels = (int)(this.getWidth() / lLabelWidthPlusWhitespace) + 2;
            int lStep = 60;
            if (lNumberOfLabels >= 60) {
                lStep = 1;
            } else if (lNumberOfLabels >= 30) {
                lStep = 2;
            } else if (lNumberOfLabels >= 20) {
                lStep = 3;
            } else if (lNumberOfLabels >= 15) {
                lStep = 4;
            } else if (lNumberOfLabels >= 12) {
                lStep = 5;
            } else if (lNumberOfLabels >= 6) {
                lStep = 10;
            } else if (lNumberOfLabels >= 4) {
                lStep = 15;
            } else if (lNumberOfLabels >= 2) {
                lStep = 30;
            }
            if (lStep < ((DTMCalendarTimePicker)DTMCalendarTimePickerSkin.this.getSkinnable()).getMinuteStep()) {
                lStep = ((DTMCalendarTimePicker)DTMCalendarTimePickerSkin.this.getSkinnable()).getMinuteStep();
            }
            int i2 = 0;
            while (i2 <= 59) {
                Text lText = new Text("" + i2);
                lText.setY(lText.prefHeight(0.0));
                double lX = lScrollSliderOuterPadding + (DTMCalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 59.0 * (double)i2 - lText.prefWidth(0.0) / (double)(i2 == 59 ? 1 : 2) * (double)(i2 != 0 ? 1 : 0);
                lText.setX(lX);
                this.getChildren().add((Object)lText);
                i2 += lStep;
            }
            i2 = 0;
            while (i2 <= 59) {
                double lX = lScrollSliderOuterPadding + (DTMCalendarTimePickerSkin.this.minuteScrollSlider.getWidth() - 2.0 * lScrollSliderOuterPadding) / 59.0 * (double)i2;
                this.getChildren().add((Object)new Line(lX, 0.0, lX, 3.0));
                ++i2;
            }
        }
    };
    static final Date DATE = new Date(8099, 0, 1, 2, 3, 4);
    private final AtomicInteger refreshingAtomicInteger = new AtomicInteger(0);
    private Calendar changingCalendar = null;

    public DTMCalendarTimePickerSkin(DTMCalendarTimePicker control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((DTMCalendarTimePicker)this.getSkinnable()).calendarProperty().addListener(observable -> this.refresh());
        ((DTMCalendarTimePicker)this.getSkinnable()).minuteStepProperty().addListener(observable -> this.minuteScrollSlider.setBlockIncrement(((DTMCalendarTimePicker)this.getSkinnable()).getMinuteStep().doubleValue()));
        this.minuteScrollSlider.setBlockIncrement(((DTMCalendarTimePicker)this.getSkinnable()).getMinuteStep().doubleValue());
        ((DTMCalendarTimePicker)this.getSkinnable()).secondStepProperty().addListener(observable -> this.secondScrollSlider.setBlockIncrement(((DTMCalendarTimePicker)this.getSkinnable()).getSecondStep().doubleValue()));
        this.secondScrollSlider.setBlockIncrement(((DTMCalendarTimePicker)this.getSkinnable()).getSecondStep().doubleValue());
        ((DTMCalendarTimePicker)this.getSkinnable()).localeProperty().addListener(observable -> this.refresh());
        this.refresh();
    }

    public final ObjectProperty<ShowTickLabels> showTickLabelsProperty() {
        return this.showTickLabels;
    }

    public final void setShowTickLabels(ShowTickLabels value) {
        this.showTickLabelsProperty().set((Object)value);
    }

    public final ShowTickLabels getShowTickLabels() {
        return (ShowTickLabels)((Object)this.showTickLabels.get());
    }

    public final DTMCalendarTimePickerSkin withShowTickLabels(ShowTickLabels value) {
        this.setShowTickLabels(value);
        return this;
    }

    public final ObjectProperty<DateFormat> labelDateFormatProperty() {
        return this.labelDateFormat;
    }

    public final void setLabelDateFormat(DateFormat value) {
        this.labelDateFormatProperty().set((Object)value);
    }

    public final DateFormat getLabelDateFormat() {
        if (this.labelDateFormat.get() == null) {
            return this.getLABEL_DATEFORMAT_DEFAULT();
        }
        DateFormat labelDateFormat = (DateFormat)this.labelDateFormat.get();
        if (labelDateFormat.getCalendar() == null) {
            labelDateFormat.setCalendar(Calendar.getInstance(((DTMCalendarTimePicker)this.getSkinnable()).getLocale()));
        }
        if (labelDateFormat.getNumberFormat() == null) {
            labelDateFormat.setNumberFormat(NumberFormat.getInstance(((DTMCalendarTimePicker)this.getSkinnable()).getLocale()));
        }
        labelDateFormat = (DateFormat)labelDateFormat.clone();
        labelDateFormat.setTimeZone(TimeZone.getDefault());
        return labelDateFormat;
    }

    public final DTMCalendarTimePickerSkin withLabelDateFormat(DateFormat value) {
        this.setLabelDateFormat(value);
        return this;
    }

    private DateFormat getLABEL_DATEFORMAT_DEFAULT() {
        return DateFormat.getTimeInstance(3, ((DTMCalendarTimePicker)this.getSkinnable()).getLocale());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return DTMCalendarTimePickerSkin.getClassCssMetaData();
    }

    private void createNodes() {
        this.hourScrollSlider.setId("hourSlider");
        this.hourScrollSlider.minProperty().set(0.0);
        this.hourScrollSlider.maxProperty().set(23.0);
        this.hourScrollSlider.setMajorTickUnit(12.0);
        this.hourScrollSlider.setMinorTickCount(3);
        this.hourScrollSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.modifyChangingCalendarHour(newValue.intValue());
            if (!this.hourScrollSlider.valueChangingProperty().get()) {
                this.acceptChangingCalendar();
            }
        });
        this.hourScrollSlider.valueChangingProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.acceptChangingCalendar();
        });
        this.minuteScrollSlider.setId("minuteSlider");
        this.minuteScrollSlider.minProperty().set(0.0);
        this.minuteScrollSlider.maxProperty().set(59.0);
        this.minuteScrollSlider.setMajorTickUnit(10.0);
        this.minuteScrollSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.modifyChangingCalendarMinute(newValue.intValue());
            if (!this.minuteScrollSlider.valueChangingProperty().get()) {
                this.acceptChangingCalendar();
            }
        });
        this.minuteScrollSlider.valueChangingProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.acceptChangingCalendar();
        });
        this.secondScrollSlider.setId("secondSlider");
        this.secondScrollSlider.minProperty().set(0.0);
        this.secondScrollSlider.maxProperty().set(59.0);
        this.secondScrollSlider.setMajorTickUnit(10.0);
        this.secondScrollSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.modifyChangingCalendarSecond(newValue.intValue());
            if (!this.secondScrollSlider.valueChangingProperty().get()) {
                this.acceptChangingCalendar();
            }
        });
        this.secondScrollSlider.valueChangingProperty().addListener((observable, oldValue, newValue) -> {
            if (this.refreshingAtomicInteger.get() > 0) {
                return;
            }
            this.acceptChangingCalendar();
        });
        this.timeText.setDisable(true);
        this.timeText.getStyleClass().add((Object)"timeLabel");
        this.refreshLayout();
        ((DTMCalendarTimePicker)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    public void modifyChangingCalendarSecond(int seconds) {
        Calendar lCalendar = this.getChangingCalendar();
        if (lCalendar == null) {
            lCalendar = Calendar.getInstance();
            lCalendar.set(12, 0);
            lCalendar.set(10, 0);
        } else {
            lCalendar = (Calendar)lCalendar.clone();
        }
        int lSecondStep = ((DTMCalendarTimePicker)this.getSkinnable()).getSecondStep();
        if (lSecondStep > 1 && (seconds += ((DTMCalendarTimePicker)this.getSkinnable()).getSecondStep() / 2) > 59) {
            seconds -= lSecondStep;
        }
        lCalendar.set(13, seconds);
        lCalendar = DTMCalendarTimePickerSkin.blockSecondsToStep(lCalendar, ((DTMCalendarTimePicker)this.getSkinnable()).getMinuteStep());
        this.setChangingCalendar(lCalendar);
    }

    public void modifyChangingCalendarMinute(int minutes) {
        Calendar lCalendar = this.getChangingCalendar();
        if (lCalendar == null) {
            lCalendar = Calendar.getInstance();
            lCalendar.set(11, 0);
            lCalendar.set(10, 0);
            lCalendar.set(13, 0);
        } else {
            lCalendar = (Calendar)lCalendar.clone();
        }
        int lMinuteStep = ((DTMCalendarTimePicker)this.getSkinnable()).getMinuteStep();
        if (lMinuteStep > 1 && (minutes += ((DTMCalendarTimePicker)this.getSkinnable()).getMinuteStep() / 2) > 59) {
            minutes -= lMinuteStep;
        }
        lCalendar.set(12, minutes);
        lCalendar = DTMCalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((DTMCalendarTimePicker)this.getSkinnable()).getMinuteStep());
        this.setChangingCalendar(lCalendar);
    }

    public void modifyChangingCalendarHour(int hour) {
        Calendar lCalendar = this.getChangingCalendar();
        if (lCalendar == null) {
            lCalendar = Calendar.getInstance();
            lCalendar.set(12, 0);
            lCalendar.set(13, 0);
        } else {
            lCalendar = (Calendar)lCalendar.clone();
        }
        lCalendar.set(11, hour);
        this.setChangingCalendar(lCalendar);
    }

    private void refreshLayout() {
        DateFormat labelDateFormat = this.getLabelDateFormat();
        String formattedDate = labelDateFormat.format(DATE);
        this.getChildren().clear();
        StackPane lStackPane = new StackPane();
        VBox lVBox = new VBox(0.0);
        lVBox.alignmentProperty().set((Object)Pos.CENTER);
        if (formattedDate.contains("2")) {
            if (this.getShowTickLabels() == ShowTickLabels.YES) {
                lVBox.getChildren().add((Object)this.hourLabelsPane);
            }
            lVBox.getChildren().add((Object)this.hourScrollSlider);
        }
        if (formattedDate.contains("3")) {
            lVBox.getChildren().add((Object)this.minuteScrollSlider);
            if (this.getShowTickLabels() == ShowTickLabels.YES) {
                lVBox.getChildren().add((Object)this.minuteLabelsPane);
            }
        }
        if (formattedDate.contains("4")) {
            lVBox.getChildren().add((Object)this.secondScrollSlider);
        }
        lStackPane.getChildren().add((Object)lVBox);
        lStackPane.getChildren().add((Object)this.timeText);
        StackPane.setAlignment((Node)this.timeText, (Pos)(this.getShowTickLabels() == ShowTickLabels.YES ? Pos.CENTER : Pos.TOP_CENTER));
        this.getChildren().add((Object)lStackPane);
    }

    private void refresh() {
        try {
            this.refreshingAtomicInteger.addAndGet(1);
            Calendar lCalendar = this.getChangingCalendar();
            int lHour = lCalendar == null ? 0 : lCalendar.get(11);
            int lMinute = lCalendar == null ? 0 : lCalendar.get(12);
            int lSecond = lCalendar == null ? 0 : lCalendar.get(13);
            this.hourScrollSlider.valueProperty().set((double)lHour);
            this.minuteScrollSlider.valueProperty().set((double)lMinute);
            this.secondScrollSlider.valueProperty().set((double)lSecond);
            this.timeText.setText(lCalendar == null ? "" : this.getLabelDateFormat().format(lCalendar.getTime()));
        }
        finally {
            this.refreshingAtomicInteger.addAndGet(-1);
        }
    }

    public static Calendar blockMinutesToStep(Calendar calendar, Integer stepSize) {
        if (stepSize == null || calendar == null) {
            return calendar;
        }
        if (calendar.get(10) == 0) {
            calendar.set(11, 0);
        }
        int lValue = calendar.get(12);
        if (stepSize == 1) {
            return calendar;
        }
        lValue /= stepSize.intValue();
        if (calendar.get(12) != (lValue *= stepSize.intValue())) {
            Calendar lCalendar = (Calendar)calendar.clone();
            lCalendar.set(12, lValue);
            calendar = lCalendar;
        }
        return calendar;
    }

    public static Calendar blockSecondsToStep(Calendar calendar, Integer stepSize) {
        if (stepSize == null || calendar == null) {
            return calendar;
        }
        int lValue = calendar.get(13);
        if (stepSize == 1) {
            return calendar;
        }
        lValue /= stepSize.intValue();
        if (calendar.get(13) != (lValue *= stepSize.intValue())) {
            Calendar lCalendar = (Calendar)calendar.clone();
            lCalendar.set(13, lValue);
            calendar = lCalendar;
        }
        return calendar;
    }

    private Calendar getChangingCalendar() {
        if (this.changingCalendar != null) {
            return this.changingCalendar;
        }
        return ((DTMCalendarTimePicker)this.getSkinnable()).getCalendar();
    }

    public void setChangingCalendar(Calendar lCalendar) {
        if (!lCalendar.equals(this.getChangingCalendar())) {
            this.changingCalendar = lCalendar;
            this.refresh();
        }
    }

    public void acceptChangingCalendar() {
        if (this.changingCalendar != null) {
            if (this.callValueValidationCallback((Calendar)this.changingCalendar.clone())) {
                ((DTMCalendarTimePicker)this.getSkinnable()).setCalendar(this.changingCalendar);
            }
            this.changingCalendar = null;
            this.refresh();
        }
    }

    private boolean callValueValidationCallback(Calendar value) {
        Callback<Calendar, Boolean> lCallback = ((DTMCalendarTimePicker)this.getSkinnable()).getValueValidationCallback();
        if (lCallback == null) {
            return true;
        }
        return (Boolean)lCallback.call((Object)value);
    }

    public static enum ShowTickLabels {
        YES,
        NO;

    }

    private static class StyleableProperties {
        private static final CssMetaData<DTMCalendarTimePicker, ShowTickLabels> SHOW_TICKLABELS = new CssMetaDataForSkinProperty<DTMCalendarTimePicker, DTMCalendarTimePickerSkin, ShowTickLabels>("-fxx-show-ticklabels", (StyleConverter)new EnumConverter(ShowTickLabels.class), ShowTickLabels.NO){

            protected ObjectProperty<ShowTickLabels> getProperty(DTMCalendarTimePickerSkin s2) {
                return s2.showTickLabelsProperty();
            }
        };
        private static final CssMetaData<DTMCalendarTimePicker, DateFormat> LABEL_DATEFORMAT = new CssMetaDataForSkinProperty<DTMCalendarTimePicker, DTMCalendarTimePickerSkin, DateFormat>("-fxx-label-dateformat", (StyleConverter)new SimpleDateFormatConverter(), null){

            protected ObjectProperty<DateFormat> getProperty(DTMCalendarTimePickerSkin s2) {
                return s2.labelDateFormatProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        static {
            ArrayList<Object> styleables = new ArrayList<Object>(SkinBase.getClassCssMetaData());
            styleables.add(SHOW_TICKLABELS);
            styleables.add(LABEL_DATEFORMAT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }

        private StyleableProperties() {
        }
    }
}

