/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javafx.collections.ObservableList;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda.Agenda;

public class AllAppointments {
    final ObservableList<Agenda.Appointment> appointments;
    private List<Runnable> runnables = new ArrayList<Runnable>();

    public AllAppointments(ObservableList<Agenda.Appointment> appointments) {
        this.appointments = appointments;
        appointments.addListener(change -> this.fireOnChangeListener());
    }

    public void addOnChangeListener(Runnable runnable) {
        this.runnables.add(runnable);
    }

    public void removeOnChangeListener(Runnable runnable) {
        this.runnables.remove(runnable);
    }

    private void fireOnChangeListener() {
        for (Runnable runnable : this.runnables) {
            runnable.run();
        }
    }

    public void dispose() {
        for (Runnable r2 : this.runnables) {
            Object var1_2 = null;
        }
        this.runnables.clear();
    }

    public List<Agenda.Appointment> collectWholedayFor(LocalDate localDate) {
        ArrayList<Agenda.Appointment> collectedAppointments = new ArrayList<Agenda.Appointment>();
        for (Agenda.Appointment lAppointment : this.appointments) {
            LocalDate endLocalDate;
            if (!lAppointment.isWholeDay().booleanValue()) continue;
            LocalDate startLocalDate = lAppointment.getStartLocalDateTime().toLocalDate();
            LocalDate localDate2 = endLocalDate = lAppointment.getEndLocalDateTime() == null ? startLocalDate : lAppointment.getEndLocalDateTime().minusNanos(1L).toLocalDate();
            if (!startLocalDate.isEqual(localDate) && !startLocalDate.isBefore(localDate) || !endLocalDate.isEqual(localDate) && !endLocalDate.isAfter(localDate)) continue;
            collectedAppointments.add(lAppointment);
        }
        return collectedAppointments;
    }

    public List<Agenda.Appointment> collectTaskFor(LocalDate localDate) {
        ArrayList<Agenda.Appointment> collectedAppointments = new ArrayList<Agenda.Appointment>();
        for (Agenda.Appointment lAppointment : this.appointments) {
            if (lAppointment.isWholeDay().booleanValue() || lAppointment.getEndLocalDateTime() != null || !lAppointment.getStartLocalDateTime().toLocalDate().isEqual(localDate)) continue;
            collectedAppointments.add(lAppointment);
        }
        return collectedAppointments;
    }

    public List<Agenda.Appointment> collectRegularFor(LocalDate localDate) {
        ArrayList<Agenda.Appointment> collectedAppointments = new ArrayList<Agenda.Appointment>();
        for (Agenda.Appointment lAppointment : this.appointments) {
            if (lAppointment.isWholeDay().booleanValue() || lAppointment.getEndLocalDateTime() == null) continue;
            LocalDate startLocalDate = lAppointment.getStartLocalDateTime().toLocalDate();
            LocalDate endLocalDate = lAppointment.getEndLocalDateTime().minusNanos(1L).toLocalDate();
            if (!startLocalDate.isEqual(localDate) && !startLocalDate.isBefore(localDate) || !endLocalDate.isEqual(localDate) && !endLocalDate.isAfter(localDate)) continue;
            collectedAppointments.add(lAppointment);
        }
        return collectedAppointments;
    }
}

