/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.Duration;
import java.time.LocalDateTime;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.util.Callback;
import jfxtras.util.NodeUtil;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.internal.beans.DTMMaster;
import org.sportdata.set.extension.dtm.internal.mapper.DoubleStartChecker;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentMenu;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda.Agenda;
import org.sportdata.set.extension.dtm.util.DTMUtil;

public abstract class AppointmentAbstractPane
extends Pane {
    protected final TimetableBean appointment;
    protected final LayoutHelp layoutHelp;
    public final AppointmentMenu appointmentMenu;
    private static final String SELECTED = "Selected";
    private boolean dragging = false;
    private LocalDateTime dragPickupDateTime;
    private boolean pressEventCaught = false;
    private Rectangle dragRectangle = null;
    private double startX = 0.0;
    private double startY = 0.0;
    private boolean mouseActuallyHasDragged = false;
    private int roundToMinutes;
    private Text startTimeText = null;
    private Text endTimeText = null;
    private TimetableBean appointmentForDrag = null;
    public static final int DRAG_DAY = 1;
    public static final int DRAG_DAYHEADER = 0;

    public AppointmentAbstractPane(TimetableBean appointment, LayoutHelp layoutHelp) {
        this.appointment = appointment;
        this.layoutHelp = layoutHelp;
        this.appointmentMenu = new AppointmentMenu(this, appointment, layoutHelp);
        this.roundToMinutes = layoutHelp.skinnable.controller.cellSizeMode;
        this.getStyleClass().add((Object)"Appointment");
        if (appointment.getAppointmentGroup().getStyleClass().contains("#")) {
            this.setStyle("-fx-background-color:" + appointment.getAppointmentGroup().getStyleClass() + ";");
            appointment.setColor(appointment.getAppointmentGroup().getStyleClass());
        } else {
            this.getStyleClass().add((Object)appointment.getAppointmentGroup().getStyleClass());
        }
        if (appointment.getSummary() != null) {
            Tooltip.install((Node)this, (Tooltip)new Tooltip(appointment.getSummary()));
        }
        this.setupDragging();
        layoutHelp.skinnable.selectedAppointments().addListener(change -> this.setOrRemoveSelected());
    }

    private void setOrRemoveSelected() {
        if (this.getStyleClass().contains((Object)SELECTED) && !this.layoutHelp.skinnable.selectedAppointments().contains((Object)this.appointment)) {
            this.getStyleClass().remove((Object)SELECTED);
        }
        if (!this.getStyleClass().contains((Object)SELECTED) && this.layoutHelp.skinnable.selectedAppointments().contains((Object)this.appointment)) {
            this.getStyleClass().add((Object)SELECTED);
        }
    }

    private void setupDragging() {
        this.setOnMousePressed(mouseEvent -> {
            this.pressEventCaught = true;
            this.layoutHelp.skinnable.setCurrentArea(this.appointment.getTatami());
            mouseEvent.consume();
            if (!this.layoutHelp.skinnable.getAllowDragging()) {
                this.handleSelect((MouseEvent)mouseEvent);
                return;
            }
            if (mouseEvent.getClickCount() > 1 && !mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.appointmentMenu.showMenu((MouseEvent)mouseEvent);
                this.layoutHelp.skinnable.emptyFieldRectangle().set(null);
                return;
            }
            this.startX = mouseEvent.getX();
            this.startY = mouseEvent.getY();
            this.dragPickupDateTime = this.layoutHelp.skin.convertClickInSceneToDateTime(mouseEvent.getSceneX(), mouseEvent.getSceneY());
            this.mouseActuallyHasDragged = false;
            this.dragging = true;
        });
        this.setOnMouseDragged(mouseEvent -> {
            if (!this.dragging || !mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            mouseEvent.consume();
            if (this.dragRectangle == null) {
                this.setCursor(Cursor.MOVE);
                this.dragRectangle = new Rectangle(0.0, 0.0, NodeUtil.snapWH((double)0.0, (double)this.getWidth()), NodeUtil.snapWH((double)0.0, (double)(this.appointment.isWholeDay() != false ? this.layoutHelp.titleDateTimeHeightProperty.get() : this.getHeight())));
                this.dragRectangle.getStyleClass().add((Object)"GhostRectangle");
                this.layoutHelp.dragPane.getChildren().add((Object)this.dragRectangle);
                this.startTimeText = new Text("...");
                this.startTimeText.getStyleClass().add((Object)"GhostRectangleText");
                if (this.showStartTimeText()) {
                    this.layoutHelp.dragPane.getChildren().add((Object)this.startTimeText);
                }
                this.endTimeText = new Text("...");
                this.endTimeText.getStyleClass().add((Object)"GhostRectangleText");
                if (this.showEndTimeText()) {
                    this.layoutHelp.dragPane.getChildren().add((Object)this.endTimeText);
                }
                this.appointmentForDrag = new TimetableBean();
            }
            double lX = NodeUtil.xInParent((Node)this, (Node)this.layoutHelp.dragPane) + (mouseEvent.getX() - this.startX);
            double lY = NodeUtil.yInParent((Node)this, (Node)this.layoutHelp.dragPane) + (mouseEvent.getY() - this.startY);
            this.dragRectangle.setX(NodeUtil.snapXY((double)lX));
            this.dragRectangle.setY(NodeUtil.snapXY((double)lY));
            this.startTimeText.layoutXProperty().set(this.dragRectangle.getX());
            this.startTimeText.layoutYProperty().set(this.dragRectangle.getY());
            this.endTimeText.layoutXProperty().set(this.dragRectangle.getX());
            this.endTimeText.layoutYProperty().set(this.dragRectangle.getY() + this.dragRectangle.getHeight() + this.endTimeText.getBoundsInParent().getHeight());
            this.mouseActuallyHasDragged = true;
            this.appointmentForDrag.setStartLocalDateTime(this.appointment.getStartLocalDateTime());
            this.appointmentForDrag.setEndLocalDateTime(this.appointment.getEndLocalDateTime());
            this.appointmentForDrag.setWholeDay(this.appointment.isWholeDay());
            LocalDateTime dragEndDateTime = this.layoutHelp.skin.convertClickInSceneToDateTime(mouseEvent.getSceneX(), mouseEvent.getSceneY());
            if (dragEndDateTime != null) {
                this.handleDrag(this.appointmentForDrag, this.dragPickupDateTime, dragEndDateTime, false);
                this.startTimeText.setText(this.appointmentForDrag.isWholeDay() != false ? "" : this.layoutHelp.timeDateTimeFormatter.format(this.appointmentForDrag.getStartLocalDateTime()));
                this.endTimeText.setText(this.appointmentForDrag.isWholeDay() != false ? "" : this.layoutHelp.timeDateTimeFormatter.format(this.appointmentForDrag.getEndLocalDateTime()));
            }
        });
        this.setOnMouseReleased(mouseEvent -> {
            if (!this.pressEventCaught) {
                if (!this.layoutHelp.skinnable.getAllowDragging()) {
                    this.handleSelect((MouseEvent)mouseEvent);
                    return;
                }
                this.startX = mouseEvent.getX();
                this.startY = mouseEvent.getY();
                this.mouseActuallyHasDragged = false;
                this.dragging = true;
            }
            this.pressEventCaught = false;
            this.layoutHelp.skinnable.setEmptyFieldRectangle(null);
            if (!this.dragging) {
                return;
            }
            mouseEvent.consume();
            this.dragging = false;
            this.setCursor(Cursor.HAND);
            if (this.dragRectangle != null) {
                this.layoutHelp.dragPane.getChildren().remove((Object)this.dragRectangle);
                this.layoutHelp.dragPane.getChildren().remove((Object)this.startTimeText);
                this.layoutHelp.dragPane.getChildren().remove((Object)this.endTimeText);
                this.dragRectangle = null;
                this.startTimeText = null;
                this.endTimeText = null;
                this.appointmentForDrag = null;
            }
            if (!this.mouseActuallyHasDragged) {
                this.handleSelect((MouseEvent)mouseEvent);
                return;
            }
            LocalDateTime dragDropDateTime = this.layoutHelp.skin.convertClickInSceneToDateTime(mouseEvent.getSceneX(), mouseEvent.getSceneY());
            if (dragDropDateTime != null) {
                this.layoutHelp.skinnable.setCurrentArea(DTMUtil.getAreaNumber(this.layoutHelp.skinnable.controller.getDays().getLocalDate(), dragDropDateTime.toLocalDate(), DTMMaster.getInstance().getEvent()));
                if (!this.handleDrag(this.appointment, this.dragPickupDateTime, dragDropDateTime, true)) {
                    return;
                }
                if (this.layoutHelp.skinnable.controller.cbCheckDoubleStarts.isSelected()) {
                    this.layoutHelp.skinnable.controller.doublestarts = DoubleStartChecker.getDoubleStarts();
                    this.layoutHelp.skinnable.controller.checkDoubleStarts(null, this.appointment, true);
                }
                this.appointment.update();
                this.layoutHelp.skinnable.controller.refreshCurrentSkin(this.appointment);
            }
        });
    }

    protected boolean showStartTimeText() {
        return true;
    }

    protected boolean showEndTimeText() {
        return true;
    }

    private boolean handleDrag(TimetableBean appointment, LocalDateTime dragPickupDateTime, LocalDateTime dragDropDateTime, boolean checkOverlap) {
        boolean dragPickupInDayBody = this.dragInDayBody(dragPickupDateTime);
        boolean dragPickupInDayHeader = this.dragInDayHeader(dragPickupDateTime);
        dragPickupDateTime = this.layoutHelp.roundTimeToNearestMinutes(dragPickupDateTime, this.roundToMinutes);
        boolean dragDropInDayBody = this.dragInDayBody(dragDropDateTime);
        boolean dragDropInDayHeader = this.dragInDayHeader(dragDropDateTime);
        dragDropDateTime = this.layoutHelp.roundTimeToNearestMinutes(dragDropDateTime, this.roundToMinutes);
        if (dragPickupInDayBody && dragDropInDayBody || dragPickupInDayHeader && dragDropInDayHeader) {
            LocalDateTime oldStart = appointment.getStartLocalDateTime();
            LocalDateTime oldEnd = appointment.getEndLocalDateTime();
            Duration duration = Duration.between(dragPickupDateTime, dragDropDateTime);
            if (appointment.getStartLocalDateTime() != null) {
                appointment.setStartLocalDateTime(appointment.getStartLocalDateTime().plus(duration));
            }
            if (appointment.getEndLocalDateTime() != null) {
                appointment.setEndLocalDateTime(appointment.getEndLocalDateTime().plus(duration));
            }
            if (checkOverlap && !this.layoutHelp.skinnable.controller.overlapConfirmed(appointment)) {
                appointment.setEndLocalDateTime(oldEnd);
                appointment.setStartLocalDateTime(oldStart);
                return false;
            }
        }
        return true;
    }

    private void handleSelect(MouseEvent mouseEvent) {
        if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
            this.layoutHelp.skinnable.selectedAppointments().clear();
        }
        if (!this.layoutHelp.skinnable.selectedAppointments().contains((Object)this.appointment)) {
            this.layoutHelp.skinnable.selectedAppointments().add((Object)this.appointment);
        } else if (mouseEvent.isControlDown()) {
            this.layoutHelp.skinnable.selectedAppointments().remove((Object)this.appointment);
        }
    }

    private void handleAction() {
        Callback<Agenda.Appointment, Void> lCallback = this.layoutHelp.skinnable.getActionCallback();
        if (lCallback != null) {
            lCallback.call((Object)this.appointment);
            return;
        }
    }

    private boolean dragInDayBody(LocalDateTime localDateTime) {
        return localDateTime.getNano() == 1;
    }

    private boolean dragInDayHeader(LocalDateTime localDateTime) {
        return localDateTime.getNano() == 0;
    }

    public String toString() {
        return "appointment=" + String.valueOf(this.appointment.getStartLocalDateTime()) + "-" + String.valueOf(this.appointment.getEndLocalDateTime()) + ";sumary=" + this.appointment.getSummary();
    }
}

