/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Text;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractTrackedPane;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.DurationDragger;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda.Agenda;

public class AppointmentRegularBodyPane
extends AppointmentAbstractTrackedPane {
    private Text lTimeText;
    private String startAsString;
    private String endAsString;
    private DurationDragger durationDragger = null;

    public AppointmentRegularBodyPane(LocalDate localDate, Agenda.Appointment appointment, LayoutHelp layoutHelp) {
        super(localDate, appointment, layoutHelp);
        this.startAsString = layoutHelp.timeDateTimeFormatter.format(this.startDateTime);
        this.endAsString = layoutHelp.timeDateTimeFormatter.format(this.endDateTime);
        this.appointment.regularBodyPaneProperty().set((Object)this);
        boolean enoughSpaceForTime = this.startDateTime.until(this.endDateTime, ChronoUnit.MINUTES) > (long)(layoutHelp.skinnable.controller.cellSizeMode * 3);
        this.lTimeText = null;
        if (enoughSpaceForTime) {
            this.lTimeText = new Text((this.firstPaneOfAppointment ? this.startAsString : "") + "-" + (this.lastPaneOfAppointment ? this.endAsString : ""));
            this.lTimeText.getStyleClass().add((Object)"AppointmentTimeLabel");
            this.lTimeText.setX(layoutHelp.paddingProperty.get());
            this.lTimeText.setY(this.lTimeText.prefHeight(0.0));
            layoutHelp.clip(this.lTimeText, (ObservableValue<? extends Number>)this.widthProperty().subtract(layoutHelp.paddingProperty.get()), (ObservableValue<? extends Number>)this.heightProperty());
            this.getChildren().add((Object)this.lTimeText);
        }
        Text lSummaryText = ((TimetableBean)appointment).getType() != 5 ? new Text(((TimetableBean)appointment).getCatname() + " (" + ((TimetableBean)appointment).getEntries() + ")") : new Text(((TimetableBean)appointment).getComment());
        if (enoughSpaceForTime) {
            lSummaryText.getStyleClass().add((Object)"AppointmentLabel");
            lSummaryText.setX(layoutHelp.paddingProperty.get());
            lSummaryText.setY(this.lTimeText.getY() + layoutHelp.textHeightProperty.get());
        } else {
            lSummaryText.getStyleClass().add((Object)"AppointmentLabelSmall");
            lSummaryText.setX(layoutHelp.paddingProperty.get());
            lSummaryText.setY(layoutHelp.textHeightProperty.get() - 5.0);
        }
        lSummaryText.wrappingWidthProperty().bind((ObservableValue)this.widthProperty().subtract(layoutHelp.paddingProperty.get()));
        layoutHelp.clip(lSummaryText, (ObservableValue<? extends Number>)this.widthProperty(), (ObservableValue<? extends Number>)this.heightProperty().subtract(layoutHelp.paddingProperty.get()));
        this.getChildren().add((Object)lSummaryText);
        if (enoughSpaceForTime) {
            this.getChildren().add((Object)this.appointmentMenu);
        }
        layoutHelp.skinnable.allowResizeProperty().addListener((InvalidationListener)new WeakInvalidationListener(observable -> this.setupDurationDragger()));
        this.setupDurationDragger();
    }

    public void refresh() {
        this.startDateTime = this.appointment.getStartLocalDateTime();
        if (this.appointment.getEndLocalDateTime() == null) {
            this.endDateTime = null;
            this.durationInMS = 0L;
        } else {
            this.endDateTime = this.appointment.getEndLocalDateTime();
            this.durationInMS = this.startDateTime.until(this.endDateTime, ChronoUnit.MILLIS);
        }
        this.startAsString = this.layoutHelp.timeDateTimeFormatter.format(this.startDateTime);
        this.endAsString = this.layoutHelp.timeDateTimeFormatter.format(this.endDateTime);
        if (this.lTimeText != null) {
            this.lTimeText.setText((this.firstPaneOfAppointment ? this.startAsString : "") + "-" + (this.lastPaneOfAppointment ? this.endAsString : ""));
        }
        Tooltip.install((Node)this, (Tooltip)new Tooltip(this.appointment.getSummary()));
    }

    private void setupDurationDragger() {
        if (this.lastPaneOfAppointment && this.layoutHelp.skinnable.getAllowResize()) {
            if (this.durationDragger == null) {
                this.durationDragger = new DurationDragger(this, this.appointment, this.layoutHelp);
            }
            this.getChildren().add((Object)this.durationDragger);
        } else {
            this.getChildren().remove((Object)this.durationDragger);
        }
    }
}

