/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import jfxtras.util.NodeUtil;
import org.sportdata.set.W.a.b;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.AllAppointments;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentWholedayHeaderPane;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda.Agenda;
import org.sportdata.set.utils.j;

public class DayHeaderPane
extends Pane {
    final ObjectProperty<LocalDate> localDateObjectProperty = new SimpleObjectProperty((Object)this, "localDate");
    final AllAppointments allAppointments;
    final LayoutHelp layoutHelp;
    final String headerText;
    private Text dayText = new Text("?");
    private final List<Agenda.Appointment> appointments = new ArrayList<Agenda.Appointment>();
    private final List<AppointmentWholedayHeaderPane> appointmentHeaderPanes = new ArrayList<AppointmentWholedayHeaderPane>();

    public DayHeaderPane(LocalDate localDate, AllAppointments allAppointments, LayoutHelp layoutHelp, String headerText) {
        this.localDateObjectProperty.set((Object)localDate);
        this.allAppointments = allAppointments;
        this.layoutHelp = layoutHelp;
        this.headerText = headerText;
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)"DayHeader");
        this.dayText = new Text("?");
        if (b.cP().equals("true") && b.i().equals("Nimbus") || j.f() || j.e()) {
            this.dayText.setStyle("-fx-fill:WHITE;");
        } else {
            this.dayText.getStyleClass().add((Object)"DayLabel");
        }
        this.dayText.setX(this.layoutHelp.paddingProperty.get());
        this.dayText.setY(this.dayText.prefHeight(0.0));
        this.getChildren().add((Object)this.dayText);
        Rectangle lClip = new Rectangle(0.0, 0.0, 0.0, 0.0);
        lClip.widthProperty().bind((ObservableValue)this.widthProperty().subtract(this.layoutHelp.paddingProperty.get()));
        lClip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.dayText.setClip((Node)lClip);
        this.localDateObjectProperty.addListener(observable -> this.setLabel());
        this.setLabel();
        this.setupAppointments();
        this.setupMouse();
    }

    private void setLabel() {
        String lLabel = ((LocalDate)this.localDateObjectProperty.get()).format(this.layoutHelp.dayOfWeekDateTimeFormatter) + " " + ((LocalDate)this.localDateObjectProperty.get()).format(this.layoutHelp.dateDateTimeFormatter);
        this.dayText.setText(this.headerText);
        this.setId("DayHeader" + String.valueOf(this.localDateObjectProperty.get()));
    }

    public void setupAppointments() {
        this.getChildren().removeAll(this.appointmentHeaderPanes);
        this.appointmentHeaderPanes.clear();
        int lCnt = 0;
        for (Agenda.Appointment lAppointment : this.appointments) {
            AppointmentWholedayHeaderPane lAppointmentHeaderPane = new AppointmentWholedayHeaderPane(lAppointment, this.layoutHelp);
            this.getChildren().add((Object)lAppointmentHeaderPane);
            this.appointmentHeaderPanes.add(lAppointmentHeaderPane);
            lAppointmentHeaderPane.setId(((Object)((Object)lAppointmentHeaderPane)).getClass().getSimpleName() + String.valueOf(this.localDateObjectProperty.get()) + "/" + lCnt);
            lAppointmentHeaderPane.layoutXProperty().bind((ObservableValue)this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty.multiply(lCnt));
            lAppointmentHeaderPane.layoutYProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)this.layoutHelp.appointmentHeaderPaneHeightProperty.multiply(this.appointments.size() - lCnt)));
            lAppointmentHeaderPane.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract((ObservableNumberValue)this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty.multiply(lCnt)));
            lAppointmentHeaderPane.prefHeightProperty().bind((ObservableValue)this.heightProperty().subtract((ObservableNumberValue)lAppointmentHeaderPane.layoutYProperty()));
            ++lCnt;
        }
    }

    public int getNumberOfWholeDayAppointments() {
        return this.appointments.size();
    }

    private void setupMouse() {
    }

    LocalDateTime convertClickInSceneToDateTime(double x2, double y2) {
        Rectangle r2 = new Rectangle(NodeUtil.sceneX((Node)this), NodeUtil.sceneY((Node)this), this.getWidth(), this.getHeight());
        if (r2.contains(x2, y2)) {
            LocalDate localDate = (LocalDate)this.localDateObjectProperty.get();
            LocalDateTime localDateTime = localDate.atStartOfDay();
            localDateTime = localDateTime.withNano(0);
            return localDateTime;
        }
        return null;
    }
}

