/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDateTime;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import jfxtras.util.NodeUtil;
import org.sportdata.set.extension.dtm.internal.mapper.DoubleStartChecker;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentRegularBodyPane;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda.Agenda;

public class DurationDragger
extends Rectangle {
    private final AppointmentRegularBodyPane appointmentPane;
    private final Agenda.Appointment appointment;
    private final LayoutHelp layoutHelp;
    private int roundToMinutes = 5;
    private double minimumHeight = 5.0;
    private Rectangle resizeRectangle = null;
    private Text endTimeText = null;

    public DurationDragger(AppointmentRegularBodyPane appointmentPane, Agenda.Appointment appointment, LayoutHelp layoutHelp) {
        this.appointmentPane = appointmentPane;
        this.appointment = appointment;
        this.layoutHelp = layoutHelp;
        this.xProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)appointmentPane.widthProperty().multiply(0.25)));
        this.yProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)appointmentPane.heightProperty().subtract(5)));
        this.widthProperty().bind((ObservableValue)appointmentPane.widthProperty().multiply(0.5));
        this.setHeight(3.0);
        this.roundToMinutes = layoutHelp.skinnable.controller.cellSizeMode;
        this.minimumHeight = (double)(this.roundToMinutes * 60 * 1000) / layoutHelp.durationInMSPerPixelProperty.get();
        this.getStyleClass().add((Object)"DurationDragger");
        layoutHelp.setupMouseOverForResize((Node)this);
        this.setupMouseDrag();
    }

    private void setupMouseDrag() {
        this.setOnMousePressed(mouseEvent -> {
            if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            mouseEvent.consume();
            this.setCursor(Cursor.V_RESIZE);
            this.resizeRectangle = new Rectangle(this.appointmentPane.getLayoutX(), this.appointmentPane.getLayoutY(), this.appointmentPane.getWidth(), this.appointmentPane.getHeight());
            this.resizeRectangle.getStyleClass().add((Object)"GhostRectangle");
            ((Pane)this.appointmentPane.getParent()).getChildren().add((Object)this.resizeRectangle);
            this.endTimeText = new Text(this.layoutHelp.timeDateTimeFormatter.format(this.appointment.getEndLocalDateTime()));
            this.endTimeText.layoutXProperty().set(this.appointmentPane.getLayoutX());
            this.endTimeText.layoutYProperty().bind((ObservableValue)this.resizeRectangle.heightProperty().add(this.appointmentPane.getLayoutY()));
            this.endTimeText.getStyleClass().add((Object)"GhostRectangleText");
            ((Pane)this.appointmentPane.getParent()).getChildren().add((Object)this.endTimeText);
        });
        this.setOnMouseDragged(mouseEvent -> {
            if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            mouseEvent.consume();
            double lNodeScreenY = NodeUtil.screenY((Node)this.appointmentPane);
            double lMouseY = mouseEvent.getScreenY();
            double lHeight = lMouseY - lNodeScreenY;
            if (lHeight < this.minimumHeight) {
                lHeight = this.minimumHeight;
            }
            this.resizeRectangle.setHeight(NodeUtil.snapWH((double)this.resizeRectangle.getLayoutY(), (double)lHeight));
            LocalDateTime endLocalDateTime = this.calculateEndDateTime();
            this.endTimeText.setText(this.layoutHelp.timeDateTimeFormatter.format(endLocalDateTime));
        });
        this.setOnMouseReleased(mouseEvent -> {
            if (!mouseEvent.getButton().equals((Object)MouseButton.PRIMARY)) {
                return;
            }
            LocalDateTime endLocalDateTime = this.calculateEndDateTime();
            mouseEvent.consume();
            this.setCursor(Cursor.HAND);
            ((Pane)this.appointmentPane.getParent()).getChildren().remove((Object)this.resizeRectangle);
            this.resizeRectangle = null;
            ((Pane)this.appointmentPane.getParent()).getChildren().remove((Object)this.endTimeText);
            this.endTimeText = null;
            boolean oldEdited = this.appointmentPane.appointment.isEdited();
            LocalDateTime oldEndLocalDateTime = this.appointmentPane.appointment.getEndLocalDateTime();
            if (!endLocalDateTime.equals(this.appointmentPane.appointment.getEndLocalDateTime())) {
                this.appointmentPane.appointment.setEdited(true);
            }
            this.appointmentPane.appointment.setEndLocalDateTime(endLocalDateTime);
            if (!this.layoutHelp.skinnable.controller.overlapConfirmed(this.appointmentPane.appointment)) {
                this.appointmentPane.appointment.setEndLocalDateTime(oldEndLocalDateTime);
                this.appointmentPane.appointment.setEdited(oldEdited);
                return;
            }
            if (this.layoutHelp.skinnable.controller.cbCheckDoubleStarts.isSelected()) {
                this.layoutHelp.skinnable.controller.doublestarts = DoubleStartChecker.getDoubleStarts();
                this.layoutHelp.skinnable.controller.checkDoubleStarts(null, this.appointmentPane.appointment, true);
            }
            this.appointmentPane.appointment.update();
            this.layoutHelp.skinnable.controller.refreshCurrentSkin(this.appointmentPane.appointment);
        });
    }

    private LocalDateTime calculateEndDateTime() {
        int ms = (int)(this.resizeRectangle.getHeight() * this.layoutHelp.durationInMSPerPixelProperty.get());
        LocalDateTime endLocalDateTime = this.appointmentPane.startDateTime.plusSeconds(ms / 1000);
        endLocalDateTime = this.layoutHelp.roundTimeToNearestMinutes(endLocalDateTime, this.roundToMinutes);
        return endLocalDateTime;
    }
}

