/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda;

import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.TreeMap;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.AgendaEventSkin;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.AgendaSkin;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import org.sportdata.set.extension.dtm.view.FXMLDTM2Controller;

public class Agenda
extends Control {
    public LayoutHelp layoutHelp;
    public FXMLDTM2Controller controller = null;
    private final ObservableList<Appointment> appointments = FXCollections.observableArrayList();
    private final ObservableList<AppointmentGroup> appointmentGroups = FXCollections.observableArrayList();
    private final ObjectProperty<Locale> localeObjectProperty = new SimpleObjectProperty((Object)this, "locale", (Object)Locale.getDefault());
    private final SimpleBooleanProperty allowDraggingObjectProperty = new SimpleBooleanProperty((Object)this, "allowDragging", true);
    private final SimpleBooleanProperty allowResizeObjectProperty = new SimpleBooleanProperty((Object)this, "allowResize", true);
    private final ObjectProperty<LocalDateTime> displayedLocalDateTimeObjectProperty = new SimpleObjectProperty((Object)this, "displayedLocalDateTime", (Object)LocalDateTime.now());
    private final ObservableList<Appointment> selectedAppointments = FXCollections.observableArrayList();
    private final ObjectProperty<Rectangle> emptyFieldRectangleObjectProperty = new SimpleObjectProperty((Object)this, "emptyFieldRectangle", null);
    private final ObjectProperty<Integer> currentAreaObjectProperty = new SimpleObjectProperty((Object)this, "currentArea", (Object)0);
    private final ObjectProperty<LocalDateTime> currentSelectionDateTimeObjectProperty = new SimpleObjectProperty((Object)this, "currentSelectionDateTime", null);
    private final ObjectProperty<Callback<LocalDateTimeRange, Void>> localDateTimeRangeCallbackObjectProperty = new SimpleObjectProperty((Object)this, "localDateTimeRangeCallback", null);
    private final ObjectProperty<Callback<LocalDateTimeRange, Appointment>> newAppointmentCallbackObjectProperty = new SimpleObjectProperty((Object)this, "newAppointmentCallback", null);
    private final ObjectProperty<Callback<Appointment, Void>> editAppointmentCallbackObjectProperty = new SimpleObjectProperty((Object)this, "editAppointmentCallback", null);
    private final ObjectProperty<Callback<LocalDateTimeRange, TimetableBean>> newItemCallbackObjectProperty = new SimpleObjectProperty((Object)this, "newItemCallback", null);
    private final ObjectProperty<Callback<LocalDateTimeRange, TimetableBean>> newPasteItemCallbackObjectProperty = new SimpleObjectProperty((Object)this, "newPasteItemCallback", null);
    private final ObjectProperty<Callback<Appointment, Void>> actionCallbackObjectProperty = new SimpleObjectProperty((Object)this, "actionCallback", null);

    public Agenda() {
        this.construct();
    }

    private void construct() {
        this.getStyleClass().add((Object)Agenda.class.getSimpleName());
        this.constructAppointmentGroups();
        this.constructAppointments();
    }

    public String getUserAgentStylesheet() {
        return Agenda.class.getResource("/org/sportdata/set/extension/dtm/jfxtras/internal/scene/control/skin/agenda/" + Agenda.class.getSimpleName() + ".css").toExternalForm();
    }

    public Skin<?> createDefaultSkin() {
        return new AgendaEventSkin(this);
    }

    public Agenda withId(String value) {
        this.setId(value);
        return this;
    }

    public ObservableList<Appointment> appointments() {
        return this.appointments;
    }

    private void constructAppointments() {
        this.appointments.addListener((ListChangeListener)new ListChangeListener<Appointment>(){

            public void onChanged(ListChangeListener.Change<? extends Appointment> changes) {
                while (changes.next()) {
                    for (Appointment lAppointment : changes.getRemoved()) {
                        Agenda.this.selectedAppointments.remove((Object)lAppointment);
                    }
                }
            }
        });
    }

    public ObservableList<AppointmentGroup> appointmentGroups() {
        return this.appointmentGroups;
    }

    private void constructAppointmentGroups() {
        TreeMap<CallSite, AppointmentGroupImpl> lAppointmentGroupMap = new TreeMap<CallSite, AppointmentGroupImpl>();
        int i2 = 0;
        while (i2 < 24) {
            lAppointmentGroupMap.put((CallSite)((Object)("group" + (i2 < 10 ? "0" : "") + i2)), new AppointmentGroupImpl().withStyleClass("group" + i2));
            ++i2;
        }
        for (String lId : lAppointmentGroupMap.keySet()) {
            AppointmentGroup lAppointmentGroup = (AppointmentGroup)lAppointmentGroupMap.get(lId);
            lAppointmentGroup.setDescription(lId);
            this.appointmentGroups().add((Object)lAppointmentGroup);
        }
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.localeObjectProperty;
    }

    public Locale getLocale() {
        return (Locale)this.localeObjectProperty.getValue();
    }

    public void setLocale(Locale value) {
        this.localeObjectProperty.setValue((Object)value);
    }

    public Agenda withLocale(Locale value) {
        this.setLocale(value);
        return this;
    }

    public SimpleBooleanProperty allowDraggingProperty() {
        return this.allowDraggingObjectProperty;
    }

    public boolean getAllowDragging() {
        return this.allowDraggingObjectProperty.getValue();
    }

    public void setAllowDragging(boolean value) {
        this.allowDraggingObjectProperty.setValue(Boolean.valueOf(value));
    }

    public Agenda withAllowDragging(boolean value) {
        this.setAllowDragging(value);
        return this;
    }

    public SimpleBooleanProperty allowResizeProperty() {
        return this.allowResizeObjectProperty;
    }

    public boolean getAllowResize() {
        return this.allowResizeObjectProperty.getValue();
    }

    public void setAllowResize(boolean value) {
        this.allowResizeObjectProperty.setValue(Boolean.valueOf(value));
    }

    public Agenda withAllowResize(boolean value) {
        this.setAllowResize(value);
        return this;
    }

    public ObjectProperty<LocalDateTime> displayedLocalDateTime() {
        return this.displayedLocalDateTimeObjectProperty;
    }

    public LocalDateTime getDisplayedLocalDateTime() {
        return (LocalDateTime)this.displayedLocalDateTimeObjectProperty.getValue();
    }

    public void setDisplayedLocalDateTime(LocalDateTime value) {
        this.displayedLocalDateTimeObjectProperty.setValue((Object)value);
    }

    public Agenda withDisplayedLocalDateTime(LocalDateTime value) {
        this.setDisplayedLocalDateTime(value);
        return this;
    }

    public ObservableList<Appointment> selectedAppointments() {
        return this.selectedAppointments;
    }

    public ObjectProperty<Rectangle> emptyFieldRectangle() {
        return this.emptyFieldRectangleObjectProperty;
    }

    public Rectangle getEmptyFieldRectangle() {
        return (Rectangle)this.emptyFieldRectangleObjectProperty.getValue();
    }

    public void setEmptyFieldRectangle(Rectangle value) {
        this.emptyFieldRectangleObjectProperty.setValue((Object)value);
    }

    public ObjectProperty<Integer> currentArea() {
        return this.currentAreaObjectProperty;
    }

    public Integer getCurrentArea() {
        return (Integer)this.currentAreaObjectProperty.getValue();
    }

    public void setCurrentArea(Integer value) {
        this.currentAreaObjectProperty.setValue((Object)value);
        this.controller.currentArea = value;
    }

    public ObjectProperty<LocalDateTime> currentSelectionDateTime() {
        return this.currentSelectionDateTimeObjectProperty;
    }

    public LocalDateTime getCurrentSelectionDateTime() {
        return (LocalDateTime)this.currentSelectionDateTimeObjectProperty.getValue();
    }

    public void setCurrentSelectionDateTime(LocalDateTime value) {
        this.currentSelectionDateTimeObjectProperty.setValue((Object)value);
    }

    public ObjectProperty<Callback<LocalDateTimeRange, Void>> localDateTimeRangeCallbackProperty() {
        return this.localDateTimeRangeCallbackObjectProperty;
    }

    public Callback<LocalDateTimeRange, Void> getLocalDateTimeRangeCallback() {
        return (Callback)this.localDateTimeRangeCallbackObjectProperty.getValue();
    }

    public void setLocalDateTimeRangeCallback(Callback<LocalDateTimeRange, Void> value) {
        this.localDateTimeRangeCallbackObjectProperty.setValue(value);
    }

    public Agenda withLocalDateTimeRangeCallback(Callback<LocalDateTimeRange, Void> value) {
        this.setLocalDateTimeRangeCallback(value);
        return this;
    }

    public ObjectProperty<Callback<LocalDateTimeRange, Appointment>> newAppointmentCallbackProperty() {
        return this.newAppointmentCallbackObjectProperty;
    }

    public Callback<LocalDateTimeRange, Appointment> getNewAppointmentCallback() {
        return (Callback)this.newAppointmentCallbackObjectProperty.getValue();
    }

    public void setNewAppointmentCallback(Callback<LocalDateTimeRange, Appointment> value) {
        this.newAppointmentCallbackObjectProperty.setValue(value);
    }

    public Agenda withNewAppointmentCallback(Callback<LocalDateTimeRange, Appointment> value) {
        this.setNewAppointmentCallback(value);
        return this;
    }

    public ObjectProperty<Callback<Appointment, Void>> editAppointmentCallbackProperty() {
        return this.editAppointmentCallbackObjectProperty;
    }

    public Callback<Appointment, Void> getEditAppointmentCallback() {
        return (Callback)this.editAppointmentCallbackObjectProperty.getValue();
    }

    public void setEditAppointmentCallback(Callback<Appointment, Void> value) {
        this.editAppointmentCallbackObjectProperty.setValue(value);
    }

    public Agenda withEditAppointmentCallback(Callback<Appointment, Void> value) {
        this.setEditAppointmentCallback(value);
        return this;
    }

    public ObjectProperty<Callback<LocalDateTimeRange, TimetableBean>> newItemCallbackProperty() {
        return this.newItemCallbackObjectProperty;
    }

    public Callback<LocalDateTimeRange, TimetableBean> getNewItemCallback() {
        return (Callback)this.newItemCallbackObjectProperty.getValue();
    }

    public void setNewItemCallback(Callback<LocalDateTimeRange, TimetableBean> value) {
        this.newItemCallbackObjectProperty.setValue(value);
    }

    public Agenda withNewItemCallback(Callback<LocalDateTimeRange, TimetableBean> value) {
        this.setNewItemCallback(value);
        return this;
    }

    public ObjectProperty<Callback<LocalDateTimeRange, TimetableBean>> newPasteItemCallbackProperty() {
        return this.newPasteItemCallbackObjectProperty;
    }

    public Callback<LocalDateTimeRange, TimetableBean> getNewPasteItemCallback() {
        return (Callback)this.newPasteItemCallbackObjectProperty.getValue();
    }

    public void setNewPasteItemCallback(Callback<LocalDateTimeRange, TimetableBean> value) {
        this.newPasteItemCallbackObjectProperty.setValue(value);
    }

    public Agenda withNewPasteItemCallback(Callback<LocalDateTimeRange, TimetableBean> value) {
        this.setNewPasteItemCallback(value);
        return this;
    }

    public ObjectProperty<Callback<Appointment, Void>> actionCallbackProperty() {
        return this.actionCallbackObjectProperty;
    }

    public Callback<Appointment, Void> getActionCallback() {
        return (Callback)this.actionCallbackObjectProperty.getValue();
    }

    public void setActionCallback(Callback<Appointment, Void> value) {
        this.actionCallbackObjectProperty.setValue(value);
    }

    public Agenda withActionCallback(Callback<Appointment, Void> value) {
        this.setActionCallback(value);
        return this;
    }

    public void refresh() {
        ((AgendaSkin)this.getSkin()).refresh();
    }

    public static interface Appointment {
        public Boolean isWholeDay();

        public void setWholeDay(Boolean var1);

        public String getSummary();

        public void setSummary(String var1);

        public String getDescription();

        public void setDescription(String var1);

        public String getLocation();

        public void setLocation(String var1);

        public AppointmentGroup getAppointmentGroup();

        public void setAppointmentGroup(AppointmentGroup var1);

        public LocalDateTime getStartLocalDateTime();

        public void setStartLocalDateTime(LocalDateTime var1);

        public LocalDateTime getEndLocalDateTime();

        public void setEndLocalDateTime(LocalDateTime var1);
    }

    public static interface AppointmentGroup {
        public String getDescription();

        public void setDescription(String var1);

        public String getStyleClass();

        public void setStyleClass(String var1);
    }

    public static class AppointmentGroupImpl
    implements AppointmentGroup {
        private final ObjectProperty<String> descriptionObjectProperty = new SimpleObjectProperty((Object)this, "description");
        private final ObjectProperty<String> styleClassObjectProperty = new SimpleObjectProperty((Object)this, "styleClass");

        public ObjectProperty<String> descriptionProperty() {
            return this.descriptionObjectProperty;
        }

        @Override
        public String getDescription() {
            return (String)this.descriptionObjectProperty.getValue();
        }

        @Override
        public void setDescription(String value) {
            this.descriptionObjectProperty.setValue((Object)value);
        }

        public AppointmentGroupImpl withDescription(String value) {
            this.setDescription(value);
            return this;
        }

        public ObjectProperty<String> styleClassProperty() {
            return this.styleClassObjectProperty;
        }

        @Override
        public String getStyleClass() {
            return (String)this.styleClassObjectProperty.getValue();
        }

        @Override
        public void setStyleClass(String value) {
            this.styleClassObjectProperty.setValue((Object)value);
        }

        public AppointmentGroupImpl withStyleClass(String value) {
            this.setStyleClass(value);
            return this;
        }
    }

    public static class LocalDateTimeRange {
        final LocalDateTime start;
        final LocalDateTime end;

        public LocalDateTimeRange(LocalDateTime start, LocalDateTime end) {
            this.start = start;
            this.end = end;
        }

        public LocalDateTime getStartLocalDateTime() {
            return this.start;
        }

        public LocalDateTime getEndLocalDateTime() {
            return this.end;
        }

        public String toString() {
            return super.toString() + " " + String.valueOf(this.start) + " to " + String.valueOf(this.end);
        }
    }
}

