/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.model;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.sportdata.set.extension.dtm.internal.connection.SQLConnection;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;
import org.sportdata.set.extension.dtm.view.DTMDialog;
import org.sportdata.set.extension.dtm.view.DTMView;

public class DTMModel {
    public Connection connection = null;
    public DTMView view;
    ResultSet rs = null;
    String url;
    String user;
    String psw;

    public DTMModel(DTMView view) {
        this.view = view;
    }

    public DTMModel(Connection conn, DTMView view) {
        this.connection = conn;
    }

    public void connect() {
        try {
            this.connection = SQLConnection.getSQLConnection();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void connect(String url, String user, String psw) {
        this.url = url;
        this.user = user;
        this.psw = psw;
        this.connect();
    }

    public ResultSet executeStatement(PreparedStatement statement, String stmtString) {
        Boolean success = false;
        while (!success.booleanValue()) {
            try {
                this.rs = null;
                if (stmtString.toLowerCase().startsWith("select")) {
                    this.rs = statement.executeQuery();
                    this.rs.beforeFirst();
                } else if (stmtString.toLowerCase().startsWith("update") || stmtString.toLowerCase().startsWith("insert") || stmtString.toLowerCase().startsWith("delete")) {
                    statement.executeUpdate();
                }
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.rs;
    }

    public ResultSet executeString(String stmtString) {
        Boolean success = false;
        while (!success.booleanValue()) {
            try {
                this.rs = null;
                Statement st = this.getConnection().createStatement();
                if (stmtString.toLowerCase().startsWith("select")) {
                    this.rs = st.executeQuery(stmtString);
                    this.rs.beforeFirst();
                } else if (stmtString.toLowerCase().startsWith("update") || stmtString.toLowerCase().startsWith("insert") || stmtString.toLowerCase().startsWith("delete")) {
                    st.executeUpdate(stmtString);
                }
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.rs;
    }

    public Boolean executeBatch(String[] batchStmt) {
        if (batchStmt == null) {
            return false;
        }
        Boolean success = false;
        while (!success.booleanValue()) {
            try {
                Statement st = this.getConnection().createStatement();
                String[] stringArray = batchStmt;
                int n2 = batchStmt.length;
                int n3 = 0;
                while (n3 < n2) {
                    String i2 = stringArray[n3];
                    st.addBatch(i2);
                    ++n3;
                }
                st.executeBatch();
                success = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public Connection getSETConnection() {
        Boolean success = false;
        while (!success.booleanValue()) {
            try {
                this.connection = SQLConnection.getSQLConnection();
                if (this.connection == null || this.connection.isClosed()) {
                    throw new Exception();
                }
                success = true;
                return this.connection;
            }
            catch (Exception e2) {
                if (DTMDialog.confirm(this.view.stageRef, DTMResource.getResourceString("general.attention"), DTMResource.getResourceString("general.nodbconn")).booleanValue()) continue;
                success = true;
                this.view.closeDTM();
                return null;
            }
        }
        return this.connection;
    }
}

