/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.view;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.sportdata.set.extension.dtm.beans.DTMUtill;
import org.sportdata.set.extension.dtm.beans.DynamicCategoryBean;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.internal.beans.DTMMaster;
import org.sportdata.set.extension.dtm.util.DTMUtil;

public class DynView {
    private static Logger log;
    private static Timestamp currentTime;

    public static ArrayList<DynamicCategoryBean> getScheduleStatus(DynamicCategoryBean dynBean, Connection conn) {
        log = DTMMaster.getInstance().getLogger();
        currentTime = new Timestamp(System.currentTimeMillis());
        if (dynBean.getLastFinishedCategory() != null) {
            System.out.println("\nLast finsihed DynamicCategoryBean: '" + String.valueOf(dynBean.getLastFinishedCategory()) + "', KNr: " + dynBean.getLastFinishedCategory().getKnr() + ", Pool: " + dynBean.getLastFinishedCategory().getPool() + " von " + dynBean.getLastFinishedCategory().getPoolVon() + ", MatchesLeft: " + dynBean.getLastFinishedCategory().getMatchesLeft() + ", Type: " + dynBean.getLastFinishedCategory().getType() + ", Tatami: " + dynBean.getLastFinishedCategory().getTatami() + ", LastFinishedCat: " + String.valueOf(dynBean.getLastFinishedCategory()));
        }
        if (dynBean != null) {
            if (!dynBean.isEmptyBean()) {
                return DynView.getScheduleStatusFromFilledBean(dynBean, currentTime, conn);
            }
            return DynView.getScheduleStatusFromEmptyBean(dynBean, currentTime, conn);
        }
        return DynView.getCurrentScheduledItems(currentTime, dynBean, conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList getScheduleStatusFromEmptyBean(DynamicCategoryBean dynBean, Timestamp currentTime, Connection conn) {
        TimetableBean ttBean = null;
        TimetableBean matchingTimetableBean = null;
        TimetableBean ttBeanOld = null;
        DynamicCategoryBean returnDynBean = null;
        boolean matchingTimetableBeanFound = false;
        boolean firstBean = true;
        boolean inPause = false;
        boolean justShowSchedule = false;
        boolean customItemRunning = false;
        boolean firstTTBeanIsFinished = false;
        boolean lastFinishedAvailable = false;
        boolean partOfParentIsFinished = false;
        String estimatedStarttime = null;
        String scheduledStarttime = null;
        long delayInMillis = 0L;
        long delayInMinutes = 0L;
        long crossTime = 0L;
        ArrayList<DynamicCategoryBean> list = new ArrayList<DynamicCategoryBean>();
        if (dynBean.getLastFinishedCategory() != null) {
            System.out.println("//model: is lastFinishedCategory available");
            lastFinishedAvailable = true;
            matchingTimetableBean = DynView.getMatchingTimetableBean(dynBean.getLastFinishedCategory(), conn);
            if (matchingTimetableBean != null) {
                System.out.println("//model: Get timetable beans of tatami with starttime  >=  matchingTimetableBean.starttime");
                String statement = "select * from timetable tt where tt.tatami = " + matchingTimetableBean.getTatami() + " and tt.starttime >= '" + String.valueOf(matchingTimetableBean.getStarttime()) + "' and tt.date = '" + String.valueOf(matchingTimetableBean.getDate()) + "' order by tt.starttime;";
                ResultSet rs = DynView.executeStatement(statement, conn);
                try {
                    System.out.println("//model: get  first timetable bean");
                    rs.next();
                    ttBean = DTMUtil.generateTimetableBean(rs);
                    if (DynView.partOfParentIsFinished(dynBean, ttBean)) {
                        System.out.println("//model: lastFinishedBean is part of parent timetable bean (e.g. repechage)");
                        if (DynView.categoryIsFinished(dynBean.getLastFinishedCategory(), ttBean)) {
                            firstBean = true;
                        } else {
                            delayInMillis = DynView.calcDelay4(dynBean.getLastFinishedCategory(), ttBean, currentTime);
                            delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                            scheduledStarttime = "";
                            estimatedStarttime = "";
                            returnDynBean = DynView.generateDynBean(dynBean, ttBean, scheduledStarttime, estimatedStarttime, String.valueOf(delayInMinutes));
                            list.add(returnDynBean);
                            firstBean = false;
                        }
                    } else {
                        System.out.println("//model: mark the next bean to be the first bean again");
                        firstBean = true;
                    }
                    while (rs.next()) {
                        System.out.println("//model: get  next  timetable bean");
                        ttBeanOld = ttBean;
                        ttBean = DTMUtil.generateTimetableBean(rs);
                        if (firstBean) {
                            System.out.println("//model: is  first  timetable bean");
                            if (currentTime.after(ttBean.getStarttime())) {
                                System.out.println("//model: current time is after the  bean's starttime");
                                if (ttBean.getType() == 5) {
                                    System.out.println("//model: bean  is custom item");
                                    if (currentTime.after(ttBean.getEndtime())) {
                                        System.out.println("//model: current time is after the custom item's endtime");
                                        delayInMillis = DynView.calcDelay3(ttBean, currentTime);
                                    } else {
                                        delayInMillis = 0L;
                                    }
                                    delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                                    scheduledStarttime = "";
                                    estimatedStarttime = "";
                                } else {
                                    delayInMillis = DynView.calcDelay2(ttBean, currentTime);
                                    delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                                    scheduledStarttime = ttBean.getStarttime().toString();
                                    estimatedStarttime = DynView.calcEstimatedStarttime(delayInMinutes, ttBean).toString();
                                }
                            } else if (ttBean.getStarttime().after(ttBeanOld.getEndtime())) {
                                System.out.println("//model: pause between previous  timetable bean  and new timetable bean");
                                delayInMillis = 0L;
                                delayInMinutes = 0L;
                                estimatedStarttime = scheduledStarttime = ttBean.getStarttime().toString();
                            } else {
                                delayInMillis = DynView.calcDelay2(ttBean, currentTime);
                                delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                                scheduledStarttime = ttBean.getStarttime().toString();
                                estimatedStarttime = DynView.calcEstimatedStarttime(delayInMinutes, ttBean).toString();
                            }
                            firstBean = false;
                        } else {
                            System.out.println("//model: Standard process for an iteration in a set of  timetable beans");
                            HashMap<String, String> iterationResult = DynView.standardIterationProcess(delayInMinutes, ttBean, ttBeanOld);
                            try {
                                delayInMinutes = Long.parseLong(iterationResult.get("delay"));
                            }
                            catch (Exception e2) {
                                log.severe("Error when parsing a delay String to long.");
                                e2.printStackTrace();
                            }
                            estimatedStarttime = iterationResult.get("estimatedStarttime");
                            scheduledStarttime = ttBean.getStarttime().toString();
                        }
                        returnDynBean = DynView.generateDynBean(dynBean, ttBean, scheduledStarttime, estimatedStarttime, String.valueOf(delayInMinutes));
                        list.add(returnDynBean);
                    }
                    return list;
                }
                catch (Exception e3) {
                    System.out.println("//model: Show scheduled items (actual and following)");
                    e3.printStackTrace();
                    return DynView.getCurrentScheduledItems(currentTime, dynBean, conn);
                }
            }
            System.out.println("//model: Show scheduled items (actual and following)");
            log.info("ERROR: Received LastFinished-Bean '" + String.valueOf(dynBean.getLastFinishedCategory()) + "' not found in schedule!");
            return DynView.getCurrentScheduledItems(currentTime, dynBean, conn);
        }
        System.out.println("//model: Show scheduled items (actual and following)");
        return DynView.getCurrentScheduledItems(currentTime, dynBean, conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList<DynamicCategoryBean> getScheduleStatusFromFilledBean(DynamicCategoryBean dynBean, Timestamp currentTime, Connection conn) {
        ArrayList<DynamicCategoryBean> list = new ArrayList<DynamicCategoryBean>();
        TimetableBean ttBean = null;
        TimetableBean matchingTimetableBean = null;
        TimetableBean ttBeanOld = null;
        DynamicCategoryBean returnDynBean = null;
        boolean matchingTimetableBeanFound = false;
        boolean firstBean = true;
        boolean inPause = false;
        boolean justShowSchedule = false;
        boolean customItemRunning = false;
        boolean firstTTBeanIsFinished = false;
        boolean lastFinishedAvailable = false;
        boolean partOfParentIsFinished = false;
        String estimatedStarttime = null;
        String scheduledStarttime = null;
        long delayInMillis = 0L;
        long delayInMinutes = 0L;
        long crossTime = 0L;
        matchingTimetableBean = DynView.getMatchingTimetableBean(dynBean, conn);
        if (matchingTimetableBean != null) {
            String statement = "select * from timetable tt where tt.tatami = " + matchingTimetableBean.getTatami() + " and tt.starttime >= '" + String.valueOf(matchingTimetableBean.getStarttime()) + "' and tt.date = '" + String.valueOf(matchingTimetableBean.getDate()) + "' order by tt.starttime;";
            ResultSet rs = DynView.executeStatement(statement, conn);
            try {
                list = new ArrayList();
                while (rs.next()) {
                    ttBeanOld = ttBean;
                    ttBean = DTMUtil.generateTimetableBean(rs);
                    System.out.println("Generated TimetableBean: '" + ttBean.getCatname() + "', Starttime: " + String.valueOf(ttBean.getStarttime()) + ", Endtime: " + String.valueOf(ttBean.getEndtime()));
                    if (firstBean) {
                        delayInMillis = DynView.calcDelay1(dynBean, ttBean, currentTime);
                        System.out.println("  delay: " + delayInMillis);
                        delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                        scheduledStarttime = "";
                        estimatedStarttime = "";
                        firstBean = false;
                    } else {
                        System.out.println("//model: Standard process for an iteration in a set of  timetable beans");
                        HashMap<String, String> iterationResult = DynView.standardIterationProcess(delayInMinutes, ttBean, ttBeanOld);
                        try {
                            delayInMinutes = Long.parseLong(iterationResult.get("delay"));
                        }
                        catch (Exception e2) {
                            log.severe("Error when parsing a delay String to long.");
                            e2.printStackTrace();
                        }
                        estimatedStarttime = iterationResult.get("estimatedStarttime");
                        scheduledStarttime = ttBean.getStarttime().toString();
                    }
                    System.out.println("  delayInMinutes: " + delayInMinutes);
                    System.out.println("  scheduledStarttime: " + scheduledStarttime);
                    System.out.println("  estimatedStarttime: " + estimatedStarttime);
                    returnDynBean = DynView.generateDynBean(dynBean, ttBean, scheduledStarttime, estimatedStarttime, String.valueOf(delayInMinutes));
                    System.out.println("Generated DynamicCategoryBean: '" + String.valueOf(returnDynBean) + "' - Scheduled Starttime: " + returnDynBean.getScheduledStarttime() + ", EstimatedStarttime: " + returnDynBean.getEstimatedStarttime() + ", Delay: " + returnDynBean.getDelay() + "\n");
                    list.add(returnDynBean);
                }
                return list;
            }
            catch (Exception e3) {
                System.out.println("//model: Show scheduled items (actual and following)");
                e3.printStackTrace();
                return DynView.getCurrentScheduledItems(currentTime, dynBean, conn);
            }
        }
        System.out.println("//model: Show scheduled items (actual and following)");
        log.info("ERROR: Received bean '" + String.valueOf(dynBean) + "' not found in schedule!");
        return DynView.getCurrentScheduledItems(currentTime, dynBean, conn);
    }

    private static ArrayList getCurrentScheduledItems(Timestamp currentTime, DynamicCategoryBean bean, Connection conn) {
        ArrayList<DynamicCategoryBean> list = new ArrayList<DynamicCategoryBean>();
        TimetableBean ttBean = null;
        TimetableBean ttBeanOld = null;
        DynamicCategoryBean dynBean = null;
        boolean firstBean = true;
        String estimatedStarttime = null;
        String scheduledStarttime = null;
        System.out.println("Show scheduled items (actual and following)");
        String statement = "select * from timetable where tatami = " + bean.getTatami() + " and vernr = " + bean.getVernr() + " and date = '" + String.valueOf(new Date(currentTime.getTime())) + "' and (starttime >= '" + String.valueOf(currentTime) + "' or endtime > '" + String.valueOf(currentTime) + "') order by starttime;";
        ResultSet rs = DynView.executeStatement(statement, conn);
        try {
            while (rs.next()) {
                ttBeanOld = ttBean;
                ttBean = DTMUtil.generateTimetableBean(rs);
                System.out.println("Generated TimetableBean: '" + ttBean.getCatname() + "', Starttime: " + String.valueOf(ttBean.getStarttime()) + ", Endtime: " + String.valueOf(ttBean.getEndtime()));
                System.out.println("//model: is first  timetable bean");
                if (firstBean) {
                    System.out.println("//model: current time is after the bean's starttime");
                    if (currentTime.after(ttBean.getStarttime())) {
                        scheduledStarttime = "";
                        estimatedStarttime = "";
                    } else {
                        estimatedStarttime = scheduledStarttime = ttBean.getStarttime().toString();
                    }
                    firstBean = false;
                } else {
                    System.out.println("//model: Standard process for an iteration in a set of  timetable beans");
                    HashMap<String, String> iterationResult = DynView.standardIterationProcess(0L, ttBean, ttBeanOld);
                    estimatedStarttime = iterationResult.get("estimatedStarttime");
                    scheduledStarttime = ttBean.getStarttime().toString();
                }
                System.out.println("  scheduledStarttime: " + scheduledStarttime);
                System.out.println("  estimatedStarttime: " + estimatedStarttime);
                dynBean = DynView.generateDynBean(bean, ttBean, scheduledStarttime, estimatedStarttime, "0");
                System.out.println("Generated DynamicCategoryBean: '" + String.valueOf(dynBean) + "' - Scheduled Starttime: " + dynBean.getScheduledStarttime() + ", EstimatedStarttime: " + dynBean.getEstimatedStarttime() + ", Delay: " + dynBean.getDelay() + "\n");
                list.add(dynBean);
            }
        }
        catch (Exception e2) {
            log.severe("An error occured when trying to get the current event schedule!");
            e2.printStackTrace();
        }
        return list;
    }

    private static boolean categoryIsFinished(DynamicCategoryBean dynBean, TimetableBean ttBean) {
        if (dynBean == null) {
            return false;
        }
        if (DTMUtill.matchesTimetableBean(dynBean, ttBean)) {
            if (dynBean.getType() == 4 || ttBean.getType() != 0) {
                return true;
            }
            if ((ttBean.getEntries() == 3 || dynBean.getType() == 6) && dynBean.getMatchesLeft() == 0) {
                return true;
            }
        }
        return false;
    }

    private static HashMap<String, String> standardIterationProcess(long previousDelayInMinutes, TimetableBean ttBean, TimetableBean ttBeanOld) {
        HashMap<String, String> map = new HashMap<String, String>();
        long crossTime = 0L;
        long delayInMinutes = 0L;
        Timestamp estimatedStarttime = ttBean.getStarttime();
        if (previousDelayInMinutes != 0L) {
            System.out.println("//model: delay recognized in the previous iteration");
            if (ttBean.getStarttime().after(ttBeanOld.getEndtime())) {
                System.out.println("//model: pause between previous timetable bean and new timetable bean");
                crossTime = DynView.calcCrossTime(previousDelayInMinutes, ttBeanOld, ttBean);
                if (crossTime != 0L) {
                    System.out.println("//model: previous timetable bean crosses new timetable bean because of delay");
                    delayInMinutes = crossTime;
                    estimatedStarttime = DynView.calcEstimatedStarttime(delayInMinutes, ttBean);
                } else {
                    delayInMinutes = 0L;
                    estimatedStarttime = ttBean.getStarttime();
                }
            } else {
                delayInMinutes = previousDelayInMinutes;
                estimatedStarttime = DynView.calcEstimatedStarttime(delayInMinutes, ttBean);
            }
        } else {
            delayInMinutes = 0L;
            estimatedStarttime = ttBean.getStarttime();
        }
        map.put("delay", String.valueOf(delayInMinutes));
        map.put("estimatedStarttime", estimatedStarttime.toString());
        return map;
    }

    private static Timestamp calcEstimatedStarttime(long delayInMinutes, TimetableBean ttBean) {
        if (delayInMinutes != 0L) {
            return new Timestamp(ttBean.getStarttime().getTime() + delayInMinutes * 60000L);
        }
        return ttBean.getStarttime();
    }

    private static long calcDelay1(DynamicCategoryBean dynBean, TimetableBean ttBean, Timestamp currentTime) {
        long scheduledTimeLeft = 0L;
        long actualTimeLeft = 0L;
        long delay = 0L;
        int doneFights = 0;
        scheduledTimeLeft = DTMUtill.timestampDiff(ttBean.getEndtime(), currentTime);
        if (ttBean.getType() == 0) {
            int entriesPerPool = ttBean.getEntries() / ttBean.getPools();
            int fightsPerPool = DTMUtill.calcNrOfFights(entriesPerPool, 1);
            int poolwinnerFights = DTMUtill.calcPoolwinnerRounds(ttBean.getPools());
            int repFights = DTMUtill.calculateRepechageFights(ttBean.getEntries());
            int totalFights = DTMUtill.calcTotalNrOfFights(ttBean.getEntries(), 0);
            System.out.println("total fights: " + totalFights);
            switch (dynBean.getType()) {
                case 1: {
                    doneFights = (dynBean.getPool() - 1) * fightsPerPool + (fightsPerPool - dynBean.getMatchesLeft());
                    break;
                }
                case 2: {
                    doneFights = ttBean.getPools() * fightsPerPool + (poolwinnerFights - dynBean.getMatchesLeft());
                    break;
                }
                case 3: {
                    if (dynBean.getRepechageOnOneList() == 1) {
                        doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + (repFights - dynBean.getMatchesLeft());
                        break;
                    }
                    if (dynBean.getPool() == 1) {
                        doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + (repFights / 2 - dynBean.getMatchesLeft());
                        break;
                    }
                    if (dynBean.getPool() != 2) break;
                    doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + repFights / 2 + (repFights / 2 - dynBean.getMatchesLeft());
                    if (repFights % 2 == 0) break;
                    ++doneFights;
                    break;
                }
                case 4: {
                    doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + repFights;
                    break;
                }
                case 6: {
                    break;
                }
            }
            int totalFightsLeft = totalFights - doneFights;
            actualTimeLeft = totalFightsLeft * ttBean.getFighttime() * 1000;
            System.out.println("actualTimeLeft: " + actualTimeLeft);
        } else {
            actualTimeLeft = dynBean.getMatchesLeft() * ttBean.getFighttime() * 1000;
        }
        System.out.println("delay = " + actualTimeLeft + " - " + scheduledTimeLeft);
        delay = actualTimeLeft - scheduledTimeLeft;
        return delay;
    }

    private static long calcDelay2(TimetableBean ttBean, Timestamp currentTime) {
        return DTMUtill.timestampDiff(currentTime, ttBean.getStarttime());
    }

    private static long calcDelay3(TimetableBean ttBean, Timestamp currentTime) {
        return DTMUtill.timestampDiff(currentTime, ttBean.getEndtime());
    }

    private static long calcDelay4(DynamicCategoryBean dynBean, TimetableBean ttBean, Timestamp currentTime) {
        long scheduledTimeLeft = 0L;
        long actualTimeLeft = 0L;
        long delay = 0L;
        int doneFights = 0;
        scheduledTimeLeft = DTMUtill.timestampDiff(ttBean.getEndtime(), currentTime);
        int entriesPerPool = ttBean.getEntries() / ttBean.getPools();
        int fightsPerPool = DTMUtill.calcNrOfFights(entriesPerPool, 1);
        int poolwinnerFights = DTMUtill.calcPoolwinnerRounds(ttBean.getPools());
        int repFights = DTMUtill.calculateRepechageFights(ttBean.getEntries());
        int totalFights = DTMUtill.calcTotalNrOfFights(ttBean.getEntries(), 0);
        System.out.println("total fights: " + totalFights);
        switch (dynBean.getType()) {
            case 1: {
                doneFights = (dynBean.getPool() - 1) * fightsPerPool + (fightsPerPool - dynBean.getMatchesLeft());
                break;
            }
            case 2: {
                doneFights = ttBean.getPools() * fightsPerPool + (poolwinnerFights - dynBean.getMatchesLeft());
                break;
            }
            case 3: {
                if (dynBean.getRepechageOnOneList() == 1) {
                    doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + (repFights - dynBean.getMatchesLeft());
                    break;
                }
                if (dynBean.getPool() == 1) {
                    doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + (repFights / 2 - dynBean.getMatchesLeft());
                    break;
                }
                if (dynBean.getPool() != 2) break;
                doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + repFights / 2 + (repFights / 2 - dynBean.getMatchesLeft());
                if (repFights % 2 == 0) break;
                ++doneFights;
                break;
            }
            case 4: {
                doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + repFights;
                break;
            }
            case 6: {
                break;
            }
        }
        int totalFightsLeft = totalFights - doneFights;
        actualTimeLeft = totalFightsLeft * ttBean.getFighttime() * 1000;
        System.out.println("actualTimeLeft: " + actualTimeLeft);
        System.out.println("delay = " + actualTimeLeft + " - " + scheduledTimeLeft);
        delay = actualTimeLeft - scheduledTimeLeft;
        return delay;
    }

    private static long calcDelay(DynamicCategoryBean dynBean, TimetableBean ttBean, Timestamp currentTime, boolean partOfParent) {
        long scheduledTimeLeft = 0L;
        long actualTimeLeft = 0L;
        long delay = 0L;
        int doneFights = 0;
        if (ttBean.getType() == 5) {
            return 0L;
        }
        scheduledTimeLeft = DTMUtill.timestampDiff(ttBean.getEndtime(), currentTime);
        if (ttBean.getType() == 0 && !dynBean.isEmptyBean()) {
            int entriesPerPool = ttBean.getEntries() / ttBean.getPools();
            int fightsPerPool = DTMUtill.calcNrOfFights(entriesPerPool, 1);
            int poolwinnerFights = DTMUtill.calcPoolwinnerRounds(ttBean.getPools());
            int repFights = DTMUtill.calculateRepechageFights(ttBean.getEntries());
            int totalFights = DTMUtill.calcTotalNrOfFights(ttBean.getEntries(), 0);
            System.out.println("total fights: " + totalFights);
            switch (dynBean.getType()) {
                case 1: {
                    doneFights = (dynBean.getPool() - 1) * fightsPerPool + (fightsPerPool - dynBean.getMatchesLeft());
                    break;
                }
                case 2: {
                    doneFights = ttBean.getPools() * fightsPerPool + (poolwinnerFights - dynBean.getMatchesLeft());
                    break;
                }
                case 3: {
                    if (dynBean.getRepechageOnOneList() == 1) {
                        doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + (repFights - dynBean.getMatchesLeft());
                        break;
                    }
                    if (dynBean.getPool() == 1) {
                        doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + (repFights / 2 - dynBean.getMatchesLeft());
                        break;
                    }
                    if (dynBean.getPool() != 2) break;
                    doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + repFights / 2 + (repFights / 2 - dynBean.getMatchesLeft());
                    if (repFights % 2 == 0) break;
                    ++doneFights;
                    break;
                }
                case 4: {
                    doneFights = ttBean.getPools() * fightsPerPool + poolwinnerFights + repFights;
                    break;
                }
                case 6: {
                    break;
                }
            }
            int totalFightsLeft = totalFights - doneFights;
            actualTimeLeft = totalFightsLeft * ttBean.getFighttime() * 1000;
            System.out.println("actualTimeLeft: " + actualTimeLeft);
        } else {
            if (dynBean.isEmptyBean()) {
                return DTMUtill.timestampDiff(currentTime, ttBean.getStarttime());
            }
            actualTimeLeft = dynBean.getMatchesLeft() * ttBean.getFighttime() * 1000;
        }
        System.out.println("delay = " + actualTimeLeft + " - " + scheduledTimeLeft);
        delay = actualTimeLeft - scheduledTimeLeft;
        return delay;
    }

    private static long calcCrossTime(long delayInMinutes, TimetableBean ttBeanOld, TimetableBean ttBean) {
        if (delayInMinutes == 0L) {
            return 0L;
        }
        Timestamp delayedEndtime = new Timestamp(ttBeanOld.getEndtime().getTime() + delayInMinutes * 60000L);
        if (delayedEndtime.after(ttBean.getStarttime())) {
            return DTMUtill.msToMin(DTMUtill.timestampDiff(delayedEndtime, ttBean.getStarttime()), false);
        }
        return 0L;
    }

    private static DynamicCategoryBean generateDynBean(DynamicCategoryBean dynBean, TimetableBean ttBean, String scheduledStarttime, String estimatedStarttime, String delay) {
        return new DynamicCategoryBean(ttBean.getVernr(), ttBean.getKnr(), ttBean.getTatami(), ttBean.toString(), ttBean.getPool(), ttBean.getPools(), dynBean.getRepechageOnOneList(), ttBean.getType(), dynBean.getMatchesLeft(), dynBean.getTotalMatches(), dynBean.getLastFinishedCategory(), scheduledStarttime, estimatedStarttime, delay, dynBean.isEmptyBean(), dynBean.getMatchid(), dynBean.getClientmessage());
    }

    private static TimetableBean getMatchingTimetableBean(DynamicCategoryBean dynBean, Connection conn) {
        TimetableBean ttBean = null;
        String statement = "select * from timetable where vernr = " + dynBean.getVernr() + " and tatami = " + dynBean.getTatami() + " and knr = " + dynBean.getKnr();
        ResultSet rs = DynView.executeStatement(statement, conn);
        try {
            while (rs.next()) {
                ttBean = DTMUtil.generateTimetableBean(rs);
                if (!DynView.dynBeanMatchesTimetableBean(dynBean, ttBean)) continue;
                System.out.println("Matching TimetableBean found: '" + ttBean.getCatname() + "', Starttime: " + String.valueOf(ttBean.getStarttime()) + ", Endtime: " + String.valueOf(ttBean.getEndtime()) + ", Pool: " + ttBean.getPool() + " von " + ttBean.getPools() + ", Type: " + ttBean.getType());
                return ttBean;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return null;
    }

    private static boolean partOfParentIsFinished(DynamicCategoryBean dynBean, TimetableBean ttBean) {
        if (ttBean.getType() != 0 || dynBean.getLastFinishedCategory() == null) {
            return false;
        }
        return ttBean.getKnr() == dynBean.getLastFinishedCategory().getKnr();
    }

    public static boolean dynBeanMatchesTimetableBean(DynamicCategoryBean dynBean, TimetableBean ttBean) {
        boolean ret = false;
        int dynBeanType = dynBean.getType();
        if (dynBean.getKnr() != ttBean.getKnr()) {
            return false;
        }
        if (ttBean.getType() == 0) {
            return true;
        }
        switch (dynBeanType) {
            case 1: {
                if (ttBean.getType() != 1) {
                    ret = false;
                    break;
                }
                if (ttBean.getPool() == dynBean.getPool()) {
                    ret = true;
                    break;
                }
                ret = false;
                break;
            }
            case 2: {
                if (ttBean.getType() != 2) {
                    ret = false;
                    break;
                }
                ret = true;
                break;
            }
            case 3: {
                if (ttBean.getType() != 3) {
                    ret = false;
                    break;
                }
                if (ttBean.getPool() == dynBean.getPool() || dynBean.getRepechageOnOneList() == 1) {
                    ret = true;
                    break;
                }
                ret = false;
                break;
            }
            case 4: {
                if (ttBean.getType() != 4) {
                    ret = false;
                    break;
                }
                ret = true;
                break;
            }
            case 6: {
                ret = ttBean.getType() != 6 ? false : ttBean.getPool() == dynBean.getPool();
            }
        }
        return ret;
    }

    private static ResultSet executeStatement(String stmt, Connection conn) {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(stmt);
            rs.beforeFirst();
            return rs;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

