/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.view;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Application;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import jfxtras.scene.layout.HBox;
import org.sportdata.set.extension.dtm.beans.CategoryTreeBean;
import org.sportdata.set.extension.dtm.beans.Event;
import org.sportdata.set.extension.dtm.controller.DTMLoadSettingsController;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;
import org.sportdata.set.extension.dtm.view.DTMDialog;
import org.sportdata.set.extension.dtm.view.DTMSettings;
import org.sportdata.set.utils.j;

public class LoadSettingsEventSelection
extends Application {
    private DTMSettings dtmSettingsView;
    private ArrayList events;
    private Stage stageRef;
    private Stage stageLoadSettingsRef;
    private DTMLoadSettingsController loadSettingsController;
    private ArrayList<CategoryTreeBean> categories;

    public LoadSettingsEventSelection(ArrayList events, DTMSettings view, ArrayList<CategoryTreeBean> categories) {
        this.events = events;
        this.dtmSettingsView = view;
        this.categories = categories;
    }

    public void start(final Stage primaryStage) {
        ObservableList data = FXCollections.observableArrayList((Collection)this.events);
        FilteredList filteredData = new FilteredList(data, s2 -> true);
        TextField filterInput = new TextField();
        filterInput.getStyleClass().add((Object)"SearchTextField");
        filterInput.setPromptText(DTMResource.getResourceString("settings.dialog.selectevent.filterprompt"));
        filterInput.textProperty().addListener(obs -> {
            String filter = filterInput.getText();
            if (filter == null || filter.length() == 0) {
                filteredData.setPredicate(s2 -> true);
            } else {
                filteredData.setPredicate(s2 -> s2.getBezeichnung().toLowerCase().contains(filter.toLowerCase()));
            }
        });
        final ListView listView = new ListView((ObservableList)filteredData);
        listView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent click) {
                if (click.getClickCount() == 2) {
                    if ((Event)listView.getSelectionModel().getSelectedItem() == null) {
                        DTMDialog.inform(primaryStage, DTMResource.getResourceString("settings.dialog.selectevent.noselect"));
                    } else {
                        LoadSettingsEventSelection.this.openLoadSettingsStage((Event)listView.getSelectionModel().getSelectedItem());
                    }
                }
            }
        });
        HBox hBox = new HBox();
        hBox.setPrefHeight(50.0);
        hBox.setAlignment(Pos.CENTER);
        BorderPane.setAlignment((Node)hBox, (Pos)Pos.CENTER);
        Button btnLoad = new Button(DTMResource.getResourceString("general.ok"));
        btnLoad.onActionProperty().set(event -> {
            if ((Event)listView.getSelectionModel().getSelectedItem() == null) {
                DTMDialog.inform(primaryStage, DTMResource.getResourceString("settings.dialog.selectevent.noselect"));
            } else {
                this.openLoadSettingsStage((Event)listView.getSelectionModel().getSelectedItem());
            }
        });
        hBox.add((Node)btnLoad);
        BorderPane content = new BorderPane((Node)listView);
        content.setTop((Node)filterInput);
        content.setBottom((Node)hBox);
        BorderPane.setAlignment((Node)btnLoad, (Pos)Pos.CENTER);
        Scene scene = new Scene((Parent)content, 500.0, 500.0);
        if (j.f()) {
            scene.getStylesheets().clear();
            scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/org/sportdata/set/extension/dtm/view/dtmCobalt.css").toExternalForm());
        } else if (j.e()) {
            scene.getStylesheets().clear();
            scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/org/sportdata/set/extension/dtm/view/dtm.css").toExternalForm());
        }
        scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/org/sportdata/set/extension/dtm/jfxtras/internal/scene/control/skin/agenda/Agenda.css").toExternalForm());
        this.stageRef = new Stage();
        this.stageRef.setTitle(DTMResource.getResourceString("settings.dialog.load.title"));
        this.stageRef.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/org/sportdata/set/extension/dtm/view/images/setlogo.png")));
        this.stageRef.setScene(scene);
        this.stageRef.initOwner(null);
        this.stageRef.initModality(Modality.APPLICATION_MODAL);
        this.stageRef.show();
    }

    private void openLoadSettingsStage(Event event) {
        this.stageLoadSettingsRef = new Stage();
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("dtm2_loadSettings.fxml"));
        Pane myPane = null;
        try {
            myPane = (Pane)loader.load();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        this.loadSettingsController = (DTMLoadSettingsController)loader.getController();
        this.loadSettingsController.view = this.dtmSettingsView;
        this.loadSettingsController.setSourceEvent(this.dtmSettingsView.controller.getEvent());
        this.loadSettingsController.setEvent(event);
        this.loadSettingsController.setSourceController(this.dtmSettingsView.controller);
        this.loadSettingsController.setup();
        this.loadSettingsController.setupCatTreeView(this.categories);
        Scene myScene = new Scene((Parent)myPane);
        if (j.f()) {
            myScene.getStylesheets().clear();
            myScene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/org/sportdata/set/extension/dtm/view/dtmCobalt.css").toExternalForm());
        } else if (j.e()) {
            myScene.getStylesheets().clear();
            myScene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/org/sportdata/set/extension/dtm/view/dtm.css").toExternalForm());
        }
        myScene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/org/sportdata/set/extension/dtm/jfxtras/internal/scene/control/skin/agenda/Agenda.css").toExternalForm());
        this.stageLoadSettingsRef.setScene(myScene);
        this.stageLoadSettingsRef.setTitle(DTMResource.getResourceString("settings.dialog.load.title"));
        this.stageLoadSettingsRef.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("/org/sportdata/set/extension/dtm/view/images/setlogo.png")));
        this.stageLoadSettingsRef.initModality(Modality.APPLICATION_MODAL);
        this.stageLoadSettingsRef.initOwner(null);
        this.loadSettingsController.stageRef = this.stageLoadSettingsRef;
        this.stageLoadSettingsRef.setOnCloseRequest(eventt -> {
            System.out.println("Load Settings stage is closing");
            this.stageRef.close();
        });
        this.stageLoadSettingsRef.show();
    }
}

