/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.server.servlet.c;

import com.sun.management.OperatingSystemMXBean;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class A
extends HttpServlet {
    public static final String a = "systemmonitor";
    public static final String b = "1000";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameterMap().keySet().size() > 0) {
            this.a(resp);
        } else {
            this.b(resp);
        }
    }

    private void a(HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json; charset=UTF-8");
        PrintWriter out = resp.getWriter();
        OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        double cpuLoad = osBean.getCpuLoad() * 100.0;
        if (cpuLoad < 0.0) {
            cpuLoad = 0.0;
        }
        long totalMemory = osBean.getTotalMemorySize();
        long freeMemory = osBean.getFreeMemorySize();
        long usedMemory = totalMemory - freeMemory;
        double ramPercent = (double)usedMemory * 100.0 / (double)totalMemory;
        out.println("{");
        out.println("  \"cpu\": " + String.format("%.1f", cpuLoad).replace(",", ".") + ",");
        out.println("  \"ramTotal\": " + totalMemory + ",");
        out.println("  \"ramUsed\": " + usedMemory + ",");
        out.println("  \"ramFree\": " + freeMemory + ",");
        out.println("  \"ramUsedPercent\": " + String.format("%.1f", ramPercent).replace(",", "."));
        out.println("}");
    }

    private void b(HttpServletResponse resp) throws IOException {
        resp.setContentType("text/html; charset=UTF-8");
        PrintWriter out = resp.getWriter();
        out.println("<!DOCTYPE html><html><head><meta charset='UTF-8'>");
        out.println("<meta name='viewport' content='width=device-width, initial-scale=1.0'>");
        out.println("<title>System Monitor</title>");
        out.println("<style>");
        out.println("body{font-family:monospace;background:#1a1a1a;color:#ddd;padding:40px;margin:0}");
        out.println("h1{font-size:18px;font-weight:normal;margin:0 0 30px 0;color:#fff}");
        out.println(".container{display:grid;grid-template-columns:1fr 1fr;gap:20px;margin-bottom:20px}");
        out.println(".metric{background:#222;border:1px solid #333;padding:20px;border-radius:4px}");
        out.println(".metric-label{font-size:12px;color:#888;margin-bottom:10px;text-transform:uppercase}");
        out.println(".metric-value{font-size:32px;color:#fff;margin-bottom:10px}");
        out.println(".bar{width:100%;height:20px;background:#2a2a2a;border:1px solid #333;position:relative;overflow:hidden}");
        out.println(".bar-fill{height:100%;transition:width 0.3s ease}");
        out.println(".bar-fill.cpu{background:#58a6ff}");
        out.println(".bar-fill.ram{background:#5fb572}");
        out.println(".bar-text{position:absolute;left:50%;top:50%;transform:translate(-50%,-50%);font-size:11px;color:#fff;font-weight:bold}");
        out.println(".details{font-size:11px;color:#888;margin-top:8px}");
        out.println(".chart{background:#222;border:1px solid #333;padding:20px;border-radius:4px}");
        out.println(".chart-container{position:relative;width:100%;height:400px}");
        out.println("canvas{width:100%;height:100%;display:block}");
        out.println("</style></head><body>");
        out.println("<h1>System Monitor</h1>");
        out.println("<div class='container'>");
        out.println("<div class='metric'>");
        out.println("<div class='metric-label'>CPU Usage</div>");
        out.println("<div class='metric-value' id='cpu-value'>--</div>");
        out.println("<div class='bar'><div class='bar-fill cpu' id='cpu-bar' style='width:0%'></div><div class='bar-text' id='cpu-text'>0%</div></div>");
        out.println("</div>");
        out.println("<div class='metric'>");
        out.println("<div class='metric-label'>RAM Usage</div>");
        out.println("<div class='metric-value' id='ram-value'>--</div>");
        out.println("<div class='bar'><div class='bar-fill ram' id='ram-bar' style='width:0%'></div><div class='bar-text' id='ram-text'>0%</div></div>");
        out.println("<div class='details' id='ram-details'>Used: -- / Total: --</div>");
        out.println("</div>");
        out.println("</div>");
        out.println("<div class='chart'>");
        out.println("<div class='chart-container'><canvas id='chart'></canvas></div>");
        out.println("</div>");
        out.println("<img src=\"images/sd_contour_transp_320_33.png\" border=\"0\" style=\"display:block;margin:15px auto\" >");
        out.println("<script>");
        out.println("const canvas=document.getElementById('chart');");
        out.println("const ctx=canvas.getContext('2d');");
        out.println("const dpr=window.devicePixelRatio||1;");
        out.println("const rect=canvas.getBoundingClientRect();");
        out.println("canvas.width=rect.width*dpr;");
        out.println("canvas.height=rect.height*dpr;");
        out.println("ctx.scale(dpr,dpr);");
        out.println("const maxPoints=120;");
        out.println("const cpuData=[];");
        out.println("const ramData=[];");
        out.println("function drawChart(){");
        out.println("  const w=rect.width;");
        out.println("  const h=rect.height;");
        out.println("  const padding=50;");
        out.println("  const chartW=w-padding*2;");
        out.println("  const chartH=h-padding*2;");
        out.println("  ctx.clearRect(0,0,w,h);");
        out.println("  ctx.strokeStyle='#333';");
        out.println("  ctx.lineWidth=1;");
        out.println("  for(let i=0;i<=10;i++){");
        out.println("    const y=padding+chartH/10*i;");
        out.println("    ctx.beginPath();");
        out.println("    ctx.moveTo(padding,y);");
        out.println("    ctx.lineTo(w-padding,y);");
        out.println("    ctx.stroke();");
        out.println("    if(i%2===0){");
        out.println("      ctx.fillStyle='#666';");
        out.println("      ctx.font='11px monospace';");
        out.println("      ctx.textAlign='right';");
        out.println("      ctx.fillText((100-i*10)+'%',padding-10,y+4);");
        out.println("    }");
        out.println("  }");
        out.println("  for(let i=0;i<=6;i++){");
        out.println("    const x=padding+chartW/6*i;");
        out.println("    ctx.strokeStyle='#2a2a2a';");
        out.println("    ctx.beginPath();");
        out.println("    ctx.moveTo(x,padding);");
        out.println("    ctx.lineTo(x,h-padding);");
        out.println("    ctx.stroke();");
        out.println("  }");
        out.println("  if(cpuData.length>1){");
        out.println("    ctx.strokeStyle='#58a6ff';");
        out.println("    ctx.lineWidth=2.5;");
        out.println("    ctx.lineCap='round';");
        out.println("    ctx.lineJoin='round';");
        out.println("    ctx.beginPath();");
        out.println("    cpuData.forEach((v,i)=>{");
        out.println("      const x=padding+chartW/(maxPoints-1)*i;");
        out.println("      const y=padding+chartH-(v/100)*chartH;");
        out.println("      if(i===0)ctx.moveTo(x,y);else ctx.lineTo(x,y);");
        out.println("    });");
        out.println("    ctx.stroke();");
        out.println("  }");
        out.println("  if(ramData.length>1){");
        out.println("    ctx.strokeStyle='#5fb572';");
        out.println("    ctx.lineWidth=2.5;");
        out.println("    ctx.lineCap='round';");
        out.println("    ctx.lineJoin='round';");
        out.println("    ctx.beginPath();");
        out.println("    ramData.forEach((v,i)=>{");
        out.println("      const x=padding+chartW/(maxPoints-1)*i;");
        out.println("      const y=padding+chartH-(v/100)*chartH;");
        out.println("      if(i===0)ctx.moveTo(x,y);else ctx.lineTo(x,y);");
        out.println("    });");
        out.println("    ctx.stroke();");
        out.println("  }");
        out.println("  ctx.fillStyle='#58a6ff';");
        out.println("  ctx.fillRect(w-130,15,20,3);");
        out.println("  ctx.fillStyle='#ddd';");
        out.println("  ctx.font='13px monospace';");
        out.println("  ctx.textAlign='left';");
        out.println("  ctx.fillText('CPU',w-105,20);");
        out.println("  ctx.fillStyle='#5fb572';");
        out.println("  ctx.fillRect(w-130,35,20,3);");
        out.println("  ctx.fillStyle='#ddd';");
        out.println("  ctx.fillText('RAM',w-105,40);");
        out.println("}");
        out.println("function formatBytes(bytes){");
        out.println("  if(bytes<1024)return bytes+' B';");
        out.println("  const k=1024;const sizes=['B','KB','MB','GB','TB'];");
        out.println("  const i=Math.floor(Math.log(bytes)/Math.log(k));");
        out.println("  return (bytes/Math.pow(k,i)).toFixed(1)+' '+sizes[i];");
        out.println("}");
        out.println("function update(){");
        out.println("  fetch('?action=data').then(r=>r.json()).then(data=>{");
        out.println("    document.getElementById('cpu-value').textContent=data.cpu.toFixed(1)+'%';");
        out.println("    document.getElementById('cpu-bar').style.width=data.cpu+'%';");
        out.println("    document.getElementById('cpu-text').textContent=data.cpu.toFixed(1)+'%';");
        out.println("    document.getElementById('ram-value').textContent=data.ramUsedPercent.toFixed(1)+'%';");
        out.println("    document.getElementById('ram-bar').style.width=data.ramUsedPercent+'%';");
        out.println("    document.getElementById('ram-text').textContent=data.ramUsedPercent.toFixed(1)+'%';");
        out.println("    document.getElementById('ram-details').textContent='Used: '+formatBytes(data.ramUsed)+' / Total: '+formatBytes(data.ramTotal);");
        out.println("    cpuData.push(data.cpu);");
        out.println("    ramData.push(data.ramUsedPercent);");
        out.println("    if(cpuData.length>maxPoints)cpuData.shift();");
        out.println("    if(ramData.length>maxPoints)ramData.shift();");
        out.println("    drawChart();");
        out.println("  });");
        out.println("}");
        out.println("update();setInterval(update,1000);");
        out.println("</script>");
        out.println("</body></html>");
    }
}

