/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppsanda.anzeige.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.invoke.CallSite;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.sportdata.setppsanda.anzeige.beans.AnzeigeMaster;
import org.sportdata.setppsanda.anzeige.beans.ScoringObject;
import org.sportdata.setppsanda.anzeige.ressource.AnzeigeResource;
import org.sportdata.setppsanda.anzeige.utils.GrafikDeviceUtils;

public class RefereePointsWindow
extends JFrame {
    private static final long serialVersionUID = 3970362580306447158L;
    private JButton b;
    private JButton c;
    private JXTable d;
    private DefaultTableModel e;
    private Vector<String> f;
    private Vector<Vector<Object>> g;
    private JLabel h;
    private Thread i = null;
    boolean a = false;
    private JLabel j;

    public RefereePointsWindow() {
        this.setTitle("Scoring APP Checker");
        Dimension screenSize = GrafikDeviceUtils.getDefaultScreenSize();
        this.setBounds((screenSize.width - 350) / 2, (screenSize.height - 350) / 2, 350, 350);
        Image img = this.getToolkit().getImage("images/setlogo.png");
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(img, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setIconImage(img);
        this.initTable();
        this.a();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                RefereePointsWindow.this.close();
            }
        });
        this.setVisible(true);
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.j = new JLabel();
        this.add((Component)this.j, "North");
        this.add((Component)new JScrollPane((Component)this.d), "Center");
        JPanel psouth = new JPanel();
        this.b = new JButton("Save scores");
        this.b.setIcon(new ImageIcon("images/Chart19.gif"));
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RefereePointsWindow.this.savePoints();
            }
        });
        this.c = new JButton(AnzeigeResource.getResourceString("general.reset2"));
        this.c.setIcon(new ImageIcon("images/changeside.png"));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                RefereePointsWindow.this.reset();
            }
        });
        this.h = new JLabel();
        psouth.add(this.h);
        psouth.add(this.b);
        psouth.add(this.c);
        this.add((Component)psouth, "South");
    }

    public void initTable() {
        if (this.g != null) {
            this.g.clear();
        } else {
            this.g = new Vector();
        }
        this.f = new Vector();
        this.f.add("Referee/Judge");
        this.f.add("Score RED:BLUE");
        this.e = new DefaultTableModel(this.g, this.f){
            Class[] a;
            boolean[] b;
            {
                this.a = new Class[]{String.class, String.class};
                this.b = new boolean[2];
            }

            public Class getColumnClass(int columnIndex) {
                return this.a[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.b[columnIndex];
            }
        };
        this.d = new JXTable((TableModel)this.e);
        this.d.setAutoResizeMode(4);
        this.d.getTableHeader().setReorderingAllowed(false);
        this.d.setSelectionMode(0);
        this.d.setRolloverEnabled(true);
        this.d.addHighlighter((Highlighter)new ColorHighlighter(HighlightPredicate.ROLLOVER_ROW, Color.GRAY, Color.WHITE));
        this.d.setSortable(false);
    }

    public void updateTableData() {
        try {
            new SwingWorker<String, Void>(){

                protected String a() {
                    if (RefereePointsWindow.this.g != null) {
                        RefereePointsWindow.this.g.clear();
                    } else {
                        RefereePointsWindow.this.g = new Vector();
                    }
                    for (int key : AnzeigeMaster.getInstance().getRefereesPoints().keySet()) {
                        Vector<CallSite> subvector = new Vector<CallSite>();
                        subvector.add((CallSite)((Object)("Referee/Judge " + key)));
                        int score1 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue());
                        int score2 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue2());
                        subvector.add((CallSite)((Object)(score1 + ":" + score2)));
                        RefereePointsWindow.this.g.add(subvector);
                    }
                    return "";
                }

                @Override
                protected void done() {
                    RefereePointsWindow.this.d.clearSelection();
                    RefereePointsWindow.this.e.setDataVector(RefereePointsWindow.this.g, RefereePointsWindow.this.f);
                    RefereePointsWindow.this.d.repaint();
                }

                @Override
                protected /* synthetic */ Object doInBackground() throws Exception {
                    return this.a();
                }
            }.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void savePoints() {
        if (AnzeigeMaster.getInstance().getRefereesPoints().size() > 0) {
            for (Integer key : AnzeigeMaster.getInstance().getRefereesPoints().keySet()) {
                ScoringObject obj = AnzeigeMaster.getInstance().getRefereesPoints().get(key);
                boolean needtocheckresults = false;
                if (obj.getScoreName().equals("resultinput_manual")) {
                    needtocheckresults = true;
                }
                int score1 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue());
                int score2 = Math.round(AnzeigeMaster.getInstance().getRefereesPoints().get(key).getScoreValue2());
                String score1str = "" + score1;
                String score2str = "" + score2;
                System.out.println(score1str + " - " + score2str);
                if (!needtocheckresults) {
                    if (obj.getReferee() == 1) {
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(157, score1str);
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(158, score2str);
                    }
                    if (obj.getReferee() == 2) {
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(161, score1str);
                        AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(162, score2str);
                    }
                    if (obj.getReferee() != 3) continue;
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(165, score1str);
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(166, score2str);
                    continue;
                }
                int score1_2 = 0;
                int score2_2 = 0;
                if (score1 > score2) {
                    score1_2 = 10;
                    score2_2 = 9;
                }
                if (score1 < score2) {
                    score1_2 = 9;
                    score2_2 = 10;
                }
                if (score1 == score2) {
                    score1_2 = 10;
                    score2_2 = 10;
                }
                score1str = "" + score1_2;
                score2str = "" + score2_2;
                if (obj.getReferee() == 1) {
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(157, score1str);
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(158, score2str);
                }
                if (obj.getReferee() == 2) {
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(161, score1str);
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(162, score2str);
                }
                if (obj.getReferee() != 3) continue;
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(165, score1str);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(166, score2str);
            }
            this.reset();
        }
    }

    public void reset() {
        AnzeigeMaster.getInstance().getRefereesPoints().clear();
        this.updateTableData();
    }

    public void checkPoints() {
        this.a = false;
        if (this.i == null) {
            this.i = new Thread("SET Point Scoring Checker"){

                @Override
                public void run() {
                    RefereePointsWindow.this.h.setIcon(new ImageIcon("images/ajax_loading.gif"));
                    while (!RefereePointsWindow.this.a) {
                        RefereePointsWindow.this.updateTableData();
                        try {
                            Thread.sleep(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    RefereePointsWindow.this.h.setIcon(null);
                }
            };
            this.i.start();
        }
    }

    public void stopCheckPoints() {
        this.a = true;
    }

    public void close() {
        this.stopCheckPoints();
        AnzeigeMaster.getInstance().setRefereeWindowLocation(this.getLocation());
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setName(String name) {
        this.j.setText(name);
    }
}

