/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.Bounds2D;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.Filterable;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.AccessHelper;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Effect {
    public static final Effect DefaultInput = null;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final PropertyChangeListener inputListener;
    private final List<Effect> inputs;
    private final List<Effect> unmodifiableInputs;
    private final int maxInputs;

    protected Effect() {
        this.inputs = Collections.emptyList();
        this.unmodifiableInputs = this.inputs;
        this.maxInputs = 0;
        this.inputListener = null;
    }

    protected Effect(Effect effect) {
        this.inputs = new ArrayList<Effect>(1);
        this.unmodifiableInputs = Collections.unmodifiableList(this.inputs);
        this.maxInputs = 1;
        this.inputListener = new InputChangeListener();
        this.setInput(0, effect);
    }

    protected Effect(Effect effect, Effect effect2) {
        this.inputs = new ArrayList<Effect>(2);
        this.unmodifiableInputs = Collections.unmodifiableList(this.inputs);
        this.maxInputs = 2;
        this.inputListener = new InputChangeListener();
        this.setInput(0, effect);
        this.setInput(1, effect2);
    }

    Object getState() {
        return null;
    }

    public int getNumInputs() {
        return this.inputs.size();
    }

    public final List<Effect> getInputs() {
        return this.unmodifiableInputs;
    }

    protected void setInput(int n, Effect effect) {
        if (n < 0 || n >= this.maxInputs) {
            throw new IllegalArgumentException("Index must be within allowable range");
        }
        if (n < this.inputs.size()) {
            Effect effect2 = this.inputs.get(n);
            if (effect2 != null) {
                effect2.removePropertyChangeListener(this.inputListener);
            }
            this.inputs.set(n, effect);
        } else {
            this.inputs.add(effect);
        }
        if (effect != null) {
            effect.addPropertyChangeListener(this.inputListener);
        }
        this.firePropertyChange("inputs", null, this.inputs);
    }

    public Bounds2D combineBounds(Bounds2D ... bounds2DArray) {
        Bounds2D bounds2D = null;
        if (bounds2DArray.length == 1) {
            bounds2D = bounds2DArray[0];
        } else {
            for (int i = 0; i < bounds2DArray.length; ++i) {
                Bounds2D bounds2D2 = bounds2DArray[i];
                if (bounds2D2 == null || bounds2D2.isEmpty()) continue;
                if (bounds2D == null) {
                    bounds2D = new Bounds2D(bounds2D2);
                    continue;
                }
                bounds2D.unionWith(bounds2D2);
            }
        }
        if (bounds2D == null) {
            bounds2D = new Bounds2D();
        }
        return bounds2D;
    }

    public Rectangle getResultBounds(BaseTransform baseTransform, ImageData ... imageDataArray) {
        int n = imageDataArray.length;
        Bounds2D[] bounds2DArray = new Bounds2D[n];
        for (int i = 0; i < n; ++i) {
            bounds2DArray[i] = imageDataArray[i].getBounds().toBounds2D();
        }
        return new Rectangle(this.combineBounds(bounds2DArray));
    }

    public abstract ImageData filter(FilterContext var1, BaseTransform var2, Effect var3);

    public static Bounds2D transformBounds(BaseTransform baseTransform, Bounds2D bounds2D) {
        if (baseTransform == null || baseTransform.isIdentity()) {
            return bounds2D;
        }
        Bounds2D bounds2D2 = new Bounds2D();
        baseTransform.transform(bounds2D, bounds2D2);
        return bounds2D2;
    }

    protected ImageData ensureTransform(FilterContext filterContext, ImageData imageData, BaseTransform baseTransform) {
        if (baseTransform == null || baseTransform.isIdentity()) {
            return imageData;
        }
        if (!imageData.validate(filterContext)) {
            imageData.unref();
            return new ImageData(filterContext, null, new Rectangle());
        }
        Rectangle rectangle = imageData.getBounds();
        if (baseTransform.isTranslateOrIdentity()) {
            double d = baseTransform.getMxt();
            double d2 = baseTransform.getMyt();
            int n = (int)d;
            int n2 = (int)d2;
            if ((double)n == d && (double)n2 == d2) {
                Rectangle rectangle2 = new Rectangle(rectangle);
                rectangle2.translate(n, n2);
                ImageData imageData2 = new ImageData(imageData, rectangle2);
                imageData.unref();
                return imageData2;
            }
        }
        Bounds2D bounds2D = Effect.transformBounds(baseTransform, rectangle.toBounds2D());
        Rectangle rectangle3 = new Rectangle(bounds2D);
        return Renderer.getRenderer(filterContext).transform(filterContext, imageData, baseTransform, rectangle, rectangle3);
    }

    public final Bounds2D getBounds() {
        return this.getBounds(null, null);
    }

    Effect getDefaultedInput(int n, Effect effect) {
        return Effect.getDefaultedInput(this.inputs.get(n), effect);
    }

    static Effect getDefaultedInput(Effect effect, Effect effect2) {
        return effect == null ? effect2 : effect;
    }

    public abstract Bounds2D getBounds(BaseTransform var1, Effect var2);

    public Point2D transform(Point2D point2D, Effect effect) {
        return point2D;
    }

    public Point2D untransform(Point2D point2D, Effect effect) {
        return point2D;
    }

    public static Filterable createCompatibleImage(FilterContext filterContext, int n, int n2) {
        return Renderer.getRenderer(filterContext).createCompatibleImage(n, n2);
    }

    public static Filterable getCompatibleImage(FilterContext filterContext, int n, int n2) {
        return Renderer.getRenderer(filterContext).getCompatibleImage(n, n2);
    }

    public static void releaseCompatibleImage(FilterContext filterContext, Filterable filterable) {
        Renderer.getRenderer(filterContext).releaseCompatibleImage(filterable);
    }

    public abstract AccelType getAccelType(FilterContext var1);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        this.pcs.firePropertyChange(string, object, object2);
    }

    static {
        AccessHelper.setStateAccessor(new AccessHelper.StateAccessor(){

            public Object getState(Effect effect) {
                return effect.getState();
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccelType {
        INTRINSIC("Intrinsic"),
        NONE("CPU/Java"),
        SIMD("CPU/SIMD"),
        FIXED("CPU/Fixed"),
        OPENGL("OpenGL"),
        DIRECT3D("Direct3D");

        private String text;

        private AccelType(String string2) {
            this.text = string2;
        }

        public String toString() {
            return this.text;
        }
    }

    private class InputChangeListener
    implements PropertyChangeListener {
        private InputChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Effect.this.firePropertyChange("inputs", null, Effect.this.inputs);
        }
    }
}

