/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;

public abstract class EffectPeer {
    private final FilterContext fctx;
    private final Renderer renderer;
    private final String uniqueName;
    private Effect effect;
    private int pass;
    private final Rectangle[] inputBounds = new Rectangle[2];
    private final Rectangle[] inputNativeBounds = new Rectangle[2];
    private Rectangle destBounds;
    private final Rectangle destNativeBounds = new Rectangle();

    protected EffectPeer(FilterContext filterContext, Renderer renderer, String string) {
        if (filterContext == null) {
            throw new IllegalArgumentException("FilterContext must be non-null");
        }
        this.fctx = filterContext;
        this.renderer = renderer;
        this.uniqueName = string;
    }

    public boolean isImageDataCompatible(ImageData imageData) {
        return this.getRenderer().isImageDataCompatible(imageData);
    }

    public abstract ImageData filter(Effect var1, BaseTransform var2, ImageData ... var3);

    public void dispose() {
    }

    public Effect.AccelType getAccelType() {
        return this.renderer.getAccelType();
    }

    protected final FilterContext getFilterContext() {
        return this.fctx;
    }

    protected Renderer getRenderer() {
        return this.renderer;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    protected Effect getEffect() {
        return this.effect;
    }

    protected void setEffect(Effect effect) {
        this.effect = effect;
    }

    public final int getPass() {
        return this.pass;
    }

    public void setPass(int n) {
        this.pass = n;
    }

    protected final Rectangle getInputBounds(int n) {
        return this.inputBounds[n];
    }

    protected final void setInputBounds(int n, Rectangle rectangle) {
        this.inputBounds[n] = rectangle;
    }

    protected final Rectangle getInputNativeBounds(int n) {
        return this.inputNativeBounds[n];
    }

    protected final void setInputNativeBounds(int n, Rectangle rectangle) {
        this.inputNativeBounds[n] = rectangle;
    }

    public Rectangle getResultBounds(BaseTransform baseTransform, ImageData ... imageDataArray) {
        return this.getEffect().getResultBounds(baseTransform, imageDataArray);
    }

    protected float[] getSourceRegion(int n) {
        return EffectPeer.getSourceRegion(this.getInputBounds(n), this.getInputNativeBounds(n), this.getDestBounds());
    }

    static float[] getSourceRegion(Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        float f = rectangle3.x - rectangle.x;
        float f2 = rectangle3.y - rectangle.y;
        float f3 = f + (float)rectangle3.width;
        float f4 = f2 + (float)rectangle3.height;
        float f5 = rectangle2.width;
        float f6 = rectangle2.height;
        return new float[]{f / f5, f2 / f6, f3 / f5, f4 / f6};
    }

    protected final void setDestBounds(Rectangle rectangle) {
        this.destBounds = rectangle;
    }

    protected final Rectangle getDestBounds() {
        return this.destBounds;
    }

    protected final Rectangle getDestNativeBounds() {
        return this.destNativeBounds;
    }

    protected final void setDestNativeBounds(int n, int n2) {
        this.destNativeBounds.width = n;
        this.destNativeBounds.height = n2;
    }

    protected Object getSamplerData(int n) {
        return null;
    }

    protected boolean isOriginUpperLeft() {
        return this.getAccelType() != Effect.AccelType.OPENGL;
    }
}

