/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.HVSeparableKernel;
import com.sun.scenario.effect.impl.state.LinearConvolveKernel;
import java.nio.FloatBuffer;

public class BoxBlurState
extends HVSeparableKernel {
    private int hsize;
    private int vsize;
    private int blurPasses;
    private FloatBuffer weights;

    public int getHsize() {
        return this.hsize;
    }

    public void setHsize(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Blur size must be in the range [0,255]");
        }
        this.hsize = n;
    }

    public int getVsize() {
        return this.vsize;
    }

    public void setVsize(int n) {
        if (n < 0 || n > 255) {
            throw new IllegalArgumentException("Blur size must be in the range [0,255]");
        }
        this.vsize = n;
    }

    public int getBlurPasses() {
        return this.blurPasses;
    }

    public void setBlurPasses(int n) {
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException("Number of passes must be in the range [0,3]");
        }
        this.blurPasses = n;
    }

    public float getSpread() {
        return 0.0f;
    }

    public boolean isNop() {
        return this.blurPasses == 0 || this.hsize <= 1 && this.vsize <= 1;
    }

    public boolean isNop(int n) {
        return this.blurPasses == 0 || (n == 0 ? this.hsize : this.vsize) <= 1;
    }

    public int getKernelSize(int n) {
        int n2;
        int n3 = n2 = n == 0 ? this.hsize : this.vsize;
        if (n2 < 1) {
            n2 = 1;
        }
        n2 = (n2 - 1) * this.blurPasses + 1;
        return n2 |= 1;
    }

    private int getScaleVal(int n, boolean bl) {
        int n2 = this.getKernelSize(n);
        int n3 = 0;
        while (n2 > 128) {
            n2 = (n2 + 1) / 2 | 1;
            --n3;
        }
        return bl ? n3 : n2;
    }

    public int getPow2Scale(int n) {
        return this.getScaleVal(n, true);
    }

    public int getScaledKernelSize(int n) {
        return this.getScaleVal(n, false);
    }

    public int getPow2ScaleX() {
        return this.getPow2Scale(0);
    }

    public int getPow2ScaleY() {
        return this.getPow2Scale(1);
    }

    public FloatBuffer getWeights(int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = n5 = n == 0 ? this.hsize : this.vsize;
        if (n5 < 1 || this.blurPasses == 0) {
            n5 = 1;
        }
        long[] lArray = new long[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            lArray[n4] = 1L;
        }
        for (n4 = 1; n4 < this.blurPasses; ++n4) {
            long[] lArray2 = new long[lArray.length + n5 - 1];
            for (n3 = 0; n3 < lArray.length; ++n3) {
                for (int i = 0; i < n5; ++i) {
                    int n7 = n3 + i;
                    lArray2[n7] = lArray2[n7] + lArray[n3];
                }
            }
            lArray = lArray2;
        }
        if ((lArray.length & 1) == 0) {
            long[] lArray3 = new long[lArray.length + 1];
            for (int i = 0; i < lArray.length; ++i) {
                int n8 = i;
                lArray3[n8] = lArray3[n8] + lArray[i];
                int n9 = i + 1;
                lArray3[n9] = lArray3[n9] + lArray[i];
            }
            lArray = lArray3;
        }
        for (int i = this.getPow2Scale(n); i < 0; ++i) {
            int n10 = (lArray.length + 1) / 2 | 1;
            n3 = (n10 * 2 - lArray.length) / 2;
            long[] lArray4 = new long[n10];
            for (int j = 0; j < lArray.length; ++j) {
                int n11 = n3 / 2;
                lArray4[n11] = lArray4[n11] + lArray[j];
                int n12 = ++n3 / 2;
                lArray4[n12] = lArray4[n12] + lArray[j];
            }
            lArray = lArray4;
        }
        double d = 0.0;
        for (n2 = 0; n2 < lArray.length; ++n2) {
            d += (double)lArray[n2];
        }
        d += ((double)lArray[0] - d) * (double)this.getSpread();
        if (this.weights == null) {
            n2 = 128;
            n2 = LinearConvolveKernel.getPeerSize(n2);
            n2 = n2 + 3 & 0xFFFFFFFC;
            this.weights = BufferUtil.newFloatBuffer(n2);
        }
        this.weights.clear();
        for (n2 = 0; n2 < lArray.length; ++n2) {
            this.weights.put((float)((double)lArray[n2] / d));
        }
        n2 = BoxBlurState.getPeerSize(lArray.length);
        while (this.weights.position() < n2) {
            this.weights.put(0.0f);
        }
        this.weights.limit(n2);
        this.weights.rewind();
        return this.weights;
    }

    public EffectPeer getPeer(Renderer renderer, FilterContext filterContext, int n) {
        String string;
        int n2 = this.getScaledKernelSize(n);
        if (n2 <= 1) {
            return null;
        }
        int n3 = BoxBlurState.getPeerSize(n2);
        Effect.AccelType accelType = renderer.getAccelType();
        switch (accelType) {
            case NONE: 
            case SIMD: {
                string = "BoxBlur";
                break;
            }
            default: {
                string = "LinearConvolve";
            }
        }
        EffectPeer effectPeer = renderer.getPeerInstance(filterContext, string, n3);
        return effectPeer;
    }
}

