/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.scenario.effect.impl.BufferUtil;
import com.sun.scenario.effect.impl.state.HVSeparableKernel;
import java.nio.FloatBuffer;

public class GaussianBlurState
extends HVSeparableKernel {
    private float hradius;
    private float vradius;
    private FloatBuffer weights;

    void checkRadius(float f) {
        if (f < 0.0f || f > 63.0f) {
            throw new IllegalArgumentException("Radius must be in the range [1,63]");
        }
    }

    public float getRadius() {
        return (this.hradius + this.vradius) / 2.0f;
    }

    public void setRadius(float f) {
        this.checkRadius(f);
        this.hradius = f;
        this.vradius = f;
    }

    public float getHRadius() {
        return this.hradius;
    }

    public void setHRadius(float f) {
        this.checkRadius(f);
        this.hradius = f;
    }

    public float getVRadius() {
        return this.vradius;
    }

    public void setVRadius(float f) {
        this.checkRadius(f);
        this.vradius = f;
    }

    float getRadius(int n) {
        return n == 0 ? this.hradius : this.vradius;
    }

    public boolean isNop() {
        return this.hradius == 0.0f && this.vradius == 0.0f;
    }

    public boolean isNop(int n) {
        return this.getRadius(n) == 0.0f;
    }

    public int getPad(int n) {
        return (int)Math.ceil(this.getRadius(n));
    }

    public int getScaledPad(int n) {
        return this.getPad(n);
    }

    public float getScaledRadius(int n) {
        return this.getRadius(n);
    }

    public int getKernelSize(int n) {
        return this.getPad(n) * 2 + 1;
    }

    public float getSpread() {
        return 0.0f;
    }

    public FloatBuffer getWeights(int n) {
        this.weights = GaussianBlurState.getGaussianWeights(this.weights, this.getScaledPad(n), this.getScaledRadius(n), this.getSpread());
        return this.weights;
    }

    static FloatBuffer getGaussianWeights(FloatBuffer floatBuffer, int n, float f, float f2) {
        int n2;
        int n3 = n;
        int n4 = n3 * 2 + 1;
        if (floatBuffer == null) {
            floatBuffer = BufferUtil.newFloatBuffer(128);
        }
        floatBuffer.clear();
        float f3 = f / 3.0f;
        float f4 = 2.0f * f3 * f3;
        if (f4 < Float.MIN_VALUE) {
            f4 = Float.MIN_VALUE;
        }
        float f5 = 0.0f;
        for (n2 = -n3; n2 <= n3; ++n2) {
            float f6 = (float)Math.exp((float)(-(n2 * n2)) / f4);
            floatBuffer.put(f6);
            f5 += f6;
        }
        f5 += (floatBuffer.get(0) - f5) * f2;
        for (n2 = 0; n2 < n4; ++n2) {
            floatBuffer.put(n2, floatBuffer.get(n2) / f5);
        }
        n2 = GaussianBlurState.getPeerSize(n4);
        while (floatBuffer.position() < n2) {
            floatBuffer.put(0.0f);
        }
        floatBuffer.limit(n2);
        floatBuffer.rewind();
        return floatBuffer;
    }
}

