/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.state;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.EffectPeer;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.LinearConvolvePeer;
import java.nio.FloatBuffer;

public abstract class LinearConvolveKernel {
    public static final int MAX_KERNEL_SIZE = 128;
    protected static float[] BLACK_COMPONENTS = Color4f.BLACK.getPremultipliedRGBComponents();

    public static int getPeerSize(int n) {
        if (n < 32) {
            return n + 3 & 0xFFFFFFFC;
        }
        if (n <= 128) {
            return n + 31 & 0xFFFFFFE0;
        }
        throw new RuntimeException("No peer available for kernel size: " + n);
    }

    public boolean isShadow() {
        return false;
    }

    public abstract int getNumberOfPasses();

    public boolean isNop() {
        return false;
    }

    public boolean isNop(int n) {
        return false;
    }

    public PassType getPassType(int n) {
        return PassType.GENERAL_VECTOR;
    }

    public abstract Rectangle getResultBounds(Rectangle var1, int var2);

    public Rectangle getScaledResultBounds(Rectangle rectangle, int n) {
        return this.getResultBounds(rectangle, n);
    }

    public abstract float[] getVector(Rectangle var1, int var2);

    public abstract int getKernelSize(int var1);

    public int getScaledKernelSize(int n) {
        return this.getKernelSize(n);
    }

    public int getPow2ScaleX() {
        return 0;
    }

    public int getPow2ScaleY() {
        return 0;
    }

    public abstract FloatBuffer getWeights(int var1);

    public int getWeightsArrayLength(int n) {
        int n2 = this.getScaledKernelSize(n);
        int n3 = LinearConvolveKernel.getPeerSize(n2);
        return n3 / 4;
    }

    public float[] getShadowColorComponents(int n) {
        return BLACK_COMPONENTS;
    }

    public EffectPeer getPeer(Renderer renderer, FilterContext filterContext, int n) {
        if (this.isNop(n)) {
            return null;
        }
        int n2 = this.getScaledKernelSize(n);
        int n3 = LinearConvolveKernel.getPeerSize(n2);
        String string = this.isShadow() ? "LinearConvolveShadow" : "LinearConvolve";
        return renderer.getPeerInstance(filterContext, string, n3);
    }

    public ImageData filterImageDatas(Effect effect, FilterContext filterContext, BaseTransform baseTransform, ImageData ... imageDataArray) {
        ImageData imageData;
        ImageData imageData2 = imageDataArray[0];
        imageData2.addref();
        if (this.isNop()) {
            return imageData2;
        }
        Rectangle rectangle = imageDataArray[0].getBounds();
        int n = rectangle.width;
        int n2 = rectangle.height;
        Renderer renderer = Renderer.getRenderer(filterContext, effect, n, n2);
        EffectPeer effectPeer = this.getPeer(renderer, filterContext, 0);
        EffectPeer effectPeer2 = this.getPeer(renderer, filterContext, 1);
        int n3 = 0;
        int n4 = 0;
        if (effectPeer instanceof LinearConvolvePeer) {
            n3 = ((LinearConvolvePeer)((Object)effectPeer)).getPow2ScaleX(this);
        }
        if (effectPeer2 instanceof LinearConvolvePeer) {
            n4 = ((LinearConvolvePeer)((Object)effectPeer2)).getPow2ScaleY(this);
        }
        if (!(imageData2 = renderer.transform(filterContext, imageData2, n3, n4)).validate(filterContext)) {
            imageData2.unref();
            return imageData2;
        }
        if (effectPeer != null) {
            effectPeer.setPass(0);
            imageData = effectPeer.filter(effect, baseTransform, imageData2);
            imageData2.unref();
            imageData2 = imageData;
            if (!imageData2.validate(filterContext)) {
                imageData2.unref();
                return imageData2;
            }
        }
        if (effectPeer2 != null) {
            effectPeer2.setPass(1);
            imageData = effectPeer2.filter(effect, baseTransform, imageData2);
            imageData2.unref();
            imageData2 = imageData;
            if (!imageData2.validate(filterContext)) {
                imageData2.unref();
                return imageData2;
            }
        }
        imageData2 = renderer.transform(filterContext, imageData2, -n3, -n4);
        return imageData2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PassType {
        HORIZONTAL_CENTERED,
        VERTICAL_CENTERED,
        GENERAL_VECTOR;

    }
}

