/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppwakolc.serialinterface.vscoring;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import org.sportdata.setppwakolc.anzeige.beans.AnzeigeMaster;
import org.sportdata.setppwakolc.anzeige.beans.ScoringObject;
import org.sportdata.setppwakolc.anzeige.utils.DateUtils;
import org.sportdata.setppwakolc.anzeige.utils.FehlerFenster;
import org.sportdata.setppwakolc.scores.ProcessScores;

public class SerialInterfaceVscoring {
    public static synchronized void sendSerialMessage(final String str) {
        if (str.length() > 0) {
            try {
                Thread rt = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AnzeigeMaster.getInstance().getSerialPortVscoring().writeBytes(str.getBytes(), (long)str.getBytes().length);
                            System.out.println("Serial Interface: " + str.getBytes().length + " bytes sent. Content: " + str);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }, "Write Thread");
                rt.start();
            }
            catch (Exception ex) {
                new FehlerFenster("Error occurred while writing data.");
            }
        }
    }

    public static void handleInputMessage(byte[] buffer) {
        String message = new String(buffer);
        try {
            message = message.substring(message.indexOf("{"), message.lastIndexOf("}") + 1);
            message = message.trim();
        }
        catch (Exception e) {
            System.out.println("Serial Interface: No valid ScoringObject Json!");
        }
        try {
            System.out.println("Serial Interface: Received " + message.getBytes().length + " bytes. Content: " + message);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (message != null && !message.trim().equals("") && message.indexOf("ScoreAction") > -1) {
            Gson gson = new Gson();
            JsonParser jsonParser = new JsonParser();
            String json = jsonParser.parse(message).getAsJsonObject().toString();
            ScoringObject obj = (ScoringObject)gson.fromJson(json, ScoringObject.class);
            obj.setGenerated(DateUtils.getDateFormated());
            ProcessScores.processExternalScores(obj);
        }
    }
}

