/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppwakolc.server.servlet;

import com.google.gson.Gson;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sportdata.setppwakolc.anzeige.beans.AnzeigeMaster;
import org.sportdata.setppwakolc.anzeige.beans.ScoringObject;
import org.sportdata.setppwakolc.anzeige.utils.DateUtils;

public class ScoringServlet
extends HttpServlet {
    public static final String SERVLET_URL = "scoring";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        response.getWriter().println("Scoring Request GET 200");
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)request.getInputStream()));
            String message = "";
            if (br != null) {
                message = br.readLine();
            }
            if (message != null && !message.trim().equals("") && message.indexOf("ScoreAction") > -1) {
                Gson gson = new Gson();
                JsonParser jsonParser = new JsonParser();
                String json = jsonParser.parse(message).getAsJsonObject().toString();
                ScoringObject obj = (ScoringObject)gson.fromJson(json, ScoringObject.class);
                if (json.indexOf("batterylevel") > -1) {
                    AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(113, "batterylevel," + obj.getReferee() + "," + obj.getBatterylevel());
                }
                obj.printObject();
                boolean hasvalidscorer = false;
                if (!AnzeigeMaster.getInstance().hasRoundScores()) {
                    ArrayList<Integer> refswithdraw;
                    if (obj.getScoreName().equals("point")) {
                        hasvalidscorer = true;
                        if (AnzeigeMaster.getInstance().hasAssignedImeiReferee(obj.getImei(), "" + obj.getReferee())) {
                            if (AnzeigeMaster.getInstance().getAnzeige().getClock().isRunningTrue() || DateUtils.isValidAppRequestByDateOfRunningClock(obj.getGenerated())) {
                                this.a(obj);
                            } else if (AnzeigeMaster.getInstance().isDecisionmode() && (refswithdraw = AnzeigeMaster.getInstance().getAnzeige().getJudgePointsComponent().getRefereeDrawEnd()).contains(obj.getReferee())) {
                                this.b(obj);
                                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(45, "");
                                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(204, "");
                            }
                            response.setContentType("text/html");
                            response.setStatus(200);
                            response.getWriter().println("Scoring request successfully processed");
                        } else {
                            response.setContentType("text/html");
                            response.setStatus(400);
                            response.getWriter().println("No assignment for imei and referee");
                        }
                    }
                    if (obj.getScoreName().equals("SITCLIENT")) {
                        hasvalidscorer = true;
                        if (AnzeigeMaster.getInstance().getAnzeige().getClock().isRunningTrue() || DateUtils.isValidAppRequestByDateOfRunningClock(obj.getGenerated())) {
                            this.a(obj);
                        } else if (AnzeigeMaster.getInstance().isDecisionmode() && (refswithdraw = AnzeigeMaster.getInstance().getAnzeige().getJudgePointsComponent().getRefereeDrawEnd()).contains(obj.getReferee())) {
                            this.b(obj);
                            AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(45, "");
                            AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(204, "");
                        }
                        response.setContentType("text/html");
                        response.setStatus(200);
                        response.getWriter().println("Scoring request successfully processed");
                    }
                }
                if (AnzeigeMaster.getInstance().hasRoundScores()) {
                    if (obj.getScoreName().equals("resultinput")) {
                        hasvalidscorer = true;
                        if (AnzeigeMaster.getInstance().hasAssignedImeiReferee(obj.getImei(), "" + obj.getReferee())) {
                            AnzeigeMaster.getInstance().getRefereesPoints().put(obj.getReferee(), obj);
                            AnzeigeMaster.getInstance().showRefereePointsWindow();
                            response.setContentType("text/html");
                            response.setStatus(200);
                            response.getWriter().println("Scoring request successfully processed");
                        } else {
                            response.setContentType("text/html");
                            response.setStatus(400);
                            response.getWriter().println("No assignment for imei and referee");
                        }
                    }
                    if (obj.getScoreName().equals("point") || obj.getScoreName().equals("SITCLIENT")) {
                        hasvalidscorer = true;
                        if (AnzeigeMaster.getInstance().hasAssignedImeiReferee(obj.getImei(), "" + obj.getReferee())) {
                            if (AnzeigeMaster.getInstance().getAnzeige().getClock().isRunningTrue()) {
                                if (obj.getScorer().indexOf("RED") > -1) {
                                    obj.setScoreValue(1.0f);
                                    obj.setScoreValue2(0.0f);
                                }
                                if (obj.getScorer().indexOf("BLUE") > -1) {
                                    obj.setScoreValue(0.0f);
                                    obj.setScoreValue2(1.0f);
                                }
                                obj.setScoreName("resultinput_manual");
                                if (AnzeigeMaster.getInstance().getRefereesPoints().containsKey(obj.getReferee())) {
                                    ScoringObject obj2 = AnzeigeMaster.getInstance().getRefereesPoints().get(obj.getReferee());
                                    obj2.setScoreValue(obj2.getScoreValue() + obj.getScoreValue());
                                    obj2.setScoreValue2(obj2.getScoreValue2() + obj.getScoreValue2());
                                } else {
                                    AnzeigeMaster.getInstance().getRefereesPoints().put(obj.getReferee(), obj);
                                }
                                AnzeigeMaster.getInstance().showRefereePointsWindow();
                                response.setContentType("text/html");
                                response.setStatus(200);
                                response.getWriter().println("Scoring request successfully processed");
                            } else {
                                response.setContentType("text/html");
                                response.setStatus(400);
                                response.getWriter().println("Not allowed to score");
                            }
                        } else {
                            response.setContentType("text/html");
                            response.setStatus(400);
                            response.getWriter().println("No assignment for imei and referee");
                        }
                    }
                }
                if (obj.getScoreName().equals("kick")) {
                    hasvalidscorer = true;
                    if (AnzeigeMaster.getInstance().hasAssignedImeiReferee(obj.getImei(), "" + obj.getReferee())) {
                        if (AnzeigeMaster.getInstance().getAnzeige().getClock().isRunningTrue() || DateUtils.isValidAppRequestByDateOfRunningClock(obj.getGenerated())) {
                            if (obj.getScorer().indexOf("RED") > -1) {
                                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(180, "");
                            }
                            if (obj.getScorer().indexOf("BLUE") > -1) {
                                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(182, "");
                            }
                        }
                        response.setContentType("text/html");
                        response.setStatus(200);
                        response.getWriter().println("Scoring request successfully processed");
                    } else {
                        response.setContentType("text/html");
                        response.setStatus(400);
                        response.getWriter().println("No assignment for imei and referee");
                    }
                }
                if (obj.getScoreName().equals("SITCLIENT_KICK")) {
                    hasvalidscorer = true;
                    if (AnzeigeMaster.getInstance().getAnzeige().getClock().isRunningTrue() || DateUtils.isValidAppRequestByDateOfRunningClock(obj.getGenerated())) {
                        if (obj.getScorer().indexOf("RED") > -1) {
                            AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(180, "");
                        }
                        if (obj.getScorer().indexOf("BLUE") > -1) {
                            AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(182, "");
                        }
                    }
                    response.setContentType("text/html");
                    response.setStatus(200);
                    response.getWriter().println("Scoring request successfully processed");
                }
                if (!hasvalidscorer) {
                    response.setContentType("text/html");
                    response.setStatus(400);
                    response.getWriter().println("Request Json not valid");
                }
            } else {
                response.setContentType("text/html");
                response.setStatus(400);
                response.getWriter().println("Request Json not valid");
            }
        }
        catch (Exception e) {
            try {
                response.setContentType("text/html");
                response.setStatus(400);
                response.getWriter().println("Error processing scoring");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void a(ScoringObject obj) {
        int score;
        if (obj.getScorer().indexOf("RED") > -1 && (score = Math.round(obj.getScoreValue())) > 0) {
            if (obj.getReferee() == 1) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(157, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 2) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(161, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 3) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(165, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 4) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(242, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 5) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(246, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
        }
        if (obj.getScorer().indexOf("BLUE") > -1 && (score = Math.round(obj.getScoreValue())) > 0) {
            if (obj.getReferee() == 1) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(158, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 2) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(162, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 3) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(166, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 4) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(243, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 5) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(247, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
        }
    }

    private void b(ScoringObject obj) {
        int score;
        if (obj.getScorer().indexOf("RED") > -1) {
            score = 1;
            if (obj.getReferee() == 1) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(157, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 2) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(161, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 3) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(165, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 4) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(242, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 5) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(246, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
        }
        if (obj.getScorer().indexOf("BLUE") > -1) {
            score = 1;
            if (obj.getReferee() == 1) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(158, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 2) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(162, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 3) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(166, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 4) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(243, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
            if (obj.getReferee() == 5) {
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(247, "" + score);
                AnzeigeMaster.getInstance().getAnzeige().getAcontrol().notifyListeners(41, "");
            }
        }
    }
}

