/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppwakolc.server.servlet.webapp.amma;

import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sportdata.setppwakolc.anzeige.beans.AnzeigeMaster;
import org.sportdata.setppwakolc.anzeige.beans.ScoringAuthObject;

public class ScoringWebAppPairServlet
extends HttpServlet {
    public static final String SERVLET_URL = "sc_wakolc_pair";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        String imei = ScoringWebAppPairServlet.getUUID(request);
        if (!imei.equals("") && AnzeigeMaster.getInstance().getReferees().containsKey(imei) && AnzeigeMaster.getInstance().getReferees().get(imei).isIsassigned()) {
            response.sendRedirect("sc_wakolc_score");
        } else {
            this.a(request, response, "", "");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setStatus(200);
        try {
            Map paramap = request.getParameterMap();
            if (paramap.size() > 0) {
                ScoringAuthObject sao = new ScoringAuthObject();
                sao.mapObject(paramap);
                boolean hasuuid_imei = false;
                if (request.getCookies() != null && request.getCookies().length > 0) {
                    Cookie[] cookies = request.getCookies();
                    int i = 0;
                    while (cookies != null && i < cookies.length) {
                        if (cookies[i].getName().equals("SCORING_UUID")) {
                            sao.setImei(cookies[i].getValue());
                            hasuuid_imei = true;
                            System.out.println("Scoring client has IMEI UUID: " + cookies[i].getValue());
                            break;
                        }
                        ++i;
                    }
                }
                if (!hasuuid_imei) {
                    String uuid = UUID.randomUUID().toString();
                    sao.setImei(uuid);
                    Cookie cookie = new Cookie("SCORING_UUID", uuid);
                    cookie.setMaxAge(31536000);
                    response.addCookie(cookie);
                    System.out.println("Scoring client gets new IMEI UUID: " + uuid);
                }
                if (sao.getPin() == null || sao.getPin().equals("")) {
                    sao.setPin("0");
                }
                sao.printObject();
                AnzeigeMaster.getInstance().printRefereesList();
                if (sao.isValidObject()) {
                    if (AnzeigeMaster.getInstance().getReferees().containsKey(sao.getImei()) && !AnzeigeMaster.getInstance().getReferees().get(sao.getImei()).isIsassigned()) {
                        String referee = ScoringWebAppPairServlet.getRefereeNumber(request);
                        if (referee.equals("") && request.getParameter("refnr") != null) {
                            referee = request.getParameter("refnr");
                        }
                        response.setContentType("text/html");
                        response.setStatus(200);
                        Object commentadd = "";
                        commentadd = "Please wait for approval of the Software operator and then click on the RELOAD button".toUpperCase();
                        commentadd = (String)commentadd + "<br><br>";
                        commentadd = (String)commentadd + "<form method=\"post\">";
                        commentadd = (String)commentadd + "<input type=\"hidden\" name=\"pin\" id=\"pin\" value=\"0\">";
                        commentadd = (String)commentadd + "<input type=\"hidden\" name=\"refnr\" id=\"refnr\" value=\"" + referee + "\">";
                        commentadd = (String)commentadd + "<input type=\"submit\" value=\"RELOAD\">";
                        commentadd = (String)commentadd + "</form>";
                        this.a(request, response, (String)commentadd, "yellow");
                    }
                    if (AnzeigeMaster.getInstance().getReferees().containsKey(sao.getImei()) && AnzeigeMaster.getInstance().getReferees().get(sao.getImei()).isIsassigned()) {
                        response.sendRedirect("sc_wakolc_score");
                    }
                } else if (sao.getComment().equals("Device and Referee Number already assigned") && AnzeigeMaster.getInstance().getReferees().containsKey(sao.getImei()) && AnzeigeMaster.getInstance().getReferees().get(sao.getImei()).isIsassigned()) {
                    response.sendRedirect("sc_wakolc_score");
                } else {
                    response.setContentType("text/html");
                    response.setStatus(400);
                    this.a(request, response, sao.getComment().toUpperCase(), "red");
                }
            } else {
                response.setContentType("text/html");
                response.setStatus(400);
                this.a(request, response, "No parameters sent".toUpperCase(), "red");
            }
        }
        catch (Exception e) {
            response.setContentType("text/html");
            response.setStatus(400);
            this.a(request, response, "No parameters sent".toUpperCase(), "red");
        }
    }

    private void a(HttpServletRequest request, HttpServletResponse response, String comment, String commentcolor) {
        try {
            response.getWriter().println("<html>");
            response.getWriter().println("<head>");
            response.getWriter().println("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"><meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">");
            response.getWriter().println("<title>SCORING - PAIRING/CHECK</title>");
            response.getWriter().println("<style type=\"text/css\">");
            response.getWriter().println("body { background:#000000; color:#ffffff; font-family: Helvetica,Arial,sans-serif;font-size: 20px;margin: 10px;padding: 0;text-align: center;background-image: url(../images/award-cermony/award-bg-9.jpg);background-repeat: no-repeat;background-position: center center;background-attachment: fixed;background-size: cover;}");
            response.getWriter().println(".card { color:#ffffff; box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2); transition: 0.3s; width: 80%; background:rgba(255,255,255,0.1);text-align: center; margin-left: auto; margin-right: auto; margin-bottom: 30px;}");
            response.getWriter().println(".card:hover { box-shadow: 0 8px 16px 0 rgba(209,210,255,0.7);}");
            response.getWriter().println(".container {  padding: 2px 16px;}");
            response.getWriter().println(".card2 { color:#ffffff; box-shadow: 0 4px 8px 0 rgba(0,0,0,0.2); transition: 0.3s; width: 80%; background:rgba(255,255,255,0.1);text-align: center; margin-left: auto; margin-right: auto; margin-bottom: 30px; padding: 10px;}");
            response.getWriter().println("img {  max-width:100%;height: auto;}");
            response.getWriter().println(".centered {margin: auto;width: 100%;}");
            response.getWriter().println("a { color:#ffffff;text-decoration:none}");
            response.getWriter().println("a:hover { color: rgba(168,170,255,1); }");
            response.getWriter().println("input {font-size:50px; width: 90%}");
            response.getWriter().println("option {font-size:50px; text-align: center; text-align-last: center; -moz-text-align-last: center; background-color: #ffffff; color: #000000}");
            response.getWriter().println("select {font-size:50px; width: 90%; text-align: center; text-align-last: center; -moz-text-align-last: center; background-color: #ffffff; color: #000000}");
            response.getWriter().println("input {font-size:50px; width: 90%; text-align: center; text-align-last: center; -moz-text-align-last: center; background-color: #ffffff; color: #000000}");
            response.getWriter().println(".responsive { height: auto; }");
            response.getWriter().println("</style>");
            response.getWriter().println("<link rel=\"shortcut icon\" href=\"../images/favicon.ico\">");
            response.getWriter().println("</head>");
            response.getWriter().println("<body>");
            if (AnzeigeMaster.getInstance() != null && AnzeigeMaster.getInstance().getAcp() != null) {
                response.getWriter().println("<div class=\"card2\">");
                response.getWriter().println("<div class=\"container\">");
                response.getWriter().println("<h2>" + "SCORING - PAIRING/CHECK".toUpperCase() + "</h2>");
                response.getWriter().println("</div>");
                response.getWriter().println("</div>");
                if (comment != null && !comment.equals("")) {
                    response.getWriter().println("<div class=\"card2\">");
                    response.getWriter().println("<div class=\"container\">");
                    response.getWriter().println("<h2 style='color:" + commentcolor + ";'>" + comment + "</h2>");
                    response.getWriter().println("</div>");
                    response.getWriter().println("</div>");
                }
                response.getWriter().println("<div class=\"card2\">");
                response.getWriter().println("<div class=\"container\">");
                response.getWriter().println("<form method=\"post\">");
                response.getWriter().println("<h2>PIN:<br>(only required for new pairing)</h2>");
                response.getWriter().println("<input type=\"number\" name=\"pin\" id=\"pin\" value=\"" + (request.getParameter("pin") != null ? request.getParameter("pin") : "0") + "\" min='0' size='5'>");
                response.getWriter().println("<br><br>");
                response.getWriter().println("<h2>JUDGE:</h2>");
                response.getWriter().println("<select name=\"refnr\" id=\"refnr\" required >");
                String referee = ScoringWebAppPairServlet.getRefereeNumber(request);
                if (!referee.equals("")) {
                    response.getWriter().println("<option value=\"" + referee + "\"  selected>J " + referee + "</option>");
                } else {
                    response.getWriter().println("<option value=\"1\" " + (request.getParameter("refnr") != null && request.getParameter("refnr").equals("1") ? " selected " : "") + ">J1</option>");
                    response.getWriter().println("<option value=\"2\" " + (request.getParameter("refnr") != null && request.getParameter("refnr").equals("2") ? " selected " : "") + ">J2</option>");
                    response.getWriter().println("<option value=\"3\" " + (request.getParameter("refnr") != null && request.getParameter("refnr").equals("3") ? " selected " : "") + ">J3</option>");
                }
                response.getWriter().println("</select>");
                response.getWriter().println("</div>");
                response.getWriter().println("</div>");
                response.getWriter().println("<div class=\"card2\">");
                response.getWriter().println("<div class=\"container\">");
                response.getWriter().println("<input type=\"submit\" value=\"SEND\">");
                response.getWriter().println("</form>");
                response.getWriter().println("</div>");
                response.getWriter().println("</div>");
            }
            response.getWriter().println("</body>");
            response.getWriter().println("</html>");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getUUID(HttpServletRequest request) {
        if (request.getCookies() != null && request.getCookies().length > 0) {
            Cookie[] cookies = request.getCookies();
            int i = 0;
            while (cookies != null && i < cookies.length) {
                if (cookies[i].getName().equals("SCORING_UUID")) {
                    return cookies[i].getValue();
                }
                ++i;
            }
        }
        return "";
    }

    public static String getRefereeNumber(HttpServletRequest request) {
        if (request.getCookies() != null && request.getCookies().length > 0) {
            Cookie[] cookies = request.getCookies();
            int i = 0;
            while (cookies != null && i < cookies.length) {
                if (cookies[i].getName().equals("SCORING_UUID")) {
                    if (!AnzeigeMaster.getInstance().getReferees().containsKey(cookies[i].getValue())) break;
                    return AnzeigeMaster.getInstance().getReferees().get(cookies[i].getValue()).getRefnr();
                }
                ++i;
            }
        }
        return "";
    }

    public static String getReferee(HttpServletRequest request) {
        if (request.getCookies() != null && request.getCookies().length > 0) {
            Cookie[] cookies = request.getCookies();
            int i = 0;
            while (cookies != null && i < cookies.length) {
                if (cookies[i].getName().equals("SCORING_UUID")) {
                    if (!AnzeigeMaster.getInstance().getReferees().containsKey(cookies[i].getValue())) break;
                    return "JUDGE: " + AnzeigeMaster.getInstance().getReferees().get(cookies[i].getValue()).getRefnr();
                }
                ++i;
            }
        }
        return "";
    }
}

