/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppksisas.anzeigeIS.beans;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.sportdata.setppksisas.anzeigeIS.matchtime.MatchtimeHelper;
import org.sportdata.setppksisas.anzeigeIS.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setppksisas.anzeigeIS.ressource.AnzeigeResource;
import org.sportdata.setppksisas.anzeigeIS.utils.LicenseHelper;
import org.sportdata.setppksisas.anzeigeIS.utils.Passwort;

public class AnzeigeMaster {
    private static AnzeigeMaster anzmaster;
    private Properties anzeigeprops = new Properties();
    private LicenseParam licenceParam;
    private LicenseManager licenseManager;
    private LicenseContent licenseContent;
    public static final String SUBJECT = "SET POINT PANEL KSISAS";
    private static ResourceBundle resourceBundle;
    private String langueage = "";
    private HashMap<Integer, Integer> matchtime = new HashMap();
    private Object ath1;
    private Object ath2;
    private Object club1;
    private Object club2;
    private Object nat1;
    private Object nat2;
    private Object cat;
    private LicenseContent templicensecontent;
    private boolean isembedded = false;

    static {
        resourceBundle = ResourceBundle.getBundle("languages.english_ppksisas");
    }

    public AnzeigeMaster(boolean isembedded) {
        anzmaster = this;
        this.isembedded = isembedded;
        anzmaster.loadProps();
        anzmaster.initLicenseParam();
        anzmaster.initLicenseManager();
        anzmaster.initLicenseContent();
        anzmaster.checkLicense();
        anzmaster.initLanguage();
    }

    public AnzeigeMaster(Properties anzeigeprops, LicenseContent templicensecontent) {
        anzmaster = this;
        this.isembedded = true;
        this.templicensecontent = templicensecontent;
        anzmaster.setAnzeigeprops(anzeigeprops);
        anzmaster.initLicenseParam();
        anzmaster.initLicenseManager();
        anzmaster.initLicenseContent();
        anzmaster.checkLicense();
        anzmaster.initLanguage();
    }

    public static AnzeigeMaster getInstance() {
        return anzmaster;
    }

    public LicenseContent getTemplicensecontent() {
        return this.templicensecontent;
    }

    public void setTemplicensecontent(LicenseContent templicensecontent) {
        this.templicensecontent = templicensecontent;
    }

    public Properties getAnzeigeprops() {
        return this.anzeigeprops;
    }

    public void initLanguage() {
        this.setLangueage(AnzeigePropertiesHelper.getLanguage());
    }

    public void setAnzeigeprops(Properties wkvprops) {
        this.anzeigeprops = wkvprops;
    }

    public void loadProps() {
        try {
            FileInputStream fis = new FileInputStream("props/set.properties");
            this.anzeigeprops.load(fis);
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            AnzeigePropertiesHelper.setDefaults();
        }
    }

    public void saveProps() {
        try {
            FileOutputStream fos = new FileOutputStream("props/set.properties");
            this.anzeigeprops.store(fos, "set main properties");
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initLicenseParam() {
        this.licenceParam = new LicenseParam(){
            KeyStoreParam a = new KeyStoreParam(){

                @Override
                public InputStream getStream() throws IOException {
                    String resourceName = "/keystore/publicSETCerts.store";
                    InputStream in = this.getClass().getResourceAsStream("/keystore/publicSETCerts.store");
                    if (in == null) {
                        throw new FileNotFoundException("/keystore/publicSETCerts.store");
                    }
                    return in;
                }

                @Override
                public String getAlias() {
                    return Passwort.deobfuscate("1y7v1yte1sho1u2w1thh1th51u2e1shu1yt81y83");
                }

                @Override
                public String getStorePwd() {
                    return Passwort.deobfuscate("1ym71wmh1jda1vgf1jg01wnp1ym7");
                }

                @Override
                public String getKeyPwd() {
                    return null;
                }
            };
            CipherParam b = new CipherParam(){

                @Override
                public String getKeyPwd() {
                    return Passwort.deobfuscate("1x111saj1y0s19q71y0y1sar1x1l");
                }
            };

            @Override
            public String getSubject() {
                return AnzeigeMaster.SUBJECT;
            }

            @Override
            public Preferences getPreferences() {
                return Preferences.userRoot().node("/set/pointpanelksisas");
            }

            @Override
            public KeyStoreParam getKeyStoreParam() {
                return this.a;
            }

            @Override
            public CipherParam getCipherParam() {
                return this.b;
            }
        };
    }

    private void initLicenseManager() {
        this.licenseManager = new LicenseManager(AnzeigeMaster.getInstance().getLicenceParam());
    }

    public void initLicenseContent() {
        try {
            this.licenseContent = AnzeigeMaster.getInstance().getLicenseManager().verify();
            if (AnzeigeMaster.getInstance().getLicenseContent() != null && LicenseHelper.LBL.containsKey(Passwort.obfuscate(AnzeigeMaster.getInstance().getLicenseContent().getHolder().toString().substring(AnzeigeMaster.getInstance().getLicenseContent().getHolder().toString().indexOf("=") + 1)))) {
                LicenseHelper.deleteLicense();
                AnzeigeMaster.getInstance().initLicenseManager();
                this.licenseContent = AnzeigeMaster.getInstance().getLicenseManager().verify();
            }
        }
        catch (Exception e) {
            this.licenseContent = null;
        }
    }

    public void checkLicense() {
        if (AnzeigeMaster.getInstance().getLicenseContent() == null) {
            // empty if block
        }
    }

    public LicenseParam getLicenceParam() {
        return this.licenceParam;
    }

    public void setLicenceParam(LicenseParam licenceParam) {
        this.licenceParam = licenceParam;
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public LicenseContent getLicenseContent() {
        if (this.licenseContent == null && this.templicensecontent != null) {
            return this.templicensecontent;
        }
        return this.licenseContent;
    }

    public void setLicenseContent(LicenseContent licenseContent) {
        this.licenseContent = licenseContent;
    }

    public String getLangueage() {
        return this.langueage;
    }

    public void setLangueage(String langueage) {
        if (langueage != null && !langueage.equals("")) {
            this.langueage = langueage;
            this.actualizeResourceBundle();
            UIManager.put("OptionPane.cancelButtonText", AnzeigeResource.getResourceString("logon.button.cancel"));
            UIManager.put("OptionPane.noButtonText", AnzeigeResource.getResourceString("general.no"));
            UIManager.put("OptionPane.okButtonText", AnzeigeResource.getResourceString("general.ok"));
            UIManager.put("OptionPane.yesButtonText", AnzeigeResource.getResourceString("general.yes"));
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (resourceBundle == null) {
                this.actualizeResourceBundle();
            }
        }
        catch (MissingResourceException x) {
            resourceBundle = null;
        }
        return resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        AnzeigeMaster.resourceBundle = resourceBundle;
    }

    private void actualizeResourceBundle() {
        if (AnzeigeMaster.getInstance().getLangueage().equals("deutsch")) {
            resourceBundle = ResourceBundle.getBundle("languages.deutsch_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("english")) {
            resourceBundle = ResourceBundle.getBundle("languages.english_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("czech")) {
            resourceBundle = ResourceBundle.getBundle("languages.czech_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("francais")) {
            resourceBundle = ResourceBundle.getBundle("languages.francais_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("francais")) {
            resourceBundle = ResourceBundle.getBundle("languages.francais_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("turkce")) {
            resourceBundle = ResourceBundle.getBundle("languages.turkce_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("magyar")) {
            resourceBundle = ResourceBundle.getBundle("languages.magyar_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("italiano")) {
            resourceBundle = ResourceBundle.getBundle("languages.italiano_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("russian")) {
            resourceBundle = ResourceBundle.getBundle("languages.russian_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("nederlandse")) {
            resourceBundle = ResourceBundle.getBundle("languages.nederlandse_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u4e2d\u6587")) {
            resourceBundle = ResourceBundle.getBundle("languages.chinese_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac")) {
            resourceBundle = ResourceBundle.getBundle("languages.greek_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("espanol")) {
            resourceBundle = ResourceBundle.getBundle("languages.espanol_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("dansk")) {
            resourceBundle = ResourceBundle.getBundle("languages.danish_ppksisas");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("portugu\u00eas")) {
            resourceBundle = ResourceBundle.getBundle("languages.portuguese_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("c\u0440\u043f\u0441\u043a\u0438")) {
            resourceBundle = ResourceBundle.getBundle("languages.serbian_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u0641\u0627\u0631\u0633\u06cc")) {
            resourceBundle = ResourceBundle.getBundle("languages.persian_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u0639\u0631\u0628\u0649")) {
            resourceBundle = ResourceBundle.getBundle("languages.arabic_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("rom\u00e2n\u0103")) {
            resourceBundle = ResourceBundle.getBundle("languages.romana_pp");
        }
    }

    public void resetMatchtime() {
        this.matchtime.clear();
    }

    public void setMatchtimeRound(int round, int seconds) {
        int time = MatchtimeHelper.getMatchtime() - seconds;
        this.matchtime.put(round, time);
    }

    public int getMatchtime() {
        int totalmatchtime = 0;
        for (int round : this.matchtime.keySet()) {
            totalmatchtime += this.matchtime.get(round).intValue();
        }
        return totalmatchtime;
    }

    public Object getAth1() {
        return this.ath1;
    }

    public void setAth1(Object ath1) {
        this.ath1 = ath1;
    }

    public Object getAth2() {
        return this.ath2;
    }

    public void setAth2(Object ath2) {
        this.ath2 = ath2;
    }

    public Object getClub1() {
        return this.club1;
    }

    public void setClub1(Object club1) {
        this.club1 = club1;
    }

    public Object getClub2() {
        return this.club2;
    }

    public void setClub2(Object club2) {
        this.club2 = club2;
    }

    public Object getNat1() {
        return this.nat1;
    }

    public void setNat1(Object nat1) {
        this.nat1 = nat1;
    }

    public Object getNat2() {
        return this.nat2;
    }

    public void setNat2(Object nat2) {
        this.nat2 = nat2;
    }

    public Object getCat() {
        return this.cat;
    }

    public void setCat(Object cat) {
        this.cat = cat;
    }

    public void setMatchtime(HashMap<Integer, Integer> matchtime) {
        this.matchtime = matchtime;
    }

    public boolean isIsembedded() {
        return this.isembedded;
    }

    public void setIsembedded(boolean isembedded) {
        this.isembedded = isembedded;
    }
}

