/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppksisas.anzeigeIS.tone;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class ToneMixer
extends JFrame {
    public ToneMixer() {
        super("Audio Tone");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception e) {
            System.err.println("Internal Look And Feel Setting Error.");
            System.err.println(e);
        }
        JPanel pMain = new JPanel(new BorderLayout());
        final JSlider sTone = new JSlider(1, 200, 2000, 441);
        sTone.setPaintLabels(true);
        sTone.setPaintTicks(true);
        sTone.setMajorTickSpacing(200);
        sTone.setMinorTickSpacing(100);
        sTone.setToolTipText("Tone (in Hertz or cycles per second - middle C is 441 Hz)");
        sTone.setBorder(new TitledBorder("Frequency"));
        pMain.add((Component)sTone, "Center");
        final JSlider sDuration = new JSlider(1, 0, 2000, 1000);
        sDuration.setPaintLabels(true);
        sDuration.setPaintTicks(true);
        sDuration.setMajorTickSpacing(200);
        sDuration.setMinorTickSpacing(100);
        sDuration.setToolTipText("Duration in milliseconds");
        sDuration.setBorder(new TitledBorder("Length"));
        pMain.add((Component)sDuration, "East");
        final JSlider sVolume = new JSlider(1, 0, 100, 20);
        sVolume.setPaintLabels(true);
        sVolume.setPaintTicks(true);
        sVolume.setSnapToTicks(false);
        sVolume.setMajorTickSpacing(20);
        sVolume.setMinorTickSpacing(10);
        sVolume.setToolTipText("Volume 0 - none, 100 - full");
        sVolume.setBorder(new TitledBorder("Volume"));
        pMain.add((Component)sVolume, "West");
        final JCheckBox cbHarmonic = new JCheckBox("Add Harmonic", true);
        cbHarmonic.setToolTipText("..else pure sine tone");
        JButton bGenerate = new JButton("Generate Tone");
        bGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                try {
                    ToneMixer.generateTone(sTone.getValue(), sDuration.getValue(), (int)((double)sVolume.getValue() * 1.28), cbHarmonic.isSelected());
                }
                catch (LineUnavailableException lue) {
                    System.out.println(lue);
                }
            }
        });
        JPanel pNorth = new JPanel(new BorderLayout());
        pNorth.add((Component)bGenerate, "West");
        pNorth.add((Component)cbHarmonic, "East");
        pMain.add((Component)pNorth, "North");
        pMain.setBorder(new EmptyBorder(5, 3, 5, 3));
        this.getContentPane().add(pMain);
        this.pack();
        this.setLocation(0, 20);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        String address = "/image/tone32x32.png";
        URL url = this.getClass().getResource(address);
        if (url != null) {
            Image icon = Toolkit.getDefaultToolkit().getImage(url);
            this.setIconImage(icon);
        }
    }

    public static void generateTone(int hz, int msecs, int volume, boolean addHarmonic) throws LineUnavailableException {
        AudioFormat af;
        byte[] buf;
        float frequency = 10000.0f;
        if (addHarmonic) {
            buf = new byte[2];
            af = new AudioFormat(frequency, 8, 2, true, false);
        } else {
            buf = new byte[1];
            af = new AudioFormat(frequency, 8, 1, true, false);
        }
        SourceDataLine sdl = AudioSystem.getSourceDataLine(af);
        sdl = AudioSystem.getSourceDataLine(af);
        sdl.open(af);
        sdl.start();
        int i = 0;
        while ((float)i < (float)msecs * frequency / 1000.0f) {
            double angle = (double)((float)i / (frequency / (float)hz)) * 2.0 * Math.PI;
            buf[0] = (byte)(Math.sin(angle) * (double)volume);
            if (addHarmonic) {
                double angle2 = (double)((float)i / (frequency / (float)hz)) * 2.0 * Math.PI;
                buf[1] = (byte)(Math.sin(2.0 * angle2) * (double)volume * 0.6);
                sdl.write(buf, 0, 2);
            } else {
                sdl.write(buf, 0, 1);
            }
            ++i;
        }
        sdl.drain();
        sdl.stop();
        sdl.close();
    }
}

