/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.ui;

import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.pdfbox.debugger.PDFDebugger;
import org.apache.pdfbox.debugger.ui.ImageTypeMenu;
import org.apache.pdfbox.debugger.ui.MenuBase;
import org.apache.pdfbox.debugger.ui.RenderDestinationMenu;
import org.apache.pdfbox.debugger.ui.RotationMenu;
import org.apache.pdfbox.debugger.ui.ZoomMenu;

public class ViewMenu
extends MenuBase {
    private static ViewMenu instance;
    private static final String SHOW_TEXT_STRIPPER = "Show TextStripper TextPositions";
    private static final String SHOW_TEXT_STRIPPER_BEADS = "Show TextStripper Beads";
    private static final String SHOW_FONT_BBOX = "Show Approximate Text Bounds";
    private static final String SHOW_GLYPH_BOUNDS = "Show Glyph Bounds";
    private static final String ALLOW_SUBSAMPLING = "Allow subsampling";
    private static final String EXTRACT_TEXT = "Extract Text";
    private static final String REPAIR_ACROFORM = "Repair AcroForm";
    private JMenuItem viewModeItem;
    private JCheckBoxMenuItem showTextStripper;
    private JCheckBoxMenuItem showTextStripperBeads;
    private JCheckBoxMenuItem showFontBBox;
    private JCheckBoxMenuItem showGlyphBounds;
    private JCheckBoxMenuItem allowSubsampling;
    private JMenuItem extractTextMenuItem;
    private JCheckBoxMenuItem repairAcroFormMenuItem;
    private final PDFDebugger pdfDebugger;

    private ViewMenu(PDFDebugger pdfDebugger) {
        this.pdfDebugger = pdfDebugger;
        this.setMenu(this.createViewMenu());
    }

    public static ViewMenu getInstance(PDFDebugger pdfDebugger) {
        if (instance == null) {
            instance = new ViewMenu(pdfDebugger);
        }
        return instance;
    }

    public static boolean isRenderingOption(String actionCommand) {
        return SHOW_TEXT_STRIPPER.equals(actionCommand) || SHOW_TEXT_STRIPPER_BEADS.equals(actionCommand) || SHOW_FONT_BBOX.equals(actionCommand) || SHOW_GLYPH_BOUNDS.equals(actionCommand) || ALLOW_SUBSAMPLING.equals(actionCommand);
    }

    public static boolean isShowTextStripper() {
        return ViewMenu.instance.showTextStripper.isSelected();
    }

    public static boolean isShowTextStripperBeads() {
        return ViewMenu.instance.showTextStripperBeads.isSelected();
    }

    public static boolean isShowFontBBox() {
        return ViewMenu.instance.showFontBBox.isSelected();
    }

    public static boolean isShowGlyphBounds() {
        return ViewMenu.instance.showGlyphBounds.isSelected();
    }

    public static boolean isExtractTextEvent(ActionEvent actionEvent) {
        return EXTRACT_TEXT.equals(actionEvent.getActionCommand());
    }

    public static boolean isAllowSubsampling() {
        return ViewMenu.instance.allowSubsampling.isSelected();
    }

    public static boolean isRepairAcroformEvent(ActionEvent actionEvent) {
        return REPAIR_ACROFORM.equals(actionEvent.getActionCommand());
    }

    public static boolean isRepairAcroformSelected() {
        return ViewMenu.instance.repairAcroFormMenuItem.isSelected();
    }

    private JMenu createViewMenu() {
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');
        this.viewModeItem = this.pdfDebugger.isPageMode() ? new JMenuItem("Show Internal Structure") : new JMenuItem("Show Pages");
        this.viewModeItem.addActionListener(actionEvent -> {
            if (this.pdfDebugger.isPageMode()) {
                this.viewModeItem.setText("Show Pages");
                this.pdfDebugger.setPageMode(false);
            } else {
                this.viewModeItem.setText("Show Internal Structure");
                this.pdfDebugger.setPageMode(true);
            }
            if (this.pdfDebugger.hasDocument()) {
                this.pdfDebugger.initTree();
            }
        });
        viewMenu.add(this.viewModeItem);
        ZoomMenu zoomMenu = ZoomMenu.getInstance();
        zoomMenu.setEnableMenu(false);
        viewMenu.add(zoomMenu.getMenu());
        RotationMenu rotationMenu = RotationMenu.getInstance();
        rotationMenu.setEnableMenu(false);
        viewMenu.add(rotationMenu.getMenu());
        ImageTypeMenu imageTypeMenu = ImageTypeMenu.getInstance();
        imageTypeMenu.setEnableMenu(false);
        viewMenu.add(imageTypeMenu.getMenu());
        RenderDestinationMenu renderDestinationMenu = RenderDestinationMenu.getInstance();
        renderDestinationMenu.setEnableMenu(false);
        viewMenu.add(renderDestinationMenu.getMenu());
        viewMenu.addSeparator();
        this.showTextStripper = new JCheckBoxMenuItem(SHOW_TEXT_STRIPPER);
        this.showTextStripper.setEnabled(false);
        viewMenu.add(this.showTextStripper);
        this.showTextStripperBeads = new JCheckBoxMenuItem(SHOW_TEXT_STRIPPER_BEADS);
        this.showTextStripperBeads.setEnabled(false);
        viewMenu.add(this.showTextStripperBeads);
        this.showFontBBox = new JCheckBoxMenuItem(SHOW_FONT_BBOX);
        this.showFontBBox.setEnabled(false);
        viewMenu.add(this.showFontBBox);
        this.showGlyphBounds = new JCheckBoxMenuItem(SHOW_GLYPH_BOUNDS);
        this.showGlyphBounds.setEnabled(false);
        viewMenu.add(this.showGlyphBounds);
        viewMenu.addSeparator();
        this.allowSubsampling = new JCheckBoxMenuItem(ALLOW_SUBSAMPLING);
        this.allowSubsampling.setEnabled(false);
        viewMenu.add(this.allowSubsampling);
        viewMenu.addSeparator();
        this.extractTextMenuItem = new JMenuItem(EXTRACT_TEXT);
        this.extractTextMenuItem.setEnabled(false);
        viewMenu.add(this.extractTextMenuItem);
        viewMenu.addSeparator();
        this.repairAcroFormMenuItem = new JCheckBoxMenuItem(REPAIR_ACROFORM);
        this.repairAcroFormMenuItem.setEnabled(false);
        viewMenu.add(this.repairAcroFormMenuItem);
        return viewMenu;
    }
}

