/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.eula;

import com.sun.javafx.eula.EulaImpl;
import com.sun.javafx.runtime.SystemProperties;
import java.applet.Applet;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javafx.lang.FX;
import javax.net.ssl.HttpsURLConnection;
import netscape.javascript.JSObject;

public class Ping {
    private static final boolean USE_NONPROD_SUITE = false;
    private static final boolean DEBUG = false;
    private static final String OMNITURE_URL = "https://sjremetrics.java.com/b/ss//6";
    private static final String JAVAFX_USER_INITIATED_INSTALL_METHOD = "jfxuii";
    private static final String JAVAFX_INSTALL_COMPLETED_PING = "jfxic";
    private static final String JAVAFX_INITIAL_USE_PING = "jfxiu";
    private static final String JAVAFX_APP_USED_PING = "jfxappused";
    private static final int JAVAFX_RETURNCODE_SUCCESS = 0;
    private static final String XML_VERSION_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>";
    private static final String REQUEST_BEGIN = "<request>";
    private static final String REQUEST_END = "</request>";
    private static final String XMLVER = "sc_xml_ver";
    private static final String REPORT_SUITEID = "reportsuiteid";
    private static final String VISITOR_ID = "visitorid";
    private static final String DUPLICATE_VISITOR_ID = "prop21";
    private static final String STATE = "pagename";
    private static final String EVENTS = "events";
    private static final String ARCH_JAVA = "evar4";
    private static final String ARCH_OS = "evar5";
    private static final String PLATFORM_OS = "evar6";
    private static final String INSTALL_METHOD = "evar7";
    private static final String COUNTRYCODE = "evar8";
    private static final String CURRENT_JAVAFX_VERSION = "evar16";
    private static final String REQUESTED_JAVAFX_VERSION = "evar17";
    private static final String CURRENT_JAVA_VERSION = "evar18";
    private static final String CPU = "evar24";
    private static final String LOCALE = "evar25";
    private static final String BROWSER = "evar26";
    private static final String APPLET_URL = "evar31";
    private static final String APPLET_DOMAIN = "evar32";
    private static final String PASSWD = "prop20";
    private static final String COMPLETE_STATUS = "products";
    private static final String JAVAFX_INSTALL_COMPLETED_EVENT = "event20";
    private static final String JAVAFX_INITIAL_USE_EVENT = "event21";
    private static final String JAVAFX_APP_USED_EVENT = "event22";
    private static final String PRODUCTION_PASSWD = "b3e9fd";
    private static final String PROD_JFX_REPORT_SUITEID = "sunjfxinstallstat";
    private static final String NONPROD_JFX_REPORT_SUITEID = "sunjfxinstallstatdev";
    private static final String PING_SENT_FILENAME = ".javafx_ping_sent";
    private static final String RUNNING_JAVAFX_VERSION = SystemProperties.getProperty((String)"javafx.version");
    private static final String JAVA_VERSION = System.getProperty("java.version");
    private static final String DISABLE_APP_USED_PING = System.getProperty("jnlp.javafx.disableping");
    StringBuffer pingSB = new StringBuffer();
    private String pagename = null;
    private String eventID = null;
    private String visitorID = null;
    private String appletUrl = "dummy";
    private String appletDomain = "dummy";

    public Ping(String name, String vid) {
        this.visitorID = vid;
        this.pagename = name;
        if (JAVAFX_INSTALL_COMPLETED_PING.equals(name)) {
            this.eventID = JAVAFX_INSTALL_COMPLETED_EVENT;
        } else if (JAVAFX_INITIAL_USE_PING.equals(name)) {
            this.eventID = JAVAFX_INITIAL_USE_EVENT;
        } else if (JAVAFX_APP_USED_PING.equals(name)) {
            this.eventID = JAVAFX_APP_USED_EVENT;
        }
    }

    private static String getVisitorID() {
        Random r = new Random((long)System.getProperty("user.name").hashCode() + System.currentTimeMillis());
        StringBuffer vid = new StringBuffer(Long.toHexString(r.nextLong()));
        vid.append("-");
        vid.append(Long.toHexString(r.nextLong()));
        return vid.toString();
    }

    private boolean useNonProdSuite() {
        return RUNNING_JAVAFX_VERSION.indexOf("-internal") != -1;
    }

    private String getBrowserInfo() {
        String browserInfo = null;
        Applet applet = (Applet)FX.getArgument((String)"javafx.applet");
        if (applet != null) {
            try {
                JSObject window = JSObject.getWindow((Applet)applet);
                browserInfo = window.eval("window.navigator.userAgent.toLowerCase()").toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return browserInfo;
    }

    private void addPingAttribute(String name, String value) {
        this.pingSB.append("<");
        this.pingSB.append(name);
        this.pingSB.append(">");
        this.pingSB.append(value);
        this.pingSB.append("</");
        this.pingSB.append(name);
        this.pingSB.append(">");
    }

    private void createPingString() {
        String cpuInfo;
        this.pingSB.append(XML_VERSION_HEADER);
        this.pingSB.append(REQUEST_BEGIN);
        this.addPingAttribute(XMLVER, "1.0");
        String reportSuite = PROD_JFX_REPORT_SUITEID;
        if (this.useNonProdSuite()) {
            reportSuite = NONPROD_JFX_REPORT_SUITEID;
        }
        this.addPingAttribute(REPORT_SUITEID, reportSuite);
        this.addPingAttribute(VISITOR_ID, this.visitorID);
        this.addPingAttribute(DUPLICATE_VISITOR_ID, this.visitorID);
        this.addPingAttribute(PASSWD, PRODUCTION_PASSWD);
        this.addPingAttribute(STATE, this.pagename);
        this.addPingAttribute(ARCH_JAVA, System.getProperty("sun.arch.data.model"));
        this.addPingAttribute(ARCH_OS, System.getProperty("os.arch"));
        StringBuffer osName = new StringBuffer(System.getProperty("os.name"));
        String osPatchLevel = System.getProperty("sun.os.patch.level");
        if (osPatchLevel != null && !osPatchLevel.equalsIgnoreCase("unknown")) {
            osName.append(" ");
            osName.append(osPatchLevel);
        }
        String osVersion = System.getProperty("os.version");
        if (osPatchLevel != null) {
            osName.append(" ");
            osName.append(osVersion);
        }
        this.addPingAttribute(PLATFORM_OS, osName.toString());
        this.addPingAttribute(INSTALL_METHOD, JAVAFX_USER_INITIATED_INSTALL_METHOD);
        this.addPingAttribute(COUNTRYCODE, System.getProperty("user.country"));
        String oldJavaFXVersions = Ping.getPingSentVersions();
        if (oldJavaFXVersions != null) {
            this.addPingAttribute(CURRENT_JAVAFX_VERSION, oldJavaFXVersions);
        }
        this.addPingAttribute(REQUESTED_JAVAFX_VERSION, RUNNING_JAVAFX_VERSION);
        this.addPingAttribute(CURRENT_JAVA_VERSION, JAVA_VERSION);
        if (JAVAFX_APP_USED_EVENT.equals(this.eventID)) {
            this.addPingAttribute(APPLET_URL, this.appletUrl);
            this.addPingAttribute(APPLET_DOMAIN, this.appletDomain);
        }
        if ((cpuInfo = System.getProperty("sun.cpu.isalist")) != null && !cpuInfo.trim().equals("")) {
            this.addPingAttribute(CPU, cpuInfo);
        }
        this.addPingAttribute(LOCALE, System.getProperty("user.language"));
        String browserName = this.getBrowserInfo();
        if (browserName != null) {
            this.addPingAttribute(BROWSER, browserName);
        }
        this.addPingAttribute(EVENTS, this.eventID);
        this.addPingAttribute(COMPLETE_STATUS, ";jfx|0");
        this.pingSB.append(REQUEST_END);
    }

    private static String getPingSentFilePath() {
        StringBuffer pingSentFilePath = new StringBuffer(EulaImpl.getHomeDirectory());
        pingSentFilePath.append(PING_SENT_FILENAME);
        return pingSentFilePath.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recordPingSentToFile(String pingSentNames) {
        FileOutputStream fos = null;
        try {
            File pingSentFile = new File(Ping.getPingSentFilePath());
            if (!pingSentFile.exists()) {
                pingSentFile.createNewFile();
            }
            StringBuffer versionStringToWrite = new StringBuffer();
            versionStringToWrite.append(RUNNING_JAVAFX_VERSION);
            versionStringToWrite.append(" ");
            versionStringToWrite.append(pingSentNames);
            versionStringToWrite.append("\n");
            fos = new FileOutputStream(pingSentFile, true);
            fos.write(versionStringToWrite.toString().getBytes());
            fos.flush();
        }
        catch (IOException ioe) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPing() {
        FilterOutputStream output = null;
        FilterInputStream input = null;
        try {
            URL url = new URL(OMNITURE_URL);
            HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            output = new DataOutputStream(connection.getOutputStream());
            ((DataOutputStream)output).writeBytes(this.pingSB.toString());
            output.close();
            input = new DataInputStream(connection.getInputStream());
            int c = input.read();
            while (c != -1) {
                c = input.read();
            }
            input.close();
        }
        catch (Exception e) {
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException ioe) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    private void initAndSend() {
        this.createPingString();
        this.sendPing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getPingSentVersions() {
        FileInputStream fis = null;
        String pingSentVersions = null;
        try {
            File pingSentFile = new File(Ping.getPingSentFilePath());
            if (!pingSentFile.exists()) {
                String string = null;
                return string;
            }
            BufferedReader br = new BufferedReader(new FileReader(pingSentFile));
            String s = br.readLine();
            StringBuffer sb = null;
            while (s != null) {
                int index;
                if (sb == null) {
                    sb = new StringBuffer();
                }
                if ((index = s.indexOf(" ")) == -1) {
                    sb.append(s);
                } else {
                    sb.append(s.substring(0, index));
                }
                sb.append(" ");
                s = br.readLine();
            }
            if (sb != null) {
                pingSentVersions = sb.toString();
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {}
            }
        }
        return pingSentVersions;
    }

    private static boolean isPingAlreadySentForCurrentFXVersion() {
        String pingSentVersions = Ping.getPingSentVersions();
        if (pingSentVersions == null) {
            return false;
        }
        return pingSentVersions.indexOf(RUNNING_JAVAFX_VERSION) != -1;
    }

    public static void send() {
        Thread t = new Thread("JFXIC-Ping Thread"){

            public void run() {
                Ping jfxappusedPing;
                String id = Ping.getVisitorID();
                if (!"true".equals(DISABLE_APP_USED_PING) && Ping.testIfPingEnabled() && (jfxappusedPing = new Ping(Ping.JAVAFX_APP_USED_PING, id)).setUrlAndDomain()) {
                    jfxappusedPing.initAndSend();
                }
                if (Ping.isPingAlreadySentForCurrentFXVersion()) {
                    return;
                }
                StringBuffer pingSentNames = new StringBuffer();
                Ping jfxiuPing = new Ping(Ping.JAVAFX_INITIAL_USE_PING, id);
                jfxiuPing.initAndSend();
                pingSentNames.append(Ping.JAVAFX_INITIAL_USE_PING);
                String osName = System.getProperty("os.name");
                boolean isWindows = osName.toLowerCase().startsWith("windows");
                if (isWindows && "1.6.0_12".compareTo(JAVA_VERSION) > 0 || !isWindows) {
                    Ping jfxicPing = new Ping(Ping.JAVAFX_INSTALL_COMPLETED_PING, id);
                    jfxicPing.initAndSend();
                    pingSentNames.append(" ");
                    pingSentNames.append(Ping.JAVAFX_INSTALL_COMPLETED_PING);
                }
                Ping.recordPingSentToFile(pingSentNames.toString());
            }
        };
        t.setDaemon(true);
        t.start();
    }

    private boolean setUrlAndDomain() {
        URL baseURL = null;
        Object applet = FX.getArgument((String)"javafx.applet");
        if (applet != null && applet instanceof Applet) {
            baseURL = ((Applet)applet).getCodeBase();
            if (baseURL.toString().startsWith("http") || baseURL.toString().startsWith("https")) {
                this.appletUrl = baseURL.toString();
                this.appletDomain = baseURL.getHost();
            }
            if (this.appletUrl != null && this.appletDomain != null) {
                return true;
            }
        }
        return false;
    }

    private static boolean testIfPingEnabled() {
        String value;
        boolean isValid = false;
        Object applet = FX.getArgument((String)"javafx.applet");
        if (applet != null && applet instanceof Applet && "true".equals(value = ((Applet)applet).getParameter("kisawesome"))) {
            isValid = true;
        }
        return isValid;
    }
}

