/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.TransformFilter;
import java.awt.Rectangle;
import java.awt.geom.Point2D;

public class CircleFilter
extends TransformFilter {
    private float radius = 10.0f;
    private float height = 20.0f;
    private float angle = 0.0f;
    private float centreX = 0.5f;
    private float centreY = 0.5f;
    private float icentreX;
    private float icentreY;
    private float iWidth;
    private float iHeight;
    private float ir2;
    private float or2;

    public CircleFilter() {
        this.setEdgeAction(0);
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public float getHeight() {
        return this.height;
    }

    public void setAngle(float angle) {
        this.angle = angle;
    }

    public float getAngle() {
        return this.angle;
    }

    public void setRadius(float r) {
        this.radius = r;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setCentreX(float centreX) {
        this.centreX = centreX;
    }

    public float getCentreX() {
        return this.centreX;
    }

    public void setCentreY(float centreY) {
        this.centreY = centreY;
    }

    public float getCentreY() {
        return this.centreY;
    }

    public void setCentre(Point2D centre) {
        this.centreX = (float)centre.getX();
        this.centreY = (float)centre.getY();
    }

    public Point2D getCentre() {
        return new Point2D.Float(this.centreX, this.centreY);
    }

    protected int[] filterPixels(int width, int height, int[] inPixels, Rectangle transformedSpace) {
        this.iWidth = width;
        this.iHeight = height;
        this.icentreX = (float)width * this.centreX;
        this.icentreY = (float)height * this.centreY;
        this.ir2 = this.radius * this.radius;
        this.or2 = (this.radius + (float)height) * (this.radius + (float)height);
        return super.filterPixels(width, height, inPixels, transformedSpace);
    }

    protected void transformInverse(int x, int y, float[] out) {
        float dx = (float)x - this.icentreX;
        float dy = (float)y - this.icentreY;
        float x2 = dx * dx;
        float y2 = dy * dy;
        float distance2 = dx * dx + dy * dy;
        float theta = (float)Math.atan2(-dy, dx) - this.angle;
        float distance = (float)Math.sqrt(distance2);
        out[0] = this.iWidth * theta / (float)Math.PI;
        out[1] = this.iHeight * (distance - this.radius) / (this.height + 1.0E-4f);
    }

    public String toString() {
        return "Distort/Circle...";
    }
}

